/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft;

import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.raft.jraft.Node;
import org.apache.ignite.raft.jraft.NodeManager;
import org.apache.ignite.raft.jraft.core.NodeImpl;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.option.NodeOptions;
import org.apache.ignite.raft.jraft.option.RpcOptions;
import org.apache.ignite.raft.jraft.rpc.RpcServer;
import org.apache.ignite.raft.jraft.util.Endpoint;
import org.apache.ignite.raft.jraft.util.StringUtils;

public class RaftGroupService {
    private static final IgniteLogger LOG = Loggers.forClass(RaftGroupService.class);
    private volatile boolean started = false;
    private PeerId serverId;
    private NodeOptions nodeOptions;
    private RpcServer rpcServer;
    private String groupId;
    private Node node;
    private NodeManager nodeManager;

    public RaftGroupService(String groupId, PeerId serverId, NodeOptions nodeOptions, RpcServer rpcServer, NodeManager nodeManager) {
        this.groupId = groupId;
        this.serverId = serverId;
        this.nodeOptions = nodeOptions;
        this.rpcServer = rpcServer;
        this.nodeManager = nodeManager;
    }

    public synchronized Node getRaftNode() {
        return this.node;
    }

    public synchronized Node start() {
        if (this.started) {
            return this.node;
        }
        if (this.serverId == null || this.serverId.getEndpoint() == null || this.serverId.getEndpoint().equals(new Endpoint("0.0.0.0", 0))) {
            throw new IllegalArgumentException("Blank serverId:" + this.serverId);
        }
        if (StringUtils.isBlank(this.groupId)) {
            throw new IllegalArgumentException("Blank group id" + this.groupId);
        }
        assert (this.nodeOptions.getRpcClient() != null);
        this.node = new NodeImpl(this.groupId, this.serverId);
        if (!this.node.init(this.nodeOptions)) {
            LOG.warn("Stopping partially started node [groupId={}, serverId={}]", new Object[]{this.groupId, this.serverId});
            this.node.shutdown();
            try {
                this.node.join();
            }
            catch (InterruptedException e) {
                throw new IgniteInternalException((Throwable)e);
            }
            throw new IgniteInternalException("Fail to init node, please see the logs to find the reason.");
        }
        this.nodeManager.add(this.node);
        this.started = true;
        LOG.info("Start the RaftGroupService successfully {}", new Object[]{this.node.getNodeId()});
        return this.node;
    }

    public synchronized void shutdown() {
        if (!this.started) {
            return;
        }
        this.node.shutdown();
        try {
            this.node.join();
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting for the node to shutdown", new Object[0]);
        }
        this.nodeManager.remove(this.node);
        this.started = false;
        LOG.info("Stop the RaftGroupService successfully.", new Object[0]);
    }

    public boolean isStarted() {
        return this.started;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        if (this.started) {
            throw new IllegalStateException("Raft group service already started");
        }
        this.groupId = groupId;
    }

    public PeerId getServerId() {
        return this.serverId;
    }

    public void setServerId(PeerId serverId) {
        if (this.started) {
            throw new IllegalStateException("Raft group service already started");
        }
        this.serverId = serverId;
    }

    public RpcOptions getNodeOptions() {
        return this.nodeOptions;
    }

    public void setNodeOptions(NodeOptions nodeOptions) {
        if (this.started) {
            throw new IllegalStateException("Raft group service already started");
        }
        if (nodeOptions == null) {
            throw new IllegalArgumentException("Invalid node options.");
        }
        nodeOptions.validate();
        this.nodeOptions = nodeOptions;
    }

    public RpcServer getRpcServer() {
        return this.rpcServer;
    }

    public void setRpcServer(RpcServer rpcServer) {
        if (this.started) {
            throw new IllegalStateException("Raft group service already started");
        }
        if (this.serverId == null) {
            throw new IllegalStateException("Please set serverId at first");
        }
        if (rpcServer.boundPort() != this.serverId.getPort()) {
            throw new IllegalArgumentException("RPC server port mismatch");
        }
        this.rpcServer = rpcServer;
    }
}

