/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.raft.server.impl.JraftServerImpl;
import org.apache.ignite.raft.client.Command;
import org.apache.ignite.raft.client.ReadCommand;
import org.apache.ignite.raft.client.WriteCommand;
import org.apache.ignite.raft.client.service.CommandClosure;
import org.apache.ignite.raft.jraft.Closure;
import org.apache.ignite.raft.jraft.Node;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.closure.ReadIndexClosure;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.entity.Task;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.ActionRequest;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.RpcContext;
import org.apache.ignite.raft.jraft.rpc.RpcProcessor;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.impl.SMCompactedThrowable;
import org.apache.ignite.raft.jraft.rpc.impl.SMFullThrowable;
import org.apache.ignite.raft.jraft.util.BytesUtil;
import org.apache.ignite.raft.jraft.util.JDKMarshaller;

public class ActionRequestProcessor
implements RpcProcessor<ActionRequest> {
    private static final IgniteLogger LOG = Loggers.forClass(ActionRequestProcessor.class);
    private final Executor executor;
    private final RaftMessagesFactory factory;

    public ActionRequestProcessor(Executor executor, RaftMessagesFactory factory) {
        this.executor = executor;
        this.factory = factory;
    }

    @Override
    public void handleRequest(RpcContext rpcCtx, ActionRequest request) {
        Node node = rpcCtx.getNodeManager().get(request.groupId(), new PeerId(rpcCtx.getLocalAddress()));
        if (node == null) {
            rpcCtx.sendResponse(this.factory.errorResponse().errorCode(RaftError.UNKNOWN.getNumber()).build());
            return;
        }
        if (request.command() instanceof WriteCommand) {
            this.applyWrite(node, request, rpcCtx);
        } else {
            this.applyRead(node, request, rpcCtx);
        }
    }

    private void applyWrite(final Node node, ActionRequest request, final RpcContext rpcCtx) {
        node.apply(new Task(ByteBuffer.wrap(JDKMarshaller.DEFAULT.marshall(request.command())), new CommandClosureImpl<Command>(request.command()){

            public void result(Serializable res) {
                if (res instanceof Throwable) {
                    ActionRequestProcessor.this.sendSMError(rpcCtx, (Throwable)res, true);
                    return;
                }
                rpcCtx.sendResponse(ActionRequestProcessor.this.factory.actionResponse().result(res).build());
            }

            @Override
            public void run(Status status) {
                assert (!status.isOk()) : status;
                ActionRequestProcessor.this.sendRaftError(rpcCtx, status, node);
            }
        }));
    }

    private void applyRead(final Node node, final ActionRequest request, final RpcContext rpcCtx) {
        if (request.readOnlySafe()) {
            node.readIndex(BytesUtil.EMPTY_BYTES, new ReadIndexClosure(){

                @Override
                public void run(Status status, long index, byte[] reqCtx) {
                    if (status.isOk()) {
                        JraftServerImpl.DelegatingStateMachine fsm = (JraftServerImpl.DelegatingStateMachine)node.getOptions().getFsm();
                        try {
                            fsm.getListener().onRead(List.of(new CommandClosure<ReadCommand>(){

                                public ReadCommand command() {
                                    return (ReadCommand)request.command();
                                }

                                public void result(Serializable res) {
                                    if (res instanceof Throwable) {
                                        ActionRequestProcessor.this.sendSMError(rpcCtx, (Throwable)res, true);
                                        return;
                                    }
                                    rpcCtx.sendResponse(ActionRequestProcessor.this.factory.actionResponse().result(res).build());
                                }
                            }).iterator());
                        }
                        catch (Exception e) {
                            ActionRequestProcessor.this.sendRaftError(rpcCtx, RaftError.ESTATEMACHINE, e.getMessage());
                        }
                    } else {
                        ActionRequestProcessor.this.sendRaftError(rpcCtx, status, node);
                    }
                }
            });
        } else {
            JraftServerImpl.DelegatingStateMachine fsm = (JraftServerImpl.DelegatingStateMachine)node.getOptions().getFsm();
            try {
                fsm.getListener().onRead(List.of(new CommandClosure<ReadCommand>(){

                    public ReadCommand command() {
                        return (ReadCommand)request.command();
                    }

                    public void result(Serializable res) {
                        if (res instanceof Throwable) {
                            ActionRequestProcessor.this.sendSMError(rpcCtx, (Throwable)res, true);
                            return;
                        }
                        rpcCtx.sendResponse(ActionRequestProcessor.this.factory.actionResponse().result(res).build());
                    }
                }).iterator());
            }
            catch (Exception e) {
                this.sendRaftError(rpcCtx, RaftError.ESTATEMACHINE, e.getMessage());
            }
        }
    }

    @Override
    public String interest() {
        return ActionRequest.class.getName();
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    private void sendRaftError(RpcContext ctx, RaftError error, String msg) {
        RpcRequests.ErrorResponse resp = this.factory.errorResponse().errorCode(error.getNumber()).errorMsg(msg).build();
        ctx.sendResponse(resp);
    }

    private void sendSMError(RpcContext ctx, Throwable th, boolean compacted) {
        RpcRequests.SMErrorResponse resp = this.factory.sMErrorResponse().error(compacted ? new SMCompactedThrowable(th) : new SMFullThrowable(th)).build();
        ctx.sendResponse(resp);
        LOG.info("Error occurred on a user's state machine", th);
    }

    private void sendRaftError(RpcContext ctx, Status status, Node node) {
        RaftError raftError = status.getRaftError();
        Message response = raftError == RaftError.EPERM && node.getLeaderId() != null ? RaftRpcFactory.DEFAULT.newResponse(node.getLeaderId().toString(), this.factory, RaftError.EPERM, status.getErrorMsg(), new Object[0]) : RaftRpcFactory.DEFAULT.newResponse(this.factory, raftError, status.getErrorMsg(), new Object[0]);
        ctx.sendResponse(response);
    }

    private static abstract class CommandClosureImpl<T extends Command>
    implements Closure,
    CommandClosure<T> {
        private final T command;

        public CommandClosureImpl(T command) {
            this.command = command;
        }

        public T command() {
            return this.command;
        }
    }
}

