/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.freelist;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.datastructure.DataStructure;
import org.apache.ignite.internal.pagememory.freelist.CorruptedFreeListException;
import org.apache.ignite.internal.pagememory.freelist.io.PagesListMetaIo;
import org.apache.ignite.internal.pagememory.freelist.io.PagesListNodeIo;
import org.apache.ignite.internal.pagememory.io.AbstractDataPageIo;
import org.apache.ignite.internal.pagememory.io.IoVersions;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagememory.reuse.ReuseBag;
import org.apache.ignite.internal.pagememory.util.PageHandler;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteSystemProperties;
import org.jetbrains.annotations.Nullable;

public abstract class PagesList
extends DataStructure {
    public static final String IGNITE_PAGES_LIST_TRY_LOCK_ATTEMPTS = "IGNITE_PAGES_LIST_TRY_LOCK_ATTEMPTS";
    public static final String IGNITE_PAGES_LIST_STRIPES_PER_BUCKET = "IGNITE_PAGES_LIST_STRIPES_PER_BUCKET";
    public static final String IGNITE_PAGES_LIST_DISABLE_ONHEAP_CACHING = "IGNITE_PAGES_LIST_DISABLE_ONHEAP_CACHING";
    private final int tryLockAttempts = IgniteSystemProperties.getInteger((String)"IGNITE_PAGES_LIST_TRY_LOCK_ATTEMPTS", (int)10);
    private final int maxStripesPerBucket = IgniteSystemProperties.getInteger((String)"IGNITE_PAGES_LIST_STRIPES_PER_BUCKET", (int)Math.max(8, Runtime.getRuntime().availableProcessors()));
    private final boolean pagesListCachingDisabled = IgniteSystemProperties.getBoolean((String)"IGNITE_PAGES_LIST_DISABLE_ONHEAP_CACHING", (boolean)false);
    protected final IgniteLogger log;
    protected final AtomicLongArray bucketsSize;
    protected volatile boolean changed;
    protected volatile boolean pageCacheChanged;
    private final long metaPageId;
    private final int buckets;
    private volatile boolean onheapListCachingEnabled;
    private final PageHandler<Void, Boolean> cutTail = new CutTail();
    private final PageHandler<Void, Boolean> putBucket = new PutBucket();

    protected PagesList(String name, int grpId, int partId, PageMemory pageMem, PageLockListener lockLsnr, IgniteLogger log, int buckets, long metaPageId) {
        super(name, grpId, null, partId, pageMem, lockLsnr, (byte)2);
        this.log = log;
        this.buckets = buckets;
        this.metaPageId = metaPageId;
        this.onheapListCachingEnabled = this.isCachingApplicable();
        this.bucketsSize = new AtomicLongArray(buckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void init(long metaPageId, boolean initNew) throws IgniteInternalCheckedException {
        if (metaPageId != 0L) {
            if (initNew) {
                this.init(metaPageId, PagesListMetaIo.VERSIONS.latest());
            } else {
                HashMap<Integer, LongArrayList> bucketsData = new HashMap<Integer, LongArrayList>();
                long nextId = metaPageId;
                while (nextId != 0L) {
                    long pageId = nextId;
                    long page = this.acquirePage(pageId, IoStatisticsHolderNoOp.INSTANCE);
                    try {
                        long pageAddr = this.readLock(pageId, page);
                        assert (pageAddr != 0L);
                        try {
                            PagesListMetaIo io = PagesListMetaIo.VERSIONS.forPage(pageAddr);
                            io.getBucketsData(pageAddr, bucketsData);
                            nextId = io.getNextMetaPageId(pageAddr);
                            assert (nextId != pageId) : "Loop detected [next=" + IgniteUtils.hexLong((long)nextId) + ", cur=" + IgniteUtils.hexLong((long)pageId) + "]";
                        }
                        finally {
                            this.readUnlock(pageId, page, pageAddr);
                        }
                    }
                    finally {
                        this.releasePage(pageId, page);
                    }
                }
                for (Map.Entry e : bucketsData.entrySet()) {
                    int bucket = (Integer)e.getKey();
                    long bucketSize = 0L;
                    Stripe[] old = this.getBucket(bucket);
                    assert (old == null);
                    long[] upd = ((LongArrayList)e.getValue()).toLongArray();
                    Stripe[] tails = new Stripe[upd.length];
                    for (int i = 0; i < upd.length; ++i) {
                        Stripe stripe;
                        long tailId;
                        long prevId = tailId = upd[i];
                        int cnt = 0;
                        while (prevId != 0L) {
                            long pageId = prevId;
                            long page = this.acquirePage(pageId, IoStatisticsHolderNoOp.INSTANCE);
                            try {
                                long pageAddr = this.readLock(pageId, page);
                                assert (pageAddr != 0L);
                                try {
                                    PagesListNodeIo io = PagesListNodeIo.VERSIONS.forPage(pageAddr);
                                    cnt += io.getCount(pageAddr);
                                    prevId = io.getPreviousId(pageAddr);
                                    if (!this.isReuseBucket(bucket) || prevId == 0L) continue;
                                    ++cnt;
                                }
                                finally {
                                    this.readUnlock(pageId, page, pageAddr);
                                }
                            }
                            finally {
                                this.releasePage(pageId, page);
                            }
                        }
                        tails[i] = stripe = new Stripe(tailId, cnt == 0);
                        bucketSize += (long)cnt;
                    }
                    boolean ok = this.casBucket(bucket, null, tails);
                    assert (ok);
                    this.bucketsSize.set(bucket, bucketSize);
                }
            }
        }
    }

    private boolean isCachingApplicable() {
        return !this.pagesListCachingDisabled;
    }

    protected void saveMetadata(IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        long nextPageId = this.metaPageId;
        assert (nextPageId != 0L);
        this.flushBucketsCache(statHolder);
        if (!this.changed) {
            return;
        }
        this.changed = false;
        try {
            long unusedPageId = this.writeFreeList(nextPageId);
            this.markUnusedPagesDirty(unusedPageId);
        }
        catch (Throwable e) {
            this.changed = true;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBucketsCache(IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        if (!this.isCachingApplicable() || !this.pageCacheChanged) {
            return;
        }
        this.pageCacheChanged = false;
        this.onheapListCachingEnabled = false;
        int lockedPages = 0;
        try {
            for (int bucket = 0; bucket < this.buckets; ++bucket) {
                LongArrayList pages;
                PagesCache pagesCache = this.getBucketCache(bucket, false);
                if (pagesCache == null || (pages = pagesCache.flush()) == null) continue;
                this.log.debug("Move pages from heap to PageMemory [list={}, bucket={}, pages={}]", new Object[]{this.name(), bucket, pages});
                for (int i = 0; i < pages.size(); ++i) {
                    long pageId = pages.getLong(i);
                    this.log.debug("Move page from heap to PageMemory [list={}, bucket={}, pageId={}]", new Object[]{this.name(), bucket, pageId});
                    Boolean res = this.write(pageId, this.putBucket, bucket, null, statHolder);
                    if (res != null) continue;
                    pagesCache.add(pageId);
                    ++lockedPages;
                }
            }
        }
        finally {
            this.onheapListCachingEnabled = true;
        }
        if (lockedPages != 0) {
            this.log.info("Several pages were locked and weren't flushed on disk [grp={}, lockedPages={}]", new Object[]{this.grpName, lockedPages});
            this.pageCacheChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeFreeList(long nextPageId) throws IgniteInternalCheckedException {
        long curId = 0L;
        long curPage = 0L;
        long curAddr = 0L;
        PagesListMetaIo curIo = null;
        try {
            for (int bucket = 0; bucket < this.buckets; ++bucket) {
                Stripe[] tails = this.getBucket(bucket);
                if (tails == null) continue;
                int tailIdx = 0;
                while (tailIdx < tails.length) {
                    int written;
                    int n = written = curPage != 0L ? curIo.addTails(this.pageMem.realPageSize(this.grpId), curAddr, bucket, tails, tailIdx) : 0;
                    if (written == 0) {
                        if (nextPageId == 0L) {
                            nextPageId = this.allocatePageNoReuse();
                            if (curPage != 0L) {
                                curIo.setNextMetaPageId(curAddr, nextPageId);
                                this.releaseAndWriteUnlock(curId, curPage, curAddr);
                            }
                            curId = nextPageId;
                            curPage = this.acquirePage(curId, IoStatisticsHolderNoOp.INSTANCE);
                            curAddr = this.writeLock(curId, curPage);
                            curIo = PagesListMetaIo.VERSIONS.latest();
                            curIo.initNewPage(curAddr, curId, this.pageSize());
                        } else {
                            this.releaseAndWriteUnlock(curId, curPage, curAddr);
                            curId = nextPageId;
                            curPage = this.acquirePage(curId, IoStatisticsHolderNoOp.INSTANCE);
                            curAddr = this.writeLock(curId, curPage);
                            curIo = PagesListMetaIo.VERSIONS.forPage(curAddr);
                            curIo.resetCount(curAddr);
                        }
                        nextPageId = curIo.getNextMetaPageId(curAddr);
                        continue;
                    }
                    tailIdx += written;
                }
            }
        }
        finally {
            this.releaseAndWriteUnlock(curId, curPage, curAddr);
        }
        return nextPageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markUnusedPagesDirty(long nextPageId) throws IgniteInternalCheckedException {
        while (nextPageId != 0L) {
            long pageId = nextPageId;
            long page = this.acquirePage(pageId, IoStatisticsHolderNoOp.INSTANCE);
            try {
                long pageAddr = this.writeLock(pageId, page);
                try {
                    PagesListMetaIo io = PagesListMetaIo.VERSIONS.forPage(pageAddr);
                    io.resetCount(pageAddr);
                    nextPageId = io.getNextMetaPageId(pageAddr);
                }
                finally {
                    this.writeUnlock(pageId, page, pageAddr, true);
                }
            }
            finally {
                this.releasePage(pageId, page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAndWriteUnlock(long pageId, long page, long pageAddr) {
        if (page != 0L) {
            try {
                this.writeUnlock(pageId, page, pageAddr, true);
            }
            finally {
                this.releasePage(pageId, page);
            }
        }
    }

    protected abstract int getBucketIndex(int var1);

    @Nullable
    protected abstract Stripe[] getBucket(int var1);

    protected abstract boolean casBucket(int var1, Stripe[] var2, Stripe[] var3);

    protected abstract boolean isReuseBucket(int var1);

    @Nullable
    protected abstract PagesCache getBucketCache(int var1, boolean var2);

    private void setupNextPage(PagesListNodeIo io, long prevId, long prev, long nextId, long next) {
        assert (io.getNextId(prev) == 0L);
        io.initNewPage(next, nextId, this.pageSize());
        io.setPreviousId(next, prevId);
        io.setNextId(prev, nextId);
    }

    private Stripe addStripe(int bucket, ReuseBag bag, boolean reuse) throws IgniteInternalCheckedException {
        Stripe[] upd;
        Stripe[] old;
        long pageId = this.allocatePage(bag, reuse);
        this.init(pageId, PagesListNodeIo.VERSIONS.latest());
        Stripe stripe = new Stripe(pageId, true);
        do {
            if ((old = this.getBucket(bucket)) != null) {
                int len = old.length;
                upd = Arrays.copyOf(old, len + 1);
                upd[len] = stripe;
                continue;
            }
            upd = new Stripe[]{stripe};
        } while (!this.casBucket(bucket, old, upd));
        this.changed();
        return stripe;
    }

    private boolean updateTail(int bucket, long oldTailId, long newTailId) {
        int idx = -1;
        try {
            while (true) {
                Object[] tails = this.getBucket(bucket);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Update tail [list={}, bucket={}, oldTailId={}, newTailId={}, tails={}]", new Object[]{this.name(), bucket, oldTailId, newTailId, Arrays.toString(tails)});
                }
                assert (!ArrayUtils.nullOrEmpty((Object[])tails)) : "Missing tails [bucket=" + bucket + ", tails=" + Arrays.toString(tails) + ", metaPage=" + IgniteUtils.hexLong((long)this.metaPageId) + ", grpId=" + this.grpId + "]";
                idx = PagesList.findTailIndex((Stripe[])tails, oldTailId, idx);
                assert (((Stripe)tails[idx]).tailId == oldTailId);
                if (newTailId == 0L) {
                    if (tails.length <= this.maxStripesPerBucket / 2) {
                        ((Stripe)tails[idx]).empty = true;
                        boolean bl = false;
                        return bl;
                    }
                    Stripe[] newTails = tails.length != 1 ? (Stripe[])ArrayUtils.remove((Object[])tails, (int)idx) : null;
                    if (this.casBucket(bucket, (Stripe[])tails, newTails)) {
                        ((Stripe)tails[idx]).tailId = 0L;
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    ((Stripe)tails[idx]).tailId = newTailId;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.changed();
        }
    }

    private static int findTailIndex(Stripe[] tails, long tailId, int expIdx) {
        if (expIdx != -1 && tails.length > expIdx && tails[expIdx].tailId == tailId) {
            return expIdx;
        }
        for (int i = 0; i < tails.length; ++i) {
            if (tails[i].tailId != tailId) continue;
            return i;
        }
        throw new IllegalStateException("Tail not found: " + tailId);
    }

    private Stripe getStripeForPut(int bucket, ReuseBag bag) throws IgniteInternalCheckedException {
        Stripe[] tails = this.getBucket(bucket);
        if (tails == null) {
            return this.addStripe(bucket, bag, true);
        }
        return PagesList.randomTail(tails);
    }

    private static Stripe randomTail(Stripe[] tails) {
        int len = tails.length;
        assert (len != 0);
        return tails[PagesList.randomInt(len)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long storedPagesCount(int bucket) throws IgniteInternalCheckedException {
        long res = 0L;
        Stripe[] tails = this.getBucket(bucket);
        if (tails != null) {
            for (Stripe tail : tails) {
                long tailId = tail.tailId;
                while (tailId != 0L) {
                    long pageId = tailId;
                    long page = this.acquirePage(pageId, IoStatisticsHolderNoOp.INSTANCE);
                    try {
                        long pageAddr = this.readLock(pageId, page);
                        assert (pageAddr != 0L);
                        try {
                            PagesListNodeIo io = PagesListNodeIo.VERSIONS.forPage(pageAddr);
                            int cnt = io.getCount(pageAddr);
                            assert (cnt >= 0);
                            res += (long)cnt;
                            tailId = io.getPreviousId(pageAddr);
                            if (!this.isReuseBucket(bucket) || tailId == 0L) continue;
                            ++res;
                        }
                        finally {
                            this.readUnlock(pageId, page, pageAddr);
                        }
                    }
                    finally {
                        this.releasePage(pageId, page);
                    }
                }
            }
        }
        assert (res == this.bucketsSize.get(bucket)) : "Wrong bucket size counter [exp=" + res + ", cntr=" + this.bucketsSize.get(bucket) + "]";
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void put(@Nullable ReuseBag bag, long dataId, long dataAddr, int bucket, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        assert (bag == null ^ dataAddr == 0L);
        if (bag != null && bag.isEmpty()) {
            return;
        }
        if (bag == null && this.onheapListCachingEnabled && this.putDataPage(this.getBucketCache(bucket, true), dataId, dataAddr, bucket)) {
            this.log.debug("Put page to pages list cache [list={}, bucket={}, dataId={}]", new Object[]{this.name(), bucket, dataId});
            return;
        }
        int lockAttempt = 0;
        while (true) {
            Stripe stripe = this.getStripeForPut(bucket, bag);
            if (bag != null && bag.isEmpty()) {
                return;
            }
            long tailId = stripe.tailId;
            if (tailId == 0L) continue;
            long tailPage = this.acquirePage(tailId, statHolder);
            try {
                long tailAddr = this.writeLockPage(tailId, tailPage, bucket, lockAttempt++, bag);
                if (tailAddr == 0L) {
                    if (bag == null || !bag.isEmpty()) continue;
                    return;
                }
                if (stripe.tailId != tailId) {
                    this.writeUnlock(tailId, tailPage, tailAddr, false);
                    --lockAttempt;
                    continue;
                }
                assert (PageIo.getPageId(tailAddr) == tailId) : "tailId = " + IgniteUtils.hexLong((long)tailId) + ", pageId = " + IgniteUtils.hexLong((long)PageIo.getPageId(tailAddr));
                assert (PageIo.getType(tailAddr) == 2) : "tailId = " + IgniteUtils.hexLong((long)tailId) + ", type = " + PageIo.getType(tailAddr);
                boolean ok = false;
                try {
                    PagesListNodeIo io = (PagesListNodeIo)this.pageMem.ioRegistry().resolve(tailAddr);
                    ok = bag != null ? this.putReuseBag(tailId, tailAddr, io, bag, bucket, statHolder) : this.putDataPage(tailId, tailAddr, io, dataId, dataAddr, bucket, statHolder);
                    if (!ok) continue;
                    this.log.debug("Put page to pages list [list={}, bucket={}, dataId={}, tailId={}]", new Object[]{this.name(), bucket, dataId, tailId});
                    stripe.empty = false;
                    return;
                }
                finally {
                    this.writeUnlock(tailId, tailPage, tailAddr, ok);
                    continue;
                }
            }
            finally {
                this.releasePage(tailId, tailPage);
                continue;
            }
            break;
        }
    }

    private boolean putDataPage(long pageId, long pageAddr, PagesListNodeIo io, long dataId, long dataAddr, int bucket, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        if (io.getNextId(pageAddr) != 0L) {
            return false;
        }
        int idx = io.addPage(pageAddr, dataId, this.pageSize());
        if (idx == -1) {
            this.handlePageFull(pageId, pageAddr, io, dataId, dataAddr, bucket, statHolder);
        } else {
            this.incrementBucketSize(bucket);
            AbstractDataPageIo dataIo = (AbstractDataPageIo)this.pageMem.ioRegistry().resolve(dataAddr);
            dataIo.setFreeListPageId(dataAddr, pageId);
        }
        return true;
    }

    private boolean putDataPage(PagesCache pagesCache, long dataId, long dataAddr, int bucket) throws IgniteInternalCheckedException {
        if (pagesCache.add(dataId)) {
            this.incrementBucketSize(bucket);
            AbstractDataPageIo dataIo = (AbstractDataPageIo)this.pageMem.ioRegistry().resolve(dataAddr);
            if (dataIo.getFreeListPageId(dataAddr) != 0L) {
                dataIo.setFreeListPageId(dataAddr, 0L);
            }
            this.pageCacheChanged();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePageFull(long pageId, long pageAddr, PagesListNodeIo io, long dataId, long dataAddr, int bucket, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        AbstractDataPageIo dataIo = (AbstractDataPageIo)this.pageMem.ioRegistry().resolve(dataAddr);
        if (this.isReuseBucket(bucket)) {
            assert (dataIo.isEmpty(dataAddr));
            long newDataId = PageIdUtils.changeFlag(dataId, (byte)2);
            this.setupNextPage(io, pageId, pageAddr, newDataId, dataAddr);
            this.incrementBucketSize(bucket);
            this.updateTail(bucket, pageId, newDataId);
        } else {
            long nextId = this.allocatePage(null);
            long nextPage = this.acquirePage(nextId, statHolder);
            try {
                long nextPageAddr = this.writeLock(nextId, nextPage);
                assert (nextPageAddr != 0L);
                try {
                    this.setupNextPage(io, pageId, pageAddr, nextId, nextPageAddr);
                    int idx = io.addPage(nextPageAddr, dataId, this.pageSize());
                    assert (idx != -1);
                    dataIo.setFreeListPageId(dataAddr, nextId);
                    this.incrementBucketSize(bucket);
                    this.updateTail(bucket, pageId, nextId);
                }
                finally {
                    this.writeUnlock(nextId, nextPage, nextPageAddr, true);
                }
            }
            finally {
                this.releasePage(nextId, nextPage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putReuseBag(long pageId, long pageAddr, PagesListNodeIo io, ReuseBag bag, int bucket, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        assert (bag != null) : "bag is null";
        assert (!bag.isEmpty()) : "bag is empty";
        if (io.getNextId(pageAddr) != 0L) {
            return false;
        }
        long prevId = pageId;
        long prevAddr = pageAddr;
        LongArrayList locked = null;
        try {
            long nextId;
            while ((nextId = bag.pollFreePage()) != 0L) {
                assert (PageIdUtils.itemId(nextId) > 0 && PageIdUtils.itemId(nextId) <= 254) : IgniteUtils.hexLong((long)nextId);
                int idx = io.addPage(prevAddr, nextId, this.pageSize());
                if (idx == -1) {
                    long nextPage = this.acquirePage(nextId, statHolder);
                    try {
                        long nextPageAddr = this.writeLock(nextId, nextPage);
                        assert (nextPageAddr != 0L);
                        if (locked == null) {
                            locked = new LongArrayList(6);
                        }
                        locked.add(nextId);
                        locked.add(nextPage);
                        locked.add(nextPageAddr);
                        this.setupNextPage(io, prevId, prevAddr, nextId, nextPageAddr);
                        if (this.isReuseBucket(bucket)) {
                            this.incrementBucketSize(bucket);
                        }
                        prevAddr = nextPageAddr;
                        prevId = nextId;
                        continue;
                    }
                    finally {
                        this.releasePage(nextId, nextPage);
                        continue;
                    }
                }
                this.incrementBucketSize(bucket);
            }
        }
        finally {
            if (locked != null) {
                this.updateTail(bucket, pageId, prevId);
                for (int i = 0; i < locked.size(); i += 3) {
                    this.writeUnlock(locked.getLong(i), locked.getLong(i + 1), locked.getLong(i + 2), true);
                }
            }
        }
        return true;
    }

    @Nullable
    private Stripe getStripeForTake(int bucket) {
        int init;
        Stripe[] tails = this.getBucket(bucket);
        if (tails == null || this.bucketsSize.get(bucket) == 0L) {
            return null;
        }
        int len = tails.length;
        int cur = init = PagesList.randomInt(len);
        do {
            Stripe stripe = tails[cur];
            if (stripe.empty) continue;
            return stripe;
        } while ((cur = (cur + 1) % len) != init);
        return null;
    }

    private long writeLockPage(long pageId, long page, int bucket, int lockAttempt, ReuseBag bag) throws IgniteInternalCheckedException {
        Stripe[] stripes;
        long pageAddr = this.tryWriteLock(pageId, page);
        if (pageAddr != 0L) {
            return pageAddr;
        }
        if (lockAttempt == this.tryLockAttempts && ((stripes = this.getBucket(bucket)) == null || stripes.length < this.maxStripesPerBucket)) {
            this.addStripe(bucket, bag, !this.isReuseBucket(bucket));
            return 0L;
        }
        return lockAttempt < this.tryLockAttempts ? 0L : this.writeLock(pageId, page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long takeEmptyPage(int bucket, @Nullable IoVersions<?> initIoVers, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        long pageId;
        PagesCache pagesCache = this.getBucketCache(bucket, false);
        if (pagesCache != null && (pageId = pagesCache.poll()) != 0L) {
            this.decrementBucketSize(bucket);
            this.log.debug("Take page from pages list cache [list={}, bucket={}, pageId={}]", new Object[]{this.name(), bucket, pageId});
            assert (!this.isReuseBucket(bucket)) : "reuse bucket detected";
            return pageId;
        }
        int lockAttempt = 0;
        Stripe stripe;
        while ((stripe = this.getStripeForTake(bucket)) != null) {
            long tailId = stripe.tailId;
            if (tailId == 0L) continue;
            long tailPage = this.acquirePage(tailId, statHolder);
            try {
                long dataPageId;
                long tailAddr;
                if ((tailAddr = this.writeLockPage(tailId, tailPage, bucket, lockAttempt++, null)) == 0L) continue;
                if (stripe.empty || stripe.tailId != tailId) {
                    this.writeUnlock(tailId, tailPage, tailAddr, false);
                    if (this.bucketsSize.get(bucket) > 0L) {
                        --lockAttempt;
                        continue;
                    }
                    long l = 0L;
                    return l;
                }
                assert (PageIo.getPageId(tailAddr) == tailId) : "tailId = " + IgniteUtils.hexLong((long)tailId) + ", pageId = " + IgniteUtils.hexLong((long)PageIo.getPageId(tailAddr));
                assert (PageIo.getType(tailAddr) == 2) : "tailId = " + IgniteUtils.hexLong((long)tailId) + ", type = " + PageIo.getType(tailAddr);
                boolean dirty = false;
                long recycleId = 0L;
                try {
                    PagesListNodeIo io = PagesListNodeIo.VERSIONS.forPage(tailAddr);
                    if (io.getNextId(tailAddr) != 0L) continue;
                    pageId = io.takeAnyPage(tailAddr);
                    if (pageId != 0L) {
                        this.decrementBucketSize(bucket);
                        dirty = true;
                        if (this.isReuseBucket(bucket) && (PageIdUtils.itemId(pageId) <= 0 || PageIdUtils.itemId(pageId) > 254)) {
                            throw this.corruptedFreeListException("Incorrectly recycled pageId in reuse bucket: " + IgniteUtils.hexLong((long)pageId), pageId);
                        }
                        if (this.isReuseBucket(bucket)) {
                            byte flag = this.getFlag(initIoVers);
                            PageIo initIo = initIoVers == null ? null : (PageIo)initIoVers.latest();
                            dataPageId = this.initRecycledPage0(pageId, flag, initIo);
                        } else {
                            dataPageId = pageId;
                        }
                        if (io.isEmpty(tailAddr)) {
                            long prevId = io.getPreviousId(tailAddr);
                            if (!this.isReuseBucket(bucket)) {
                                if (prevId != 0L) {
                                    Boolean ok = this.write(prevId, this.cutTail, null, bucket, Boolean.FALSE, statHolder);
                                    assert (ok == Boolean.TRUE) : ok;
                                    recycleId = this.recyclePage(tailId, tailAddr);
                                } else {
                                    stripe.empty = true;
                                }
                            } else {
                                stripe.empty = prevId == 0L;
                            }
                        }
                    } else {
                        assert (this.isReuseBucket(bucket));
                        long prevId = io.getPreviousId(tailAddr);
                        assert (prevId != 0L);
                        Boolean ok = this.write(prevId, this.cutTail, bucket, Boolean.FALSE, statHolder);
                        assert (ok == Boolean.TRUE) : ok;
                        this.decrementBucketSize(bucket);
                        byte flag = this.getFlag(initIoVers);
                        PageIo pageIo = initIoVers != null ? (PageIo)initIoVers.latest() : null;
                        dataPageId = this.initReusedPage(tailId, tailAddr, PageIdUtils.partitionId(tailId), flag, pageIo);
                        dirty = true;
                    }
                }
                finally {
                    this.writeUnlock(tailId, tailPage, tailAddr, dirty);
                    continue;
                }
                if (recycleId != 0L) {
                    assert (!this.isReuseBucket(bucket));
                    this.reuseList.addForRecycle(new SingletonReuseBag(recycleId));
                }
                this.log.debug("Take page from pages list [list={}, bucket={}, dataPageId={}, tailId={}]", new Object[]{this.name(), bucket, dataPageId, tailId});
                long l = dataPageId;
                return l;
            }
            finally {
                this.releasePage(tailId, tailPage);
                continue;
            }
            break;
        }
        return 0L;
    }

    private byte getFlag(@Nullable IoVersions<?> initIoVers) {
        if (initIoVers != null) {
            Object pageIo = initIoVers.latest();
            return ((PageIo)pageIo).getFlag();
        }
        return this.defaultPageFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long initRecycledPage0(long pageId, byte flag, PageIo initIo) throws IgniteInternalCheckedException {
        long page = this.pageMem.acquirePage(this.grpId, pageId);
        try {
            long l;
            long pageAddr = this.pageMem.writeLock(this.grpId, pageId, page);
            try {
                l = this.initReusedPage(pageId, pageAddr, PageIdUtils.partitionId(pageId), flag, initIo);
            }
            catch (Throwable throwable) {
                this.pageMem.writeUnlock(this.grpId, pageId, page, true);
                throw throwable;
            }
            this.pageMem.writeUnlock(this.grpId, pageId, page, true);
            return l;
        }
        finally {
            this.pageMem.releasePage(this.grpId, pageId, page);
        }
    }

    protected final long initReusedPage(long reusedPageId, long reusedPageAddr, int partId, byte flag, PageIo initIo) {
        long storedPageId;
        int itemId;
        long newPageId = PageIdUtils.pageId(partId, flag, PageIdUtils.pageIndex(reusedPageId));
        if (initIo != null) {
            initIo.initNewPage(reusedPageAddr, newPageId, this.pageSize());
        }
        if ((itemId = PageIdUtils.itemId(reusedPageId)) != 0) {
            if (flag == 1) {
                PageIo.setRotatedIdPart(reusedPageAddr, itemId);
            } else {
                newPageId = PageIdUtils.link(newPageId, itemId);
            }
        }
        if ((storedPageId = PageIo.getPageId(reusedPageAddr)) != newPageId) {
            PageIo.setPageId(reusedPageAddr, newPageId);
        }
        return newPageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean removeDataPage(long dataId, long dataAddr, AbstractDataPageIo dataIo, int bucket, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        long pageId = dataIo.getFreeListPageId(dataAddr);
        if (pageId == 0L) {
            assert (this.isCachingApplicable()) : "pageId==0L, but caching is not applicable for this pages list: " + this.name();
            PagesCache pagesCache = this.getBucketCache(bucket, false);
            if (pagesCache == null || !pagesCache.removePage(dataId)) {
                this.log.debug("Remove page from pages list cache failed [list={}, bucket={}, dataId={}, reason={}]", new Object[]{this.name(), bucket, dataId, pagesCache == null ? "cache is null" : "page not found"});
                return false;
            }
            this.decrementBucketSize(bucket);
            this.log.debug("Remove page from pages list cache [list={}, bucket={}, dataId={}]", new Object[]{this.name(), bucket, dataId});
            return true;
        }
        this.log.debug("Remove page from pages list [list={}, bucket={}, dataId={}, pageId={}]", new Object[]{this.name(), bucket, dataId, pageId});
        long page = this.acquirePage(pageId, statHolder);
        try {
            long nextId;
            long recycleId = 0L;
            long pageAddr = this.writeLock(pageId, page);
            if (pageAddr == 0L) {
                boolean bl = false;
                return bl;
            }
            boolean rmvd = false;
            try {
                PagesListNodeIo io = PagesListNodeIo.VERSIONS.forPage(pageAddr);
                rmvd = io.removePage(pageAddr, dataId);
                if (!rmvd) {
                    boolean bl = false;
                    return bl;
                }
                this.decrementBucketSize(bucket);
                dataIo.setFreeListPageId(dataAddr, 0L);
                if (!io.isEmpty(pageAddr)) {
                    boolean bl = true;
                    return bl;
                }
                nextId = io.getNextId(pageAddr);
                if (nextId == 0L) {
                    long prevId = io.getPreviousId(pageAddr);
                    recycleId = this.mergeNoNext(pageId, pageAddr, prevId, bucket, statHolder);
                }
            }
            finally {
                this.writeUnlock(pageId, page, pageAddr, rmvd);
            }
            if (nextId != 0L) {
                recycleId = this.merge(pageId, page, nextId, bucket, statHolder);
            }
            if (recycleId != 0L) {
                this.reuseList.addForRecycle(new SingletonReuseBag(recycleId));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releasePage(pageId, page);
        }
    }

    private long mergeNoNext(long pageId, long pageAddr, long prevId, int bucket, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        if (this.isReuseBucket(bucket)) {
            return 0L;
        }
        if (prevId != 0L) {
            Boolean ok = this.write(prevId, this.cutTail, null, bucket, Boolean.FALSE, statHolder);
            assert (ok == Boolean.TRUE) : ok;
        } else {
            boolean rmvd = this.updateTail(bucket, pageId, 0L);
            if (!rmvd) {
                return 0L;
            }
        }
        return this.recyclePage(pageId, pageAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long merge(long pageId, long page, long nextId, int bucket, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        assert (nextId != 0L);
        while (true) {
            long curId;
            long curPage = (curId = nextId) == 0L ? 0L : this.acquirePage(curId, statHolder);
            try {
                boolean write = false;
                long curAddr = curPage == 0L ? 0L : this.writeLock(curId, curPage);
                long pageAddr = this.writeLock(pageId, page);
                if (pageAddr == 0L) {
                    if (curAddr != 0L) {
                        this.writeUnlock(curId, curPage, curAddr, false);
                    }
                    long l = 0L;
                    return l;
                }
                try {
                    PagesListNodeIo io = PagesListNodeIo.VERSIONS.forPage(pageAddr);
                    if (!io.isEmpty(pageAddr)) {
                        long l = 0L;
                        return l;
                    }
                    if (io.getNextId(pageAddr) == curId && curId == 0L == (curAddr == 0L)) {
                        long recycleId = this.doMerge(pageId, pageAddr, io, curId, curAddr, bucket, statHolder);
                        write = true;
                        long l = recycleId;
                        return l;
                    }
                    nextId = io.getNextId(pageAddr);
                    continue;
                }
                finally {
                    if (curAddr != 0L) {
                        this.writeUnlock(curId, curPage, curAddr, write);
                    }
                    this.writeUnlock(pageId, page, pageAddr, write);
                    continue;
                }
            }
            finally {
                if (curPage == 0L) continue;
                this.releasePage(curId, curPage);
                continue;
            }
            break;
        }
    }

    private long doMerge(long pageId, long pageAddr, PagesListNodeIo io, long nextId, long nextAddr, int bucket, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        long prevId = io.getPreviousId(pageAddr);
        if (nextId == 0L) {
            return this.mergeNoNext(pageId, pageAddr, prevId, bucket, statHolder);
        }
        assert (PageIo.getPageId(nextAddr) == nextId);
        if (prevId == 0L) {
            assert (PagesListNodeIo.VERSIONS.forPage(nextAddr).getPreviousId(nextAddr) == pageId);
            PagesListNodeIo nextIo = PagesListNodeIo.VERSIONS.forPage(nextAddr);
            nextIo.setPreviousId(nextAddr, 0L);
        } else {
            this.fairMerge(prevId, pageId, nextId, nextAddr, statHolder);
        }
        return this.recyclePage(pageId, pageAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fairMerge(long prevId, long pageId, long nextId, long nextAddr, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        long prevPage = this.acquirePage(prevId, statHolder);
        try {
            long prevAddr = this.writeLock(prevId, prevPage);
            assert (prevAddr != 0L);
            try {
                PagesListNodeIo prevIo = PagesListNodeIo.VERSIONS.forPage(prevAddr);
                PagesListNodeIo nextIo = PagesListNodeIo.VERSIONS.forPage(nextAddr);
                assert (prevIo.getNextId(prevAddr) == pageId);
                assert (nextIo.getPreviousId(nextAddr) == pageId);
                prevIo.setNextId(prevAddr, nextId);
                nextIo.setPreviousId(nextAddr, prevId);
            }
            finally {
                this.writeUnlock(prevId, prevPage, prevAddr, true);
            }
        }
        finally {
            this.releasePage(prevId, prevPage);
        }
    }

    private void incrementBucketSize(int bucket) {
        this.bucketsSize.incrementAndGet(bucket);
    }

    private void decrementBucketSize(int bucket) {
        this.bucketsSize.decrementAndGet(bucket);
    }

    private void changed() {
        if (!this.changed) {
            this.changed = true;
        }
    }

    private void pageCacheChanged() {
        if (!this.pageCacheChanged) {
            this.pageCacheChanged = true;
        }
    }

    public int bucketsCount() {
        return this.buckets;
    }

    public long bucketSize(int bucket) {
        return this.bucketsSize.get(bucket);
    }

    public int stripesCount(int bucket) {
        Stripe[] stripes = this.getBucket(bucket);
        return stripes == null ? 0 : stripes.length;
    }

    public int cachedPagesCount(int bucket) {
        PagesCache pagesCache = this.getBucketCache(bucket, false);
        return pagesCache == null ? 0 : pagesCache.size();
    }

    public long metaPageId() {
        return this.metaPageId;
    }

    protected CorruptedFreeListException corruptedFreeListException(Throwable err, long ... pageIds) {
        return this.corruptedFreeListException(err.getMessage(), err, pageIds);
    }

    protected CorruptedFreeListException corruptedFreeListException(String msg, long ... pageIds) {
        return this.corruptedFreeListException(msg, null, pageIds);
    }

    protected CorruptedFreeListException corruptedFreeListException(String msg, @Nullable Throwable err, long ... pageIds) {
        return new CorruptedFreeListException(msg, err, this.grpId, pageIds);
    }

    public static final class Stripe {
        public volatile long tailId;
        public volatile boolean empty;

        Stripe(long tailId, boolean empty) {
            this.tailId = tailId;
            this.empty = empty;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stripe stripe = (Stripe)o;
            return this.tailId == stripe.tailId && this.empty == stripe.empty;
        }

        public int hashCode() {
            return (31 + Long.hashCode(this.tailId)) * 31 + Boolean.hashCode(this.empty);
        }

        public String toString() {
            return Long.toString(this.tailId);
        }
    }

    public static class PagesCache {
        public static final String IGNITE_PAGES_LIST_CACHING_MAX_CACHE_SIZE = "IGNITE_PAGES_LIST_CACHING_MAX_CACHE_SIZE";
        public static final String IGNITE_PAGES_LIST_CACHING_STRIPES_COUNT = "IGNITE_PAGES_LIST_CACHING_STRIPES_COUNT";
        public static final String IGNITE_PAGES_LIST_CACHING_EMPTY_FLUSH_GC_THRESHOLD = "IGNITE_PAGES_LIST_CACHING_EMPTY_FLUSH_GC_THRESHOLD";
        private static final int MAX_SIZE = IgniteSystemProperties.getInteger((String)"IGNITE_PAGES_LIST_CACHING_MAX_CACHE_SIZE", (int)64);
        private static final int STRIPES_COUNT = IgniteSystemProperties.getInteger((String)"IGNITE_PAGES_LIST_CACHING_STRIPES_COUNT", (int)4);
        private static final int EMPTY_FLUSH_GC_THRESHOLD = IgniteSystemProperties.getInteger((String)"IGNITE_PAGES_LIST_CACHING_EMPTY_FLUSH_GC_THRESHOLD", (int)10);
        private final Object[] stripeLocks = new Object[STRIPES_COUNT];
        private final LongArrayList[] stripes = new LongArrayList[STRIPES_COUNT];
        private static final AtomicIntegerFieldUpdater<PagesCache> nextStripeUpdater = AtomicIntegerFieldUpdater.newUpdater(PagesCache.class, "nextStripeIdx");
        private static final AtomicIntegerFieldUpdater<PagesCache> sizeUpdater = AtomicIntegerFieldUpdater.newUpdater(PagesCache.class, "size");
        private volatile int nextStripeIdx;
        private volatile int size;
        private int emptyFlushCnt;
        @Nullable
        private final AtomicLong pagesCacheLimit;

        public PagesCache(@Nullable AtomicLong pagesCacheLimit) {
            assert (IgniteUtils.isPow2((int)STRIPES_COUNT)) : STRIPES_COUNT;
            for (int i = 0; i < STRIPES_COUNT; ++i) {
                this.stripeLocks[i] = new Object();
            }
            this.pagesCacheLimit = pagesCacheLimit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removePage(long pageId) {
            int stripeIdx = (int)pageId & STRIPES_COUNT - 1;
            Object object = this.stripeLocks[stripeIdx];
            synchronized (object) {
                boolean rmvd;
                LongArrayList stripe = this.stripes[stripeIdx];
                boolean bl = rmvd = stripe != null && stripe.rem(pageId);
                if (rmvd && sizeUpdater.decrementAndGet(this) == 0 && this.pagesCacheLimit != null) {
                    this.pagesCacheLimit.incrementAndGet();
                }
                return rmvd;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long poll() {
            if (this.size == 0) {
                return 0L;
            }
            for (int i = 0; i < STRIPES_COUNT; ++i) {
                int stripeIdx = nextStripeUpdater.getAndIncrement(this) & STRIPES_COUNT - 1;
                Object object = this.stripeLocks[stripeIdx];
                synchronized (object) {
                    LongArrayList stripe = this.stripes[stripeIdx];
                    if (stripe != null && !stripe.isEmpty()) {
                        if (sizeUpdater.decrementAndGet(this) == 0 && this.pagesCacheLimit != null) {
                            this.pagesCacheLimit.incrementAndGet();
                        }
                        return stripe.removeLong(stripe.size() - 1);
                    }
                    continue;
                }
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LongArrayList flush() {
            LongArrayList res = null;
            if (this.size == 0) {
                boolean stripesChanged = false;
                if (this.emptyFlushCnt >= 0 && ++this.emptyFlushCnt >= EMPTY_FLUSH_GC_THRESHOLD) {
                    for (int i = 0; i < STRIPES_COUNT; ++i) {
                        Object object = this.stripeLocks[i];
                        synchronized (object) {
                            LongArrayList stripe = this.stripes[i];
                            if (stripe != null) {
                                if (stripe.isEmpty()) {
                                    this.stripes[i] = null;
                                } else {
                                    stripesChanged = true;
                                    break;
                                }
                            }
                            continue;
                        }
                    }
                    if (!stripesChanged) {
                        this.emptyFlushCnt = -1;
                    }
                }
                if (!stripesChanged) {
                    return null;
                }
            }
            this.emptyFlushCnt = 0;
            for (int i = 0; i < STRIPES_COUNT; ++i) {
                Object object = this.stripeLocks[i];
                synchronized (object) {
                    LongArrayList stripe = this.stripes[i];
                    if (stripe != null && !stripe.isEmpty()) {
                        if (res == null) {
                            res = new LongArrayList(this.size);
                        }
                        if (sizeUpdater.addAndGet(this, -stripe.size()) == 0 && this.pagesCacheLimit != null) {
                            this.pagesCacheLimit.incrementAndGet();
                        }
                        res.addAll((LongList)stripe);
                        stripe.clear();
                    }
                    continue;
                }
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(long pageId) {
            assert (pageId != 0L);
            if (this.size == 0 && this.pagesCacheLimit != null && this.pagesCacheLimit.get() <= 0L) {
                return false;
            }
            if (this.size >= MAX_SIZE) {
                return false;
            }
            int stripeIdx = (int)pageId & STRIPES_COUNT - 1;
            Object object = this.stripeLocks[stripeIdx];
            synchronized (object) {
                LongArrayList stripe = this.stripes[stripeIdx];
                if (stripe == null) {
                    this.stripes[stripeIdx] = stripe = new LongArrayList(MAX_SIZE / STRIPES_COUNT);
                }
                if (stripe.size() >= MAX_SIZE / STRIPES_COUNT) {
                    return false;
                }
                stripe.add(pageId);
                if (sizeUpdater.getAndIncrement(this) == 0 && this.pagesCacheLimit != null) {
                    this.pagesCacheLimit.decrementAndGet();
                }
                return true;
            }
        }

        public int size() {
            return this.size;
        }
    }

    private static final class SingletonReuseBag
    implements ReuseBag {
        long pageId;

        SingletonReuseBag(long pageId) {
            this.pageId = pageId;
        }

        @Override
        public void addFreePage(long pageId) {
            throw new IllegalStateException("Should never be called.");
        }

        @Override
        public long pollFreePage() {
            long res = this.pageId;
            this.pageId = 0L;
            return res;
        }

        @Override
        public boolean isEmpty() {
            return this.pageId == 0L;
        }

        public String toString() {
            return S.toString(SingletonReuseBag.class, (Object)this, (String)"pageId", (Object)IgniteUtils.hexLong((long)this.pageId));
        }
    }

    private final class PutBucket
    implements PageHandler<Void, Boolean> {
        private PutBucket() {
        }

        @Override
        public Boolean run(int cacheId, long pageId, long page, long pageAddr, PageIo iox, Void ignore, int oldBucket, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
            PagesList.this.decrementBucketSize(oldBucket);
            int freeSpace = ((AbstractDataPageIo)iox).getFreeSpace(pageAddr);
            int newBucket = PagesList.this.getBucketIndex(freeSpace);
            if (newBucket != oldBucket) {
                PagesList.this.log.debug("Bucket changed when moving from heap to PageMemory [list={}, oldBucket={}, newBucket={}, pageId={}]", new Object[]{PagesList.this.name(), oldBucket, newBucket, pageId});
            }
            if (newBucket >= 0) {
                PagesList.this.put(null, pageId, pageAddr, newBucket, statHolder);
            }
            return Boolean.TRUE;
        }
    }

    private final class CutTail
    implements PageHandler<Void, Boolean> {
        private CutTail() {
        }

        @Override
        public Boolean run(int cacheId, long pageId, long page, long pageAddr, PageIo iox, Void ignore, int bucket, IoStatisticsHolder statHolder) {
            assert (PageIo.getPageId(pageAddr) == pageId);
            PagesListNodeIo io = (PagesListNodeIo)iox;
            long tailId = io.getNextId(pageAddr);
            assert (tailId != 0L);
            io.setNextId(pageAddr, 0L);
            PagesList.this.updateTail(bucket, tailId, pageId);
            return Boolean.TRUE;
        }
    }
}

