/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite.internal.cluster.management.raft.IllegalInitArgumentException;
import org.apache.ignite.internal.cluster.management.raft.JoinDeniedException;
import org.apache.ignite.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite.internal.cluster.management.raft.commands.JoinRequestCommand;
import org.apache.ignite.internal.cluster.management.raft.commands.NodesLeaveCommand;
import org.apache.ignite.internal.cluster.management.raft.responses.LogicalTopologyResponse;
import org.apache.ignite.internal.cluster.management.raft.responses.ValidationErrorResponse;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.properties.IgniteProductVersion;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.raft.client.Command;
import org.apache.ignite.raft.client.Peer;
import org.apache.ignite.raft.client.service.RaftGroupService;

public class CmgRaftService {
    private static final IgniteLogger LOG = Loggers.forClass(ClusterManagementGroupManager.class);
    private static final int MAX_RESOLVE_ATTEMPTS = 5;
    private final CmgMessagesFactory msgFactory = new CmgMessagesFactory();
    private final RaftGroupService raftService;
    private final ClusterService clusterService;

    public CmgRaftService(RaftGroupService raftService, ClusterService clusterService) {
        this.raftService = raftService;
        this.clusterService = clusterService;
    }

    public CompletableFuture<Boolean> isCurrentNodeLeader() {
        ClusterNode thisNode = this.clusterService.topologyService().localMember();
        return this.leader().thenApply(arg_0 -> ((ClusterNode)thisNode).equals(arg_0));
    }

    private CompletableFuture<ClusterNode> leader() {
        return this.raftService.refreshLeader().thenApply(v -> this.resolvePeer(this.raftService.leader()));
    }

    public CompletableFuture<ClusterState> readClusterState() {
        return this.raftService.run((Command)this.msgFactory.readStateCommand().build()).thenApply(ClusterState.class::cast);
    }

    public CompletableFuture<ClusterState> initClusterState(ClusterState clusterState) {
        ClusterNodeMessage localNodeMessage = this.nodeMessage(this.clusterService.topologyService().localMember());
        return this.raftService.run((Command)this.msgFactory.initCmgStateCommand().node(localNodeMessage).clusterState(clusterState).build()).thenApply(response -> {
            if (response instanceof ValidationErrorResponse) {
                throw new IllegalInitArgumentException("Init CMG request denied, reason: " + ((ValidationErrorResponse)response).reason());
            }
            if (response instanceof ClusterState) {
                return (ClusterState)response;
            }
            throw new IgniteInternalException("Unexpected response: " + response);
        });
    }

    public CompletableFuture<Void> startJoinCluster(ClusterTag clusterTag) {
        ClusterNodeMessage localNodeMessage = this.nodeMessage(this.clusterService.topologyService().localMember());
        JoinRequestCommand command = this.msgFactory.joinRequestCommand().node(localNodeMessage).version(IgniteProductVersion.CURRENT_VERSION.toString()).clusterTag(clusterTag).build();
        return this.raftService.run((Command)command).thenAccept(response -> {
            if (response instanceof ValidationErrorResponse) {
                throw new JoinDeniedException("Join request denied, reason: " + ((ValidationErrorResponse)response).reason());
            }
            if (response != null) {
                throw new IgniteInternalException("Unexpected response: " + response);
            }
            LOG.info("JoinRequest command executed successfully", new Object[0]);
        });
    }

    public CompletableFuture<Void> completeJoinCluster() {
        LOG.info("Node is ready to join the logical topology", new Object[0]);
        ClusterNodeMessage localNodeMessage = this.nodeMessage(this.clusterService.topologyService().localMember());
        return this.raftService.run((Command)this.msgFactory.joinReadyCommand().node(localNodeMessage).build()).thenAccept(response -> {
            if (response instanceof ValidationErrorResponse) {
                throw new JoinDeniedException("JoinReady request denied, reason: " + ((ValidationErrorResponse)response).reason());
            }
            if (response != null) {
                throw new IgniteInternalException("Unexpected response: " + response);
            }
            LOG.info("JoinReady command executed successfully", new Object[0]);
        });
    }

    public CompletableFuture<Void> removeFromCluster(Set<ClusterNode> nodes) {
        NodesLeaveCommand command = this.msgFactory.nodesLeaveCommand().nodes(nodes.stream().map(this::nodeMessage).collect(Collectors.toSet())).build();
        return this.raftService.run((Command)command);
    }

    public CompletableFuture<Collection<ClusterNode>> logicalTopology() {
        return ((CompletableFuture)this.raftService.run((Command)this.msgFactory.readLogicalTopologyCommand().build()).thenApply(LogicalTopologyResponse.class::cast)).thenApply(LogicalTopologyResponse::logicalTopology);
    }

    public Set<String> nodeNames() {
        List peers = this.raftService.peers();
        assert (peers != null);
        return peers.stream().map(this::resolvePeer).map(ClusterNode::name).collect(Collectors.toSet());
    }

    private ClusterNode resolvePeer(Peer peer) {
        NetworkAddress addr = peer.address();
        for (int i = 0; i < 5; ++i) {
            ClusterNode node = this.clusterService.topologyService().getByAddress(addr);
            if (node != null) {
                return node;
            }
            LOG.debug("Unable to resolve Raft peer, address {} is unavailable. Remaining attempts: {}", new Object[]{addr, 5 - i});
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                throw new IgniteInternalException("Interrupted while resolving CMG node address", (Throwable)e);
            }
        }
        throw new IgniteInternalException(String.format("Node %s is not present in the physical topology", addr));
    }

    private ClusterNodeMessage nodeMessage(ClusterNode node) {
        return this.msgFactory.clusterNodeMessage().id(node.id()).name(node.name()).host(node.address().host()).port(node.address().port()).build();
    }
}

