/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class ImmutableNullableMap<K, V>
extends AbstractMap<K, V> {
    private static final Map<Integer, Integer> SINGLETON_MAP = Collections.singletonMap(0, 0);

    private ImmutableNullableMap() {
    }

    public static <K, V> Map<K, V> copyOf(Map<? extends K, ? extends V> map) {
        if (map instanceof ImmutableNullableMap || map instanceof ImmutableMap || map == Collections.emptyMap() || map == Collections.emptyNavigableMap() || map.getClass() == SINGLETON_MAP.getClass()) {
            return map;
        }
        if (map instanceof SortedMap) {
            SortedMap sortedMap = (SortedMap)map;
            try {
                Comparator comparator = sortedMap.comparator();
                if (comparator == null) {
                    return ImmutableSortedMap.copyOf((Map)sortedMap);
                }
                return ImmutableSortedMap.copyOf((Map)sortedMap, comparator);
            }
            catch (NullPointerException e) {
                return Collections.unmodifiableNavigableMap(new TreeMap(sortedMap));
            }
        }
        try {
            return ImmutableMap.copyOf(map);
        }
        catch (NullPointerException e) {
            return Collections.unmodifiableMap(new HashMap<K, V>(map));
        }
    }

    public static <K, V> Map<K, V> copyOf(SortedMap<? extends K, ? extends V> map) {
        if (map instanceof ImmutableNullableMap || map instanceof ImmutableMap || map == Collections.emptyMap() || map == Collections.emptyNavigableMap()) {
            return map;
        }
        SortedMap<K, V> sortedMap = map;
        try {
            Comparator<? extends K> comparator = sortedMap.comparator();
            if (comparator == null) {
                return ImmutableSortedMap.copyOf(sortedMap);
            }
            return ImmutableSortedMap.copyOf(sortedMap, comparator);
        }
        catch (NullPointerException e) {
            return Collections.unmodifiableNavigableMap(new TreeMap<K, V>(sortedMap));
        }
    }
}

