/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum JdbcStatementType {
    ANY_STATEMENT_TYPE(0),
    SELECT_STATEMENT_TYPE(1),
    UPDATE_STATEMENT_TYPE(2);

    private static final Map<Byte, JdbcStatementType> STATEMENT_TYPE_IDX;
    private final byte id;

    public static JdbcStatementType getStatement(byte id) {
        JdbcStatementType value = STATEMENT_TYPE_IDX.get(id);
        Objects.requireNonNull(value, String.format("Unknown jdbcStatementType %s", id));
        return value;
    }

    private JdbcStatementType(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    static {
        STATEMENT_TYPE_IDX = Arrays.stream(JdbcStatementType.values()).collect(Collectors.toMap(JdbcStatementType::getId, Function.identity()));
    }
}

