/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.metrics.sources;

import java.util.List;
import org.apache.ignite.shaded.org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.shaded.org.apache.ignite.internal.metrics.DistributionMetric;
import org.apache.ignite.shaded.org.apache.ignite.internal.metrics.Metric;

public class ClockServiceMetricSource
extends AbstractMetricSource<Holder> {
    public static final String SOURCE_NAME = "clock.service";
    private static final long[] HISTOGRAM_BUCKETS = new long[]{1L, 2L, 4L, 8L, 16L, 25L, 50L, 75L, 100L, 250L, 500L, 750L, 1000L, 3000L, 5000L, 10000L, 25000L, 60000L};

    public ClockServiceMetricSource() {
        super(SOURCE_NAME, "Clock service metrics.");
    }

    @Override
    protected Holder createHolder() {
        return new Holder();
    }

    public void onMaxClockSkewExceeded(long observedClockSkew) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.clockSkewExceedingMaxClockSkew.add(observedClockSkew);
        }
    }

    protected static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final DistributionMetric clockSkewExceedingMaxClockSkew = new DistributionMetric("ClockSkewExceedingMaxClockSkew", "Observed clock skew that exceeded max clock skew.", HISTOGRAM_BUCKETS);

        protected Holder() {
        }

        @Override
        public Iterable<Metric> metrics() {
            return List.of(this.clockSkewExceedingMaxClockSkew);
        }
    }
}

