/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.LongPredicate;
import org.jetbrains.annotations.Nullable;

public class KeyValueStorageUtils {
    public static final int NOT_FOUND = -1;

    public static int indexToCompact(long[] keyRevisions, long compactionRevision, LongPredicate isTombstone) {
        int i = Arrays.binarySearch(keyRevisions, compactionRevision);
        if (i < 0) {
            if ((i ^= 0xFFFFFFFF) == 0) {
                return -1;
            }
            --i;
        }
        if (isTombstone.test(keyRevisions[i])) {
            return i;
        }
        if (i != keyRevisions.length - 1 && keyRevisions[i + 1] == compactionRevision + 1L) {
            return i;
        }
        return i == 0 ? -1 : i - 1;
    }

    public static int maxRevisionIndex(long[] keyRevisions, long upperBoundRevision) {
        int i = Arrays.binarySearch(keyRevisions, upperBoundRevision);
        if (i < 0) {
            if (i == -1) {
                return -1;
            }
            i = -(i + 2);
        }
        return i;
    }

    public static int minRevisionIndex(long[] keyRevisions, long lowerBoundRevision) {
        int i = Arrays.binarySearch(keyRevisions, lowerBoundRevision);
        if (i < 0) {
            if (i == -(keyRevisions.length + 1)) {
                return -1;
            }
            i = -(i + 1);
        }
        return i;
    }

    public static boolean isLastIndex(long[] arr, int index) {
        assert (index >= 0 && index < arr.length) : "index=" + index + ", arr.length=" + arr.length;
        return arr.length - 1 == index;
    }

    public static String toUtf8String(byte @Nullable [] bytes) {
        return bytes == null ? "null" : new String(bytes, StandardCharsets.UTF_8);
    }

    public static void assertCompactionRevisionLessThanCurrent(long compactionRevision, long revision) {
        assert (compactionRevision < revision) : String.format("Compaction revision should be less than the current: [compaction=%s, current=%s]", compactionRevision, revision);
    }

    public static void assertRequestedRevisionLessThanOrEqualToCurrent(long requestedRevision, long revision) {
        assert (requestedRevision <= revision) : String.format("Requested revision should be less than or equal to the current: [requested=%s, current=%s]", requestedRevision, revision);
    }
}

