/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.completer.filter;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.core.repl.completer.filter.CompleterFilter;
import picocli.CommandLine;

public class NonRepeatableOptionsFilter
implements CompleterFilter {
    private final CommandLine.Model.CommandSpec topCommandSpec;

    public NonRepeatableOptionsFilter(CommandLine.Model.CommandSpec spec) {
        this.topCommandSpec = spec;
    }

    @Override
    public String[] filter(String[] words, String[] candidates) {
        CommandLine.Model.CommandSpec commandSpec = this.findCommandSpec(words);
        Map<String, CommandLine.Model.ITypeInfo> optionTypes = commandSpec.options().stream().flatMap(it -> Arrays.stream(it.names()).map(name -> new OptionInfo((String)name, it.typeInfo()))).collect(Collectors.toMap(rec$ -> ((OptionInfo)rec$).getName(), rec$ -> ((OptionInfo)rec$).getType()));
        Set shouldBeExcludedFromCandidates = Arrays.stream(words).filter(optionTypes::containsKey).filter(it -> !((CommandLine.Model.ITypeInfo)optionTypes.get(it)).isMultiValue()).collect(Collectors.toSet());
        return (String[])Arrays.stream(candidates).filter(it -> !shouldBeExcludedFromCandidates.contains(it)).toArray(String[]::new);
    }

    private CommandLine.Model.CommandSpec findCommandSpec(String[] words) {
        CommandLine.Model.CommandSpec commandSpec = this.topCommandSpec;
        for (int cursor = 0; cursor < words.length && commandSpec.subcommands().containsKey(words[cursor]); ++cursor) {
            commandSpec = ((CommandLine)commandSpec.subcommands().get(words[cursor])).getCommandSpec();
        }
        return commandSpec;
    }

    private static class OptionInfo {
        private final String name;
        private final CommandLine.Model.ITypeInfo type;

        private OptionInfo(String name, CommandLine.Model.ITypeInfo type) {
            this.name = name;
            this.type = type;
        }

        private String getName() {
            return this.name;
        }

        private CommandLine.Model.ITypeInfo getType() {
            return this.type;
        }
    }
}

