/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.storage.blob.models.Block;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;

@JacksonXmlRootElement(localName="BlockList")
public final class BlockList {
    @JsonProperty(value="CommittedBlocks")
    private CommittedBlocksWrapper committedBlocks;
    @JsonProperty(value="UncommittedBlocks")
    private UncommittedBlocksWrapper uncommittedBlocks;

    public List<Block> getCommittedBlocks() {
        if (this.committedBlocks == null) {
            this.committedBlocks = new CommittedBlocksWrapper(new ArrayList());
        }
        return this.committedBlocks.items;
    }

    public BlockList setCommittedBlocks(List<Block> committedBlocks) {
        this.committedBlocks = new CommittedBlocksWrapper(committedBlocks);
        return this;
    }

    public List<Block> getUncommittedBlocks() {
        if (this.uncommittedBlocks == null) {
            this.uncommittedBlocks = new UncommittedBlocksWrapper(new ArrayList());
        }
        return this.uncommittedBlocks.items;
    }

    public BlockList setUncommittedBlocks(List<Block> uncommittedBlocks) {
        this.uncommittedBlocks = new UncommittedBlocksWrapper(uncommittedBlocks);
        return this;
    }

    private static final class UncommittedBlocksWrapper {
        @JacksonXmlProperty(localName="Block")
        private final List<Block> items;

        @JsonCreator
        private UncommittedBlocksWrapper(@JacksonXmlProperty(localName="Block") List<Block> items) {
            this.items = items;
        }
    }

    private static final class CommittedBlocksWrapper {
        @JacksonXmlProperty(localName="Block")
        private final List<Block> items;

        @JsonCreator
        private CommittedBlocksWrapper(@JacksonXmlProperty(localName="Block") List<Block> items) {
            this.items = items;
        }
    }
}

