/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common;

import com.azure.storage.common.ProgressReceiver;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ProgressReporter {
    public static Flux<ByteBuffer> addProgressReporting(Flux<ByteBuffer> data, ProgressReceiver progressReceiver) {
        if (progressReceiver == null) {
            return data;
        }
        SequentialProgressReporter tracker = new SequentialProgressReporter(progressReceiver);
        return tracker.addProgressReporting(data);
    }

    public static Flux<ByteBuffer> addParallelProgressReporting(Flux<ByteBuffer> data, ProgressReceiver progressReceiver, Lock lock, AtomicLong totalProgress) {
        if (progressReceiver == null) {
            return data;
        }
        ParallelProgressReporter tracker = new ParallelProgressReporter(progressReceiver, lock, totalProgress);
        return tracker.addProgressReporting(data);
    }

    private static class ParallelProgressReporter
    extends ProgressReporterImpl {
        private final Lock transferLock;
        private final AtomicLong totalProgress;

        ParallelProgressReporter(ProgressReceiver progressReceiver, Lock lock, AtomicLong totalProgress) {
            super(progressReceiver);
            this.transferLock = lock;
            this.totalProgress = totalProgress;
        }

        @Override
        public void reportProgress(long bytesTransferred) {
            super.reportProgress(bytesTransferred);
            this.transferLock.lock();
            this.progressReceiver.reportProgress(this.totalProgress.addAndGet(bytesTransferred));
            this.transferLock.unlock();
        }

        @Override
        public void rewindProgress() {
            this.totalProgress.addAndGet(-1L * this.blockProgress);
            super.rewindProgress();
        }
    }

    private static class SequentialProgressReporter
    extends ProgressReporterImpl {
        SequentialProgressReporter(ProgressReceiver progressReceiver) {
            super(progressReceiver);
        }

        @Override
        public void reportProgress(long bytesTransferred) {
            super.reportProgress(bytesTransferred);
            this.progressReceiver.reportProgress(this.blockProgress);
        }
    }

    private static abstract class ProgressReporterImpl
    implements ProgressReceiver {
        long blockProgress = 0L;
        final ProgressReceiver progressReceiver;

        ProgressReporterImpl(ProgressReceiver progressReceiver) {
            this.progressReceiver = progressReceiver;
        }

        @Override
        public void reportProgress(long bytesTransferred) {
            this.blockProgress += bytesTransferred;
        }

        void rewindProgress() {
            this.blockProgress = 0L;
        }

        Flux<ByteBuffer> addProgressReporting(Flux<ByteBuffer> data) {
            return Mono.just((Object)this).flatMapMany(progressReporter -> {
                progressReporter.rewindProgress();
                return data.doOnNext(buffer -> progressReporter.reportProgress(buffer.remaining()));
            });
        }
    }
}

