/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.implementation.PayloadSizeGate;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UploadUtils {
    public static <T> Mono<Response<T>> uploadFullOrChunked(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, Function<Flux<ByteBuffer>, Mono<Response<T>>> uploadInChunks, BiFunction<Flux<ByteBuffer>, Long, Mono<Response<T>>> uploadFull) {
        PayloadSizeGate gate = new PayloadSizeGate(parallelTransferOptions.getMaxSingleUploadSizeLong());
        return data.filter(Buffer::hasRemaining).concatMap(gate::write).switchOnFirst((signal, flux) -> {
            if (signal.isOnError()) {
                Throwable t = signal.getThrowable();
                if (t != null) {
                    return Flux.error((Throwable)t);
                }
                return Flux.error((Throwable)new IllegalStateException("Source flux failed but cause is unretrievable"));
            }
            if (gate.isThresholdBreached()) {
                return (Publisher)uploadInChunks.apply(flux.concatWith((Publisher)Flux.defer(gate::flush)));
            }
            return (Publisher)uploadFull.apply(gate.flush(), gate.size());
        }).next().switchIfEmpty(Mono.defer(() -> (Mono)uploadFull.apply(Flux.empty(), 0L)));
    }

    public static Flux<ByteBuffer> chunkSource(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions) {
        if (parallelTransferOptions.getBlockSizeLong() <= Integer.MAX_VALUE) {
            int chunkSize = parallelTransferOptions.getBlockSizeLong().intValue();
            return data.flatMapSequential(buffer -> {
                if (buffer.remaining() <= chunkSize) {
                    return Flux.just((Object)buffer);
                }
                int numSplits = (int)Math.ceil((double)buffer.remaining() / (double)chunkSize);
                return Flux.range((int)0, (int)numSplits).map(i -> {
                    ByteBuffer duplicate = buffer.duplicate().asReadOnlyBuffer();
                    duplicate.position(i * chunkSize);
                    duplicate.limit(Math.min(duplicate.limit(), (i + 1) * chunkSize));
                    return duplicate;
                });
            });
        }
        return data;
    }

    public static boolean shouldUploadInChunks(String filePath, Long maxSingleUploadSize, ClientLogger logger) {
        boolean retVal;
        AsynchronousFileChannel channel = UploadUtils.uploadFileResourceSupplier(filePath, logger);
        try {
            retVal = channel.size() > maxSingleUploadSize;
        }
        catch (IOException e) {
            throw logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
        finally {
            UploadUtils.uploadFileCleanup(channel, logger);
        }
        return retVal;
    }

    public static AsynchronousFileChannel uploadFileResourceSupplier(String filePath, ClientLogger logger) {
        try {
            return AsynchronousFileChannel.open(Paths.get(filePath, new String[0]), StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    public static void uploadFileCleanup(AsynchronousFileChannel channel, ClientLogger logger) {
        try {
            channel.close();
        }
        catch (IOException e) {
            throw logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    public static Mono<FluxMd5Wrapper> computeMd5(Flux<ByteBuffer> data, boolean computeMd5, ClientLogger logger) {
        if (computeMd5) {
            try {
                return data.reduce((Object)MessageDigest.getInstance("MD5"), (digest, buffer) -> {
                    int position = buffer.position();
                    byte[] bytes = FluxUtil.byteBufferToArray((ByteBuffer)buffer);
                    digest.update(bytes, 0, bytes.length);
                    buffer.position(position);
                    return digest;
                }).map(messageDigest -> new FluxMd5Wrapper(data, messageDigest.digest()));
            }
            catch (NoSuchAlgorithmException e) {
                return FluxUtil.monoError((ClientLogger)logger, (RuntimeException)new RuntimeException(e));
            }
        }
        return Mono.just((Object)new FluxMd5Wrapper(data, null));
    }

    public static class FluxMd5Wrapper {
        private final Flux<ByteBuffer> data;
        private final byte[] md5;

        FluxMd5Wrapper(Flux<ByteBuffer> data, byte[] md5) {
            this.data = data;
            this.md5 = CoreUtils.clone((byte[])md5);
        }

        public Flux<ByteBuffer> getData() {
            return this.data;
        }

        public byte[] getMd5() {
            return CoreUtils.clone((byte[])this.md5);
        }
    }
}

