/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.reader;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.spark.reader.SparkUnkeyedDataReader;
import org.apache.amoro.spark.util.Stats;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsReportStatistics;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnkeyedSparkBatchScan
implements Scan,
Batch,
SupportsReportStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(UnkeyedSparkBatchScan.class);
    public static final String FILE_NAME_COL = "_file";
    public static final String ROW_POS_COL = "_pos";
    public static final List<String> ROW_ID_COLUMNS = Lists.newArrayList((Object[])new String[]{"_file", "_pos"});
    private final UnkeyedTable table;
    private final boolean caseSensitive;
    private final Schema expectedSchema;
    private final List<Expression> filterExpressions;
    private StructType readSchema = null;
    private List<CombinedScanTask> tasks = null;

    UnkeyedSparkBatchScan(UnkeyedTable table, boolean caseSensitive, Schema expectedSchema, List<Expression> filters, CaseInsensitiveStringMap options) {
        Preconditions.checkNotNull((Object)table, (Object)"table must not be null");
        Preconditions.checkNotNull((Object)expectedSchema, (Object)"expectedSchema must not be null");
        Preconditions.checkNotNull(filters, (Object)"filters must not be null");
        this.table = table;
        this.caseSensitive = caseSensitive;
        this.expectedSchema = expectedSchema;
        this.filterExpressions = filters;
    }

    public InputPartition[] planInputPartitions() {
        List<CombinedScanTask> scanTasks = this.tasks();
        InputPartition[] readTasks = new MixedFormatInputPartition[scanTasks.size()];
        for (int i = 0; i < scanTasks.size(); ++i) {
            readTasks[i] = new MixedFormatInputPartition(scanTasks.get(i), this.table, this.expectedSchema, this.caseSensitive);
        }
        return readTasks;
    }

    public PartitionReaderFactory createReaderFactory() {
        return new ReaderFactory();
    }

    public Statistics estimateStatistics() {
        if (this.table.currentSnapshot() == null) {
            return new Stats(0L, 0L);
        }
        if (!this.table.spec().isUnpartitioned() && this.filterExpressions.isEmpty()) {
            LOG.debug("using table metadata to estimate table statistics");
            long totalRecords = PropertyUtil.propertyAsLong((Map)this.table.currentSnapshot().summary(), (String)"total-records", (long)Long.MAX_VALUE);
            return new Stats(SparkSchemaUtil.estimateSize((StructType)this.readSchema(), (long)totalRecords), totalRecords);
        }
        long numRows = 0L;
        for (CombinedScanTask task : this.tasks()) {
            for (FileScanTask file : task.files()) {
                double fractionOfFileScanned = (double)file.length() / (double)((DataFile)file.file()).fileSizeInBytes();
                numRows = (long)((double)numRows + fractionOfFileScanned * (double)((DataFile)file.file()).recordCount());
            }
        }
        long sizeInBytes = SparkSchemaUtil.estimateSize((StructType)this.readSchema(), (long)numRows);
        return new Stats(sizeInBytes, numRows);
    }

    public StructType readSchema() {
        if (this.readSchema == null) {
            this.readSchema = SparkSchemaUtil.convert((Schema)this.expectedSchema);
        }
        return this.readSchema;
    }

    public Batch toBatch() {
        return this;
    }

    private List<CombinedScanTask> tasks() {
        if (this.tasks == null) {
            TableScan scan = this.table.newScan();
            for (Expression filter : this.filterExpressions) {
                scan = (TableScan)scan.filter(filter);
            }
            long startTime = System.currentTimeMillis();
            LOG.info("mor statistics plan task start");
            try (CloseableIterable tasksIterable = scan.planTasks();){
                this.tasks = Lists.newArrayList((Iterable)tasksIterable);
                LOG.info("mor statistics plan task end, cost time {}, tasks num {}", (Object)(System.currentTimeMillis() - startTime), (Object)this.tasks.size());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close table scan: %s", e);
            }
        }
        return this.tasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnkeyedSparkBatchScan that = (UnkeyedSparkBatchScan)o;
        return this.table.id().equals((Object)that.table.id()) && this.readSchema().equals((Object)that.readSchema()) && this.filterExpressions.toString().equals(that.filterExpressions.toString());
    }

    public int hashCode() {
        return Objects.hash(this.table.id(), this.readSchema());
    }

    public String description() {
        String filters = this.filterExpressions.stream().map(Spark3Util::describe).collect(Collectors.joining(", "));
        return String.format("%s [filters=%s]", this.table, filters);
    }

    public String toString() {
        return String.format("IcebergScan(table=%s, type=%s, filters=%s, caseSensitive=%s)", this.table, this.expectedSchema.asStruct(), this.filterExpressions, this.caseSensitive);
    }

    private static class MixedFormatInputPartition
    implements InputPartition,
    Serializable {
        final CombinedScanTask combinedScanTask;
        final AuthenticatedFileIO io;
        final boolean caseSensitive;
        final Schema expectedSchema;
        final Schema tableSchema;
        final String nameMapping;

        MixedFormatInputPartition(CombinedScanTask combinedScanTask, UnkeyedTable table, Schema expectedSchema, boolean caseSensitive) {
            this.combinedScanTask = combinedScanTask;
            this.expectedSchema = expectedSchema;
            this.tableSchema = table.schema();
            this.caseSensitive = caseSensitive;
            this.io = table.io();
            this.nameMapping = (String)table.properties().get("schema.name-mapping.default");
        }
    }

    private static class RowReader
    implements PartitionReader<InternalRow> {
        SparkUnkeyedDataReader reader;
        Iterator<FileScanTask> scanTasks;
        FileScanTask currentScanTask;
        CloseableIterator<InternalRow> currentIterator = CloseableIterator.empty();
        InternalRow current;

        RowReader(MixedFormatInputPartition task) {
            this.reader = new SparkUnkeyedDataReader(task.io, task.tableSchema, task.expectedSchema, task.nameMapping, task.caseSensitive);
            this.scanTasks = task.combinedScanTask.files().iterator();
        }

        public boolean next() throws IOException {
            while (true) {
                if (this.currentIterator.hasNext()) {
                    this.current = (InternalRow)this.currentIterator.next();
                    return true;
                }
                if (!this.scanTasks.hasNext()) break;
                this.currentIterator.close();
                this.currentScanTask = this.scanTasks.next();
                this.currentIterator = this.reader.readData(this.currentScanTask).iterator();
            }
            this.currentIterator.close();
            return false;
        }

        public InternalRow get() {
            return this.current;
        }

        public void close() throws IOException {
            this.currentIterator.close();
            while (this.scanTasks.hasNext()) {
                this.scanTasks.next();
            }
        }
    }

    private static class ReaderFactory
    implements PartitionReaderFactory {
        private ReaderFactory() {
        }

        public PartitionReader<InternalRow> createReader(InputPartition partition) {
            if (partition instanceof MixedFormatInputPartition) {
                return new RowReader((MixedFormatInputPartition)partition);
            }
            throw new UnsupportedOperationException("Incorrect input partition type: " + partition);
        }
    }
}

