/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.amoro.parser;

import java.io.Serializable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.amoro.spark.sql.parser.MixedFormatSqlExtendParser;
import org.apache.spark.sql.catalyst.parser.ParseException;
import scala.Function0;
import scala.Option$;
import scala.math.BigDecimal;

public final class QueryParsingErrors$ {
    public static QueryParsingErrors$ MODULE$;

    static {
        new QueryParsingErrors$();
    }

    public Throwable columnAliasInOperationNotAllowedError(String op, MixedFormatSqlExtendParser.TableAliasContext ctx) {
        return new ParseException(new StringBuilder(36).append("Columns aliases are not allowed in ").append(op).append(".").toString(), (ParserRuleContext)ctx.identifierList());
    }

    public Throwable combinationQueryResultClausesUnsupportedError(MixedFormatSqlExtendParser.QueryOrganizationContext ctx) {
        return new ParseException("Combination of ORDER BY/SORT BY/DISTRIBUTE BY/CLUSTER BY is not supported", (ParserRuleContext)ctx);
    }

    public Throwable distributeByUnsupportedError(MixedFormatSqlExtendParser.QueryOrganizationContext ctx) {
        return new ParseException("DISTRIBUTE BY is not supported", (ParserRuleContext)ctx);
    }

    public Throwable transformNotSupportQuantifierError(ParserRuleContext ctx) {
        return new ParseException("TRANSFORM does not support DISTINCT/ALL in inputs", ctx);
    }

    public Throwable transformWithSerdeUnsupportedError(ParserRuleContext ctx) {
        return new ParseException("TRANSFORM with serde is only supported in hive mode", ctx);
    }

    public Throwable lateralWithPivotInFromClauseNotAllowedError(MixedFormatSqlExtendParser.FromClauseContext ctx) {
        return new ParseException("LATERAL cannot be used together with PIVOT in FROM clause", (ParserRuleContext)ctx);
    }

    public Throwable lateralJoinWithNaturalJoinUnsupportedError(ParserRuleContext ctx) {
        return new ParseException("LATERAL join with NATURAL join is not supported", ctx);
    }

    public Throwable lateralJoinWithUsingJoinUnsupportedError(ParserRuleContext ctx) {
        return new ParseException("LATERAL join with USING join is not supported", ctx);
    }

    public Throwable unsupportedLateralJoinTypeError(ParserRuleContext ctx, String joinType) {
        return new ParseException(new StringBuilder(30).append("Unsupported LATERAL join type ").append(joinType).toString(), ctx);
    }

    public Throwable invalidLateralJoinRelationError(MixedFormatSqlExtendParser.RelationPrimaryContext ctx) {
        return new ParseException("LATERAL can only be used with subquery", (ParserRuleContext)ctx);
    }

    public Throwable repetitiveWindowDefinitionError(String name, MixedFormatSqlExtendParser.WindowClauseContext ctx) {
        return new ParseException(new StringBuilder(41).append("The definition of window '").append(name).append("' is repetitive").toString(), (ParserRuleContext)ctx);
    }

    public Throwable invalidWindowReferenceError(String name, MixedFormatSqlExtendParser.WindowClauseContext ctx) {
        return new ParseException(new StringBuilder(49).append("Window reference '").append(name).append("' is not a window specification").toString(), (ParserRuleContext)ctx);
    }

    public Throwable cannotResolveWindowReferenceError(String name, MixedFormatSqlExtendParser.WindowClauseContext ctx) {
        return new ParseException(new StringBuilder(34).append("Cannot resolve window reference '").append(name).append("'").toString(), (ParserRuleContext)ctx);
    }

    public Throwable naturalCrossJoinUnsupportedError(MixedFormatSqlExtendParser.RelationContext ctx) {
        return new ParseException("NATURAL CROSS JOIN is not supported", (ParserRuleContext)ctx);
    }

    public Throwable emptyInputForTableSampleError(ParserRuleContext ctx) {
        return new ParseException("TABLESAMPLE does not accept empty inputs.", ctx);
    }

    public Throwable tableSampleByBytesUnsupportedError(String msg, MixedFormatSqlExtendParser.SampleMethodContext ctx) {
        return new ParseException(new StringBuilder(30).append("TABLESAMPLE(").append(msg).append(") is not supported").toString(), (ParserRuleContext)ctx);
    }

    public Throwable invalidByteLengthLiteralError(String bytesStr, MixedFormatSqlExtendParser.SampleByBytesContext ctx) {
        return new ParseException(new StringBuilder(84).append(bytesStr).append(" is not a valid byte length literal, ").append("expected syntax: DIGIT+ ('B' | 'K' | 'M' | 'G')").toString(), (ParserRuleContext)ctx);
    }

    public Throwable invalidFromToUnitValueError(MixedFormatSqlExtendParser.IntervalValueContext ctx) {
        return new ParseException("The value of from-to unit must be a string", (ParserRuleContext)ctx);
    }

    public Throwable storedAsAndStoredByBothSpecifiedError(MixedFormatSqlExtendParser.CreateFileFormatContext ctx) {
        return new ParseException("Expected either STORED AS or STORED BY, not both", (ParserRuleContext)ctx);
    }

    public Throwable invalidEscapeStringError(MixedFormatSqlExtendParser.PredicateContext ctx) {
        return new ParseException("Invalid escape string. Escape string must contain only one character.", (ParserRuleContext)ctx);
    }

    public Throwable trimOptionUnsupportedError(int trimOption, MixedFormatSqlExtendParser.TrimContext ctx) {
        return new ParseException(new StringBuilder(91).append("Function trim doesn't support with ").append("type ").append(trimOption).append(". Please use BOTH, LEADING or TRAILING as trim type").toString(), (ParserRuleContext)ctx);
    }

    public Throwable invalidIntervalFormError(String value, MixedFormatSqlExtendParser.MultiUnitsIntervalContext ctx) {
        return new ParseException(new StringBuilder(116).append("Can only use numbers in the interval value part for").append(" multiple unit value pairs interval form, but got invalid value: ").append(value).toString(), (ParserRuleContext)ctx);
    }

    public Throwable functionNameUnsupportedError(String functionName, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(28).append("Unsupported function name '").append(functionName).append("'").toString(), ctx);
    }

    public Throwable cannotParseValueTypeError(String valueType, String value, MixedFormatSqlExtendParser.TypeConstructorContext ctx) {
        return new ParseException(new StringBuilder(25).append("Cannot parse the ").append(valueType).append(" value: ").append(value).toString(), (ParserRuleContext)ctx);
    }

    public Throwable cannotParseIntervalValueError(String value, MixedFormatSqlExtendParser.TypeConstructorContext ctx) {
        return new ParseException(new StringBuilder(33).append("Cannot parse the INTERVAL value: ").append(value).toString(), (ParserRuleContext)ctx);
    }

    public Throwable literalValueTypeUnsupportedError(String valueType, MixedFormatSqlExtendParser.TypeConstructorContext ctx) {
        return new ParseException(new StringBuilder(48).append("Literals of type '").append(valueType).append("' are currently not supported.").toString(), (ParserRuleContext)ctx);
    }

    public Throwable parsingValueTypeError(IllegalArgumentException e, String valueType, MixedFormatSqlExtendParser.TypeConstructorContext ctx) {
        String message = (String)Option$.MODULE$.apply((Object)e.getMessage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Exception parsing ").append(valueType).toString());
        return new ParseException(message, (ParserRuleContext)ctx);
    }

    public Throwable invalidNumericLiteralRangeError(String rawStrippedQualifier, BigDecimal minValue, BigDecimal maxValue, String typeName, MixedFormatSqlExtendParser.NumberContext ctx) {
        return new ParseException(new StringBuilder(53).append("Numeric literal ").append(rawStrippedQualifier).append(" does not ").append("fit in range [").append(minValue).append(", ").append(maxValue).append("] for type ").append(typeName).toString(), (ParserRuleContext)ctx);
    }

    public Throwable moreThanOneFromToUnitInIntervalLiteralError(ParserRuleContext ctx) {
        return new ParseException("Can only have a single from-to unit in the interval literal syntax", ctx);
    }

    public Throwable invalidIntervalLiteralError(MixedFormatSqlExtendParser.IntervalContext ctx) {
        return new ParseException("at least one time unit should be given for interval literal", (ParserRuleContext)ctx);
    }

    public Throwable fromToIntervalUnsupportedError(String from, String to, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(38).append("Intervals FROM ").append(from).append(" TO ").append(to).append(" are not supported.").toString(), ctx);
    }

    public Throwable mixedIntervalUnitsError(String literal, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(43).append("Cannot mix year-month and day-time fields: ").append(literal).toString(), ctx);
    }

    public Throwable dataTypeUnsupportedError(String dataType, MixedFormatSqlExtendParser.PrimitiveDataTypeContext ctx) {
        return new ParseException(new StringBuilder(27).append("DataType ").append(dataType).append(" is not supported.").toString(), (ParserRuleContext)ctx);
    }

    public Throwable partitionTransformNotExpectedError(String name, String describe, MixedFormatSqlExtendParser.ApplyTransformContext ctx) {
        return new ParseException(new StringBuilder(44).append("Expected a column reference for transform ").append(name).append(": ").append(describe).toString(), (ParserRuleContext)ctx);
    }

    public Throwable tooManyArgumentsForTransformError(String name, MixedFormatSqlExtendParser.ApplyTransformContext ctx) {
        return new ParseException(new StringBuilder(33).append("Too many arguments for transform ").append(name).toString(), (ParserRuleContext)ctx);
    }

    public Throwable invalidBucketsNumberError(String describe, MixedFormatSqlExtendParser.ApplyTransformContext ctx) {
        return new ParseException(new StringBuilder(27).append("Invalid number of buckets: ").append(describe).toString(), (ParserRuleContext)ctx);
    }

    public Throwable cannotCleanReservedNamespacePropertyError(String property, ParserRuleContext ctx, String msg) {
        return new ParseException(new StringBuilder(36).append(property).append(" is a reserved namespace property, ").append(msg).append(".").toString(), ctx);
    }

    public Throwable cannotCleanReservedTablePropertyError(String property, ParserRuleContext ctx, String msg) {
        return new ParseException(new StringBuilder(32).append(property).append(" is a reserved table property, ").append(msg).append(".").toString(), ctx);
    }

    public Throwable duplicatedTablePathsFoundError(String pathOne, String pathTwo, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(178).append("Duplicated table paths found: '").append(pathOne).append("' and '").append(pathTwo).append("'. LOCATION").append(" and the case insensitive key 'path' in OPTIONS are all used to indicate the custom").append(" table path, you can only specify one of them.").toString(), ctx);
    }

    public Throwable operationNotAllowedError(String message, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(23).append("Operation not allowed: ").append(message).toString(), ctx);
    }

    public Throwable duplicateCteDefinitionNamesError(String duplicateNames, MixedFormatSqlExtendParser.CtesContext ctx) {
        return new ParseException(new StringBuilder(44).append("CTE definition can't have duplicate names: ").append(duplicateNames).append(".").toString(), (ParserRuleContext)ctx);
    }

    public Throwable invalidGroupingSetError(String element, MixedFormatSqlExtendParser.GroupingAnalyticsContext ctx) {
        return new ParseException(new StringBuilder(45).append("Empty set in ").append(element).append(" grouping sets is not supported.").toString(), (ParserRuleContext)ctx);
    }

    private QueryParsingErrors$() {
        MODULE$ = this;
    }
}

