/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.io.FileReaderFactory;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class RecordLevelExpire {
    private final int timeField;
    private final int expireTime;

    @Nullable
    public static RecordLevelExpire create(CoreOptions options, RowType rowType) {
        Duration expireTime = options.recordLevelExpireTime();
        if (expireTime == null) {
            return null;
        }
        String timeField = options.recordLevelTimeField();
        if (timeField == null) {
            throw new IllegalArgumentException("You should set time field for record-level expire.");
        }
        int fieldIndex = rowType.getFieldIndex(timeField);
        if (fieldIndex == -1) {
            throw new IllegalArgumentException(String.format("Can not find time field %s for record level expire.", timeField));
        }
        DataField field = rowType.getField(timeField);
        if (!(field.type() instanceof IntType)) {
            throw new IllegalArgumentException(String.format("Record level time field should be INT type, but is %s.", field.type()));
        }
        return new RecordLevelExpire(fieldIndex, (int)expireTime.getSeconds());
    }

    public RecordLevelExpire(int timeField, int expireTime) {
        this.timeField = timeField;
        this.expireTime = expireTime;
    }

    public FileReaderFactory<KeyValue> wrap(FileReaderFactory<KeyValue> readerFactory) {
        return file -> this.wrap(readerFactory.createRecordReader(file));
    }

    public RecordReader<KeyValue> wrap(RecordReader<KeyValue> reader) {
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        return reader.filter(kv -> {
            Preconditions.checkArgument(!kv.value().isNullAt(this.timeField), "Time field for record-level expire should not be null.");
            int recordTime = kv.value().getInt(this.timeField);
            return currentTime <= recordTime + this.expireTime;
        });
    }
}

