/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.formats.paimon;

import java.util.List;
import org.apache.amoro.AlreadyExistsException;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.DatabaseNotEmptyException;
import org.apache.amoro.FormatCatalog;
import org.apache.amoro.NoSuchDatabaseException;
import org.apache.amoro.NoSuchTableException;
import org.apache.amoro.formats.paimon.PaimonTable;
import org.apache.amoro.table.TableIdentifier;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;

public class PaimonCatalog
implements FormatCatalog {
    private final Catalog catalog;
    private final String name;

    public PaimonCatalog(Catalog catalog, String name) {
        this.catalog = catalog;
        this.name = name;
    }

    @Override
    public List<String> listDatabases() {
        return this.catalog.listDatabases();
    }

    @Override
    public boolean databaseExists(String database) {
        return this.catalog.databaseExists(database);
    }

    @Override
    public boolean tableExists(String database, String table) {
        return this.catalog.tableExists(Identifier.create((String)database, (String)table));
    }

    @Override
    public void createDatabase(String database) {
        try {
            this.catalog.createDatabase(database, false);
        }
        catch (Catalog.DatabaseAlreadyExistException e) {
            throw new AlreadyExistsException(e);
        }
    }

    @Override
    public void dropDatabase(String database) {
        try {
            this.catalog.dropDatabase(database, false, false);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchDatabaseException(e);
        }
        catch (Catalog.DatabaseNotEmptyException e) {
            throw new DatabaseNotEmptyException(e);
        }
    }

    @Override
    public AmoroTable<?> loadTable(String database, String table) {
        try {
            return new PaimonTable(TableIdentifier.of(this.name, database, table), this.catalog.getTable(Identifier.create((String)database, (String)table)));
        }
        catch (Catalog.TableNotExistException e) {
            throw new NoSuchTableException(e);
        }
    }

    @Override
    public List<String> listTables(String database) {
        try {
            return this.catalog.listTables(database);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchDatabaseException(e);
        }
    }

    @Override
    public boolean dropTable(String database, String table, boolean purge) {
        try {
            this.catalog.dropTable(Identifier.create((String)database, (String)table), purge);
            return true;
        }
        catch (Catalog.TableNotExistException e) {
            return false;
        }
    }
}

