/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.amoro.data.ChangedLsn;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.data.PrimaryKeyedFile;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.CloseableIterableWrapper;
import org.apache.amoro.io.CloseablePredicate;
import org.apache.amoro.scan.KeyedTableScanTask;
import org.apache.amoro.scan.MixedFileScanTask;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Iterables;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.utils.NodeFilter;
import org.apache.amoro.utils.map.StructLikeBaseMap;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.avro.Schema;
import org.apache.commons.collections.CollectionUtils;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Filter;
import org.apache.iceberg.util.StructProjection;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;

public abstract class MixedDeleteFilter<T> {
    private static final org.apache.iceberg.Schema POS_DELETE_SCHEMA = new org.apache.iceberg.Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS});
    private static final Accessor<StructLike> FILENAME_ACCESSOR = POS_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_PATH.fieldId());
    private static final Accessor<StructLike> POSITION_ACCESSOR = POS_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_POS.fieldId());
    private final Set<PrimaryKeyedFile> eqDeletes;
    private final List<DeleteFile> posDeletes;
    private final org.apache.iceberg.Schema requiredSchema;
    private final Accessor<StructLike> dataTransactionIdAccessor;
    private final Accessor<StructLike> dataOffsetAccessor;
    private final Accessor<StructLike> deleteTransactionIdAccessor;
    private final Accessor<StructLike> deleteOffsetAccessor;
    private final Set<Integer> primaryKeyId;
    private final org.apache.iceberg.Schema deleteSchema;
    private final Filter<Record> deleteNodeFilter;
    private CloseablePredicate<T> eqPredicate;
    private Map<String, Set<Long>> positionMap;
    private final Accessor<StructLike> posAccessor;
    private final Accessor<StructLike> filePathAccessor;
    private final Set<String> pathSets;
    private String currentDataPath;
    private Set<Long> currentPosSet;
    private StructLikeCollections structLikeCollections = StructLikeCollections.DEFAULT;

    protected MixedDeleteFilter(KeyedTableScanTask keyedTableScanTask, org.apache.iceberg.Schema tableSchema, org.apache.iceberg.Schema requestedSchema, PrimaryKeySpec primaryKeySpec) {
        this(keyedTableScanTask, tableSchema, requestedSchema, primaryKeySpec, null);
    }

    protected MixedDeleteFilter(KeyedTableScanTask keyedTableScanTask, org.apache.iceberg.Schema tableSchema, org.apache.iceberg.Schema requestedSchema, PrimaryKeySpec primaryKeySpec, Set<DataTreeNode> sourceNodes, StructLikeCollections structLikeCollections) {
        this(keyedTableScanTask, tableSchema, requestedSchema, primaryKeySpec, sourceNodes);
        this.structLikeCollections = structLikeCollections;
    }

    protected MixedDeleteFilter(KeyedTableScanTask keyedTableScanTask, org.apache.iceberg.Schema tableSchema, org.apache.iceberg.Schema requestedSchema, PrimaryKeySpec primaryKeySpec, Set<DataTreeNode> sourceNodes) {
        this.eqDeletes = keyedTableScanTask.mixedEquityDeletes().stream().map(MixedFileScanTask::file).collect(Collectors.toSet());
        HashMap<String, DeleteFile> map = new HashMap<String, DeleteFile>();
        for (MixedFileScanTask mixedFileScanTask : keyedTableScanTask.dataTasks()) {
            for (DeleteFile deleteFile : mixedFileScanTask.deletes()) {
                map.putIfAbsent(deleteFile.path().toString(), deleteFile);
            }
        }
        this.posDeletes = new ArrayList(map.values());
        this.pathSets = keyedTableScanTask.dataTasks().stream().map(s -> s.file().path().toString()).collect(Collectors.toSet());
        this.primaryKeyId = primaryKeySpec.primaryKeyStruct().fields().stream().map(Types.NestedField::fieldId).collect(Collectors.toSet());
        this.requiredSchema = this.fileProjection(tableSchema, requestedSchema, this.eqDeletes, this.posDeletes);
        this.deleteSchema = TypeUtil.join((org.apache.iceberg.Schema)TypeUtil.select((org.apache.iceberg.Schema)this.requiredSchema, (Set)Sets.newHashSet(this.primaryKeyId)), (org.apache.iceberg.Schema)new org.apache.iceberg.Schema(new Types.NestedField[]{org.apache.amoro.table.MetadataColumns.FILE_OFFSET_FILED, org.apache.amoro.table.MetadataColumns.TRANSACTION_ID_FILED}));
        this.deleteNodeFilter = CollectionUtils.isNotEmpty(sourceNodes) ? new NodeFilter<Record>(sourceNodes, this.deleteSchema, primaryKeySpec, record -> new InternalRecordWrapper(this.deleteSchema.asStruct()).wrap((StructLike)record)) : null;
        this.dataTransactionIdAccessor = this.requiredSchema.accessorForField(2147482646);
        this.dataOffsetAccessor = this.requiredSchema.accessorForField(2147482645);
        this.deleteTransactionIdAccessor = this.deleteSchema.accessorForField(2147482646);
        this.deleteOffsetAccessor = this.deleteSchema.accessorForField(2147482645);
        this.posAccessor = this.requiredSchema.accessorForField(MetadataColumns.ROW_POSITION.fieldId());
        this.filePathAccessor = this.requiredSchema.accessorForField(MetadataColumns.FILE_PATH.fieldId());
    }

    public org.apache.iceberg.Schema requiredSchema() {
        return this.requiredSchema;
    }

    protected abstract StructLike asStructLike(T var1);

    protected abstract InputFile getInputFile(String var1);

    protected long pos(T record) {
        return (Long)this.posAccessor.get((Object)this.asStructLike(record));
    }

    protected String filePath(T record) {
        return this.filePathAccessor.get((Object)this.asStructLike(record)).toString();
    }

    protected AuthenticatedFileIO getFileIO() {
        return null;
    }

    public CloseableIterable<T> filter(CloseableIterable<T> records) {
        return new CloseableIterableWrapper<T>(this.apply(this.apply(records, this.applyPosDeletes().negate()), this.applyEqDeletes().negate()), this.eqPredicate);
    }

    public CloseableIterable<T> filterNegate(CloseableIterable<T> records) {
        return new CloseableIterableWrapper<T>(this.apply(records, this.applyEqDeletes().or(this.applyPosDeletes())), this.eqPredicate);
    }

    public void setCurrentDataPath(String currentDataPath) {
        this.currentDataPath = currentDataPath;
        this.currentPosSet = null;
    }

    private ChangedLsn deleteLSN(StructLike structLike) {
        Long transactionId = (Long)this.deleteTransactionIdAccessor.get((Object)structLike);
        Long deleteOffset = (Long)this.deleteOffsetAccessor.get((Object)structLike);
        return ChangedLsn.of(transactionId, deleteOffset);
    }

    private ChangedLsn dataLSN(StructLike structLike) {
        Long transactionId = (Long)this.dataTransactionIdAccessor.get((Object)structLike);
        Long deleteOffset = (Long)this.dataOffsetAccessor.get((Object)structLike);
        return ChangedLsn.of(transactionId, deleteOffset);
    }

    private Predicate<T> applyEqDeletes() {
        if (this.eqPredicate != null) {
            return this.eqPredicate;
        }
        if (this.eqDeletes.isEmpty()) {
            return record -> false;
        }
        org.apache.iceberg.Schema pkSchema = TypeUtil.select((org.apache.iceberg.Schema)this.requiredSchema, this.primaryKeyId);
        StructProjection deletePKProjectRow = StructProjection.create((org.apache.iceberg.Schema)this.deleteSchema, (org.apache.iceberg.Schema)pkSchema);
        StructProjection dataPKProjectRow = StructProjection.create((org.apache.iceberg.Schema)this.requiredSchema, (org.apache.iceberg.Schema)pkSchema);
        Iterable deleteRecords = Iterables.transform(this.eqDeletes, this::openDeletes);
        CloseableIterable records = CloseableIterable.transform((CloseableIterable)CloseableIterable.concat((Iterable)deleteRecords), Record::copy);
        if (this.deleteNodeFilter != null) {
            records = this.deleteNodeFilter.filter(records);
        }
        InternalRecordWrapper internalRecordWrapper = new InternalRecordWrapper(this.deleteSchema.asStruct());
        CloseableIterable structLikeIterable = CloseableIterable.transform((CloseableIterable)records, arg_0 -> ((InternalRecordWrapper)internalRecordWrapper).copyFor(arg_0));
        StructLikeBaseMap<ChangedLsn> structLikeMap = this.structLikeCollections.createStructLikeMap(pkSchema.asStruct());
        try (CloseableIterable deletes = structLikeIterable;){
            CloseableIterator it;
            Object object = it = this.getFileIO() == null ? deletes.iterator() : (Iterator)this.getFileIO().doAs(() -> ((CloseableIterable)deletes).iterator());
            while (it.hasNext()) {
                StructLike structLike = (StructLike)it.next();
                StructProjection deletePK = deletePKProjectRow.copyFor(structLike);
                ChangedLsn deleteLsn = this.deleteLSN(structLike);
                ChangedLsn old = (ChangedLsn)structLikeMap.get((StructLike)deletePK);
                if (old != null && old.compareTo(deleteLsn) > 0) continue;
                structLikeMap.put((StructLike)deletePK, deleteLsn);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Predicate<Object> isInDeleteSet = record -> {
            StructLike data = this.asStructLike(record);
            StructProjection dataPk = dataPKProjectRow.copyFor(data);
            ChangedLsn dataLSN = this.dataLSN(data);
            ChangedLsn deleteLsn = (ChangedLsn)structLikeMap.get((StructLike)dataPk);
            if (deleteLsn == null) {
                return false;
            }
            return deleteLsn.compareTo(dataLSN) > 0;
        };
        this.eqPredicate = new CloseablePredicate<Object>(isInDeleteSet, structLikeMap);
        return isInDeleteSet;
    }

    private CloseableIterable<T> applyEqDeletes(CloseableIterable<T> records, final Predicate<T> predicate) {
        if (this.eqDeletes.isEmpty()) {
            return records;
        }
        Filter remainingRowsFilter = new Filter<T>(){

            protected boolean shouldKeep(T item) {
                return predicate.test(item);
            }
        };
        return remainingRowsFilter.filter(records);
    }

    private CloseableIterable<Record> openDeletes(PrimaryKeyedFile deleteFile) {
        InputFile input = this.getInputFile(deleteFile.path().toString());
        HashMap<Integer, Object> idToConstant = new HashMap<Integer, Object>();
        idToConstant.put(2147482646, deleteFile.transactionId());
        switch (deleteFile.format()) {
            case AVRO: {
                return Avro.read((InputFile)input).project(this.deleteSchema).reuseContainers().createReaderFunc(fileSchema -> DataReader.create((org.apache.iceberg.Schema)this.deleteSchema, (Schema)fileSchema, (Map)idToConstant)).build();
            }
            case PARQUET: {
                return this.openParquet(input, this.deleteSchema, idToConstant);
            }
            case ORC: {
                return ORC.read((InputFile)input).project(this.deleteSchema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((org.apache.iceberg.Schema)this.deleteSchema, (TypeDescription)fileSchema, (Map)idToConstant)).build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read deletes, %s is not a supported format: %s", deleteFile.format().name(), deleteFile.path()));
    }

    protected CloseableIterable<Record> openParquet(InputFile input, org.apache.iceberg.Schema deleteSchema, Map<Integer, Object> idToConstant) {
        Parquet.ReadBuilder builder = Parquet.read((InputFile)input).project(deleteSchema).reuseContainers().createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((org.apache.iceberg.Schema)deleteSchema, (MessageType)fileSchema, (Map)idToConstant));
        return builder.build();
    }

    private Predicate<T> applyPosDeletes() {
        if (this.posDeletes.isEmpty()) {
            return record -> false;
        }
        if (this.positionMap == null) {
            this.positionMap = new HashMap<String, Set<Long>>();
            List deletes = Lists.transform(this.posDeletes, this::openPosDeletes);
            for (Record deleteRecord : CloseableIterable.concat((Iterable)deletes)) {
                String path = FILENAME_ACCESSOR.get((Object)deleteRecord).toString();
                if (!this.pathSets.contains(path)) continue;
                Set<Long> posSet = this.positionMap.get(path);
                if (posSet == null) {
                    posSet = new HashSet<Long>();
                    this.positionMap.put(path, posSet);
                }
                posSet.add((Long)POSITION_ACCESSOR.get((Object)deleteRecord));
            }
        }
        return item -> {
            Set<Long> posSet;
            if (this.currentDataPath != null) {
                if (this.currentPosSet == null) {
                    this.currentPosSet = this.positionMap.get(this.currentDataPath);
                }
                posSet = this.currentPosSet;
            } else {
                posSet = this.positionMap.get(this.filePath(item));
            }
            if (posSet == null) {
                return false;
            }
            return posSet.contains(this.pos(item));
        };
    }

    private CloseableIterable<T> apply(CloseableIterable<T> records, final Predicate<T> predicate) {
        Filter filter = new Filter<T>(){

            protected boolean shouldKeep(T item) {
                return predicate.test(item);
            }
        };
        return filter.filter(records);
    }

    private CloseableIterable<Record> openPosDeletes(DeleteFile file) {
        return this.openPositionDeletes(file, POS_DELETE_SCHEMA);
    }

    private CloseableIterable<Record> openPositionDeletes(DeleteFile deleteFile, org.apache.iceberg.Schema deleteSchema) {
        InputFile input = this.getInputFile(deleteFile.path().toString());
        switch (deleteFile.format()) {
            case AVRO: {
                return Avro.read((InputFile)input).project(deleteSchema).reuseContainers().createReaderFunc(DataReader::create).build();
            }
            case PARQUET: {
                Parquet.ReadBuilder builder = Parquet.read((InputFile)input).project(deleteSchema).reuseContainers().createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((org.apache.iceberg.Schema)deleteSchema, (MessageType)fileSchema));
                return builder.build();
            }
            case ORC: {
                return ORC.read((InputFile)input).project(deleteSchema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((org.apache.iceberg.Schema)deleteSchema, (TypeDescription)fileSchema)).build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read deletes, %s is not a supported format: %s", deleteFile.format().name(), deleteFile.path()));
    }

    private org.apache.iceberg.Schema fileProjection(org.apache.iceberg.Schema tableSchema, org.apache.iceberg.Schema requestedSchema, Collection<PrimaryKeyedFile> eqDeletes, Collection<DeleteFile> posDeletes) {
        if (eqDeletes.isEmpty() && posDeletes.isEmpty()) {
            return requestedSchema;
        }
        LinkedHashSet requiredIds = Sets.newLinkedHashSet();
        if (!posDeletes.isEmpty()) {
            requiredIds.add(MetadataColumns.FILE_PATH.fieldId());
            requiredIds.add(MetadataColumns.ROW_POSITION.fieldId());
        }
        if (!eqDeletes.isEmpty()) {
            requiredIds.addAll(this.primaryKeyId);
            requiredIds.add(org.apache.amoro.table.MetadataColumns.TRANSACTION_ID_FILED.fieldId());
            requiredIds.add(org.apache.amoro.table.MetadataColumns.FILE_OFFSET_FILED.fieldId());
        }
        LinkedHashSet missingIds = Sets.newLinkedHashSet((Iterable)Sets.difference((Set)requiredIds, (Set)TypeUtil.getProjectedIds((org.apache.iceberg.Schema)requestedSchema)));
        ArrayList columns = Lists.newArrayList((Iterable)requestedSchema.columns());
        Iterator iterator = missingIds.iterator();
        while (iterator.hasNext()) {
            int fieldId = (Integer)iterator.next();
            if (fieldId == MetadataColumns.ROW_POSITION.fieldId() || fieldId == MetadataColumns.FILE_PATH.fieldId() || fieldId == org.apache.amoro.table.MetadataColumns.TRANSACTION_ID_FILED.fieldId() || fieldId == org.apache.amoro.table.MetadataColumns.FILE_OFFSET_FILED.fieldId()) continue;
            Types.NestedField field = tableSchema.asStruct().field(fieldId);
            Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot find required field for ID %s", (int)fieldId);
            columns.add(field);
        }
        if (missingIds.contains(MetadataColumns.FILE_PATH.fieldId())) {
            columns.add(MetadataColumns.FILE_PATH);
        }
        if (missingIds.contains(MetadataColumns.ROW_POSITION.fieldId())) {
            columns.add(MetadataColumns.ROW_POSITION);
        }
        if (missingIds.contains(org.apache.amoro.table.MetadataColumns.TRANSACTION_ID_FILED.fieldId())) {
            columns.add(org.apache.amoro.table.MetadataColumns.TRANSACTION_ID_FILED);
        }
        if (missingIds.contains(org.apache.amoro.table.MetadataColumns.FILE_OFFSET_FILED.fieldId())) {
            columns.add(org.apache.amoro.table.MetadataColumns.FILE_OFFSET_FILED);
        }
        return new org.apache.iceberg.Schema((List)columns);
    }
}

