/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.RewriteStrategy;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.spark.SparkDistributionAndOrderingUtil;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.actions.SparkSortStrategy;
import org.apache.iceberg.spark.actions.SparkZOrderUDF;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SortOrderUtil;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkZOrderStrategy
extends SparkSortStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SparkZOrderStrategy.class);
    private static final String Z_COLUMN = "ICEZVALUE";
    private static final Schema Z_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"ICEZVALUE", (Type)Types.BinaryType.get())});
    private static final SortOrder Z_SORT_ORDER = SortOrder.builderFor((Schema)Z_SCHEMA).sortBy("ICEZVALUE", SortDirection.ASC, NullOrder.NULLS_LAST).build();
    private static final String MAX_OUTPUT_SIZE_KEY = "max-output-size";
    private static final int DEFAULT_MAX_OUTPUT_SIZE = Integer.MAX_VALUE;
    private static final String VAR_LENGTH_CONTRIBUTION_KEY = "var-length-contribution";
    private static final int DEFAULT_VAR_LENGTH_CONTRIBUTION = 8;
    private final List<String> zOrderColNames;
    private int maxOutputSize;
    private int varLengthContribution;

    @Override
    public Set<String> validOptions() {
        return ImmutableSet.builder().addAll(super.validOptions()).add((Object)VAR_LENGTH_CONTRIBUTION_KEY).add((Object)MAX_OUTPUT_SIZE_KEY).build();
    }

    @Override
    public RewriteStrategy options(Map<String, String> options) {
        super.options(options);
        this.varLengthContribution = PropertyUtil.propertyAsInt(options, (String)VAR_LENGTH_CONTRIBUTION_KEY, (int)8);
        Preconditions.checkArgument((this.varLengthContribution > 0 ? 1 : 0) != 0, (String)"Cannot use less than 1 byte for variable length types with zOrder, %s was set to %s", (Object)VAR_LENGTH_CONTRIBUTION_KEY, (int)this.varLengthContribution);
        this.maxOutputSize = PropertyUtil.propertyAsInt(options, (String)MAX_OUTPUT_SIZE_KEY, (int)Integer.MAX_VALUE);
        Preconditions.checkArgument((this.maxOutputSize > 0 ? 1 : 0) != 0, (String)"Cannot have the interleaved ZOrder value use less than 1 byte, %s was set to %s", (Object)MAX_OUTPUT_SIZE_KEY, (int)this.maxOutputSize);
        return this;
    }

    public SparkZOrderStrategy(Table table, SparkSession spark, List<String> zOrderColNames) {
        super(table, spark);
        Preconditions.checkArgument((zOrderColNames != null && !zOrderColNames.isEmpty() ? 1 : 0) != 0, (Object)"Cannot ZOrder when no columns are specified");
        Stream<String> identityPartitionColumns = table.spec().fields().stream().filter(f -> f.transform().isIdentity()).map(PartitionField::name);
        List partZOrderCols = identityPartitionColumns.filter(zOrderColNames::contains).collect(Collectors.toList());
        if (!partZOrderCols.isEmpty()) {
            LOG.warn("Cannot ZOrder on an Identity partition column as these values are constant within a partition and will be removed from the ZOrder expression: {}", partZOrderCols);
            zOrderColNames.removeAll(partZOrderCols);
            Preconditions.checkArgument((!zOrderColNames.isEmpty() ? 1 : 0) != 0, (Object)"Cannot perform ZOrdering, all columns provided were identity partition columns and cannot be used.");
        }
        this.validateColumnsExistence(table, spark, zOrderColNames);
        this.zOrderColNames = zOrderColNames;
    }

    private void validateColumnsExistence(Table table, SparkSession spark, List<String> colNames) {
        boolean caseSensitive = SparkUtil.caseSensitive(spark);
        Schema schema = table.schema();
        colNames.forEach(col -> {
            Types.NestedField nestedField;
            Types.NestedField nestedField2 = nestedField = caseSensitive ? schema.findField(col) : schema.caseInsensitiveFindField(col);
            if (nestedField == null) {
                throw new IllegalArgumentException(String.format("Cannot find column '%s' in table schema: %s", col, schema.asStruct()));
            }
        });
    }

    public String name() {
        return "Z-ORDER";
    }

    protected void validateOptions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DataFile> rewriteFiles(List<FileScanTask> filesToRewrite) {
        SparkZOrderUDF zOrderUDF = new SparkZOrderUDF(this.zOrderColNames.size(), this.varLengthContribution, this.maxOutputSize);
        String groupID = UUID.randomUUID().toString();
        boolean requiresRepartition = !filesToRewrite.get(0).spec().equals((Object)this.table().spec());
        org.apache.spark.sql.connector.expressions.SortOrder[] ordering = requiresRepartition ? SparkDistributionAndOrderingUtil.convert(SortOrderUtil.buildSortOrder((Table)this.table(), (SortOrder)this.sortOrder())) : SparkDistributionAndOrderingUtil.convert(this.sortOrder());
        OrderedDistribution distribution = Distributions.ordered((org.apache.spark.sql.connector.expressions.SortOrder[])ordering);
        try {
            this.tableCache().add(groupID, this.table());
            this.manager().stageTasks(this.table(), groupID, filesToRewrite);
            SparkSession spark = this.spark();
            long numOutputFiles = this.numOutputFiles((long)((double)this.inputFileSize(filesToRewrite) * this.sizeEstimateMultiple()));
            spark.conf().set(SQLConf.SHUFFLE_PARTITIONS().key(), Math.max(1L, numOutputFiles));
            Dataset scanDF = spark.read().format("iceberg").option("file-scan-task-set-id", groupID).load(groupID);
            Column[] originalColumns = (Column[])Arrays.stream(scanDF.schema().names()).map(n -> functions.col((String)n)).toArray(Column[]::new);
            List zOrderColumns = this.zOrderColNames.stream().map(arg_0 -> ((StructType)scanDF.schema()).apply(arg_0)).collect(Collectors.toList());
            Column zvalueArray = functions.array((Column[])((Column[])zOrderColumns.stream().map(colStruct -> zOrderUDF.sortedLexicographically(functions.col((String)colStruct.name()), colStruct.dataType())).toArray(Column[]::new)));
            Dataset zvalueDF = scanDF.withColumn(Z_COLUMN, zOrderUDF.interleaveBytes(zvalueArray));
            SQLConf sqlConf = spark.sessionState().conf();
            LogicalPlan sortPlan = this.sortPlan((Distribution)distribution, ordering, zvalueDF.logicalPlan(), sqlConf);
            Dataset sortedDf = new Dataset(spark, sortPlan, zvalueDF.encoder());
            sortedDf.select(originalColumns).write().format("iceberg").option("rewritten-file-scan-task-set-id", groupID).option("target-file-size-bytes", this.writeMaxFileSize()).option("use-table-distribution-and-ordering", "false").mode("append").save(groupID);
            Set<DataFile> set = this.rewriteCoordinator().fetchNewDataFiles(this.table(), groupID);
            return set;
        }
        finally {
            this.tableCache().remove(groupID);
            this.manager().removeTasks(this.table(), groupID);
            this.rewriteCoordinator().clearRewrite(this.table(), groupID);
        }
    }

    protected SortOrder sortOrder() {
        return Z_SORT_ORDER;
    }
}

