/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import java.util.Objects;
import org.apache.iceberg.ChangelogScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.source.ChangelogRowReader;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.spark.source.SparkInputPartition;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;

class SparkChangelogBatch
implements Batch {
    private final JavaSparkContext sparkContext;
    private final Table table;
    private final List<ScanTaskGroup<ChangelogScanTask>> taskGroups;
    private final Schema expectedSchema;
    private final boolean caseSensitive;
    private final boolean localityEnabled;
    private final int scanHashCode;

    SparkChangelogBatch(SparkSession spark, Table table, SparkReadConf readConf, List<ScanTaskGroup<ChangelogScanTask>> taskGroups, Schema expectedSchema, int scanHashCode) {
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        this.table = table;
        this.taskGroups = taskGroups;
        this.expectedSchema = expectedSchema;
        this.caseSensitive = readConf.caseSensitive();
        this.localityEnabled = readConf.localityEnabled();
        this.scanHashCode = scanHashCode;
    }

    public InputPartition[] planInputPartitions() {
        Table serializableTable = SerializableTableWithSize.copyOf(this.table);
        Broadcast tableBroadcast = this.sparkContext.broadcast((Object)serializableTable);
        String expectedSchemaString = SchemaParser.toJson((Schema)this.expectedSchema);
        InputPartition[] partitions = new InputPartition[this.taskGroups.size()];
        Tasks.range((int)partitions.length).stopOnFailure().executeWith(this.localityEnabled ? ThreadPools.getWorkerPool() : null).run(index -> {
            partitions[index.intValue()] = new SparkInputPartition(this.taskGroups.get((int)index), (Broadcast<Table>)tableBroadcast, expectedSchemaString, this.caseSensitive, this.localityEnabled);
        });
        return partitions;
    }

    public PartitionReaderFactory createReaderFactory() {
        return new ReaderFactory();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparkChangelogBatch that = (SparkChangelogBatch)o;
        return this.table.name().equals(that.table.name()) && this.scanHashCode == that.scanHashCode;
    }

    public int hashCode() {
        return Objects.hash(this.table.name(), this.scanHashCode);
    }

    private static class RowReader
    extends ChangelogRowReader
    implements PartitionReader<InternalRow> {
        RowReader(SparkInputPartition partition) {
            super(partition.table(), (ScanTaskGroup<ChangelogScanTask>)partition.taskGroup(), partition.expectedSchema(), partition.isCaseSensitive());
        }
    }

    private static class ReaderFactory
    implements PartitionReaderFactory {
        private ReaderFactory() {
        }

        public PartitionReader<InternalRow> createReader(InputPartition partition) {
            Preconditions.checkArgument((boolean)(partition instanceof SparkInputPartition), (String)"Unknown input partition type: %s", (Object)partition.getClass().getName());
            return new RowReader((SparkInputPartition)partition);
        }
    }
}

