/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iceberg.ChangelogScanTask;
import org.apache.iceberg.IncrementalChangelogScan;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.source.SparkChangelogBatch;
import org.apache.iceberg.spark.source.Stats;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsReportStatistics;
import org.apache.spark.sql.types.StructType;

class SparkChangelogScan
implements Scan,
SupportsReportStatistics {
    private final SparkSession spark;
    private final Table table;
    private final IncrementalChangelogScan scan;
    private final SparkReadConf readConf;
    private final Schema expectedSchema;
    private final List<Expression> filters;
    private final Long startSnapshotId;
    private final Long endSnapshotId;
    private final boolean readTimestampWithoutZone;
    private List<ScanTaskGroup<ChangelogScanTask>> taskGroups = null;
    private StructType expectedSparkType = null;

    SparkChangelogScan(SparkSession spark, Table table, IncrementalChangelogScan scan, SparkReadConf readConf, Schema expectedSchema, List<Expression> filters, boolean emptyScan) {
        SparkSchemaUtil.validateMetadataColumnReferences(table.schema(), expectedSchema);
        this.spark = spark;
        this.table = table;
        this.scan = scan;
        this.readConf = readConf;
        this.expectedSchema = expectedSchema;
        this.filters = filters != null ? filters : Collections.emptyList();
        this.startSnapshotId = readConf.startSnapshotId();
        this.endSnapshotId = readConf.endSnapshotId();
        this.readTimestampWithoutZone = readConf.handleTimestampWithoutZone();
        if (emptyScan) {
            this.taskGroups = Collections.emptyList();
        }
    }

    public Statistics estimateStatistics() {
        long rowsCount = this.taskGroups().stream().mapToLong(ScanTaskGroup::estimatedRowsCount).sum();
        long sizeInBytes = SparkSchemaUtil.estimateSize(this.readSchema(), rowsCount);
        return new Stats(sizeInBytes, rowsCount);
    }

    public StructType readSchema() {
        if (this.expectedSparkType == null) {
            Preconditions.checkArgument((this.readTimestampWithoutZone || !SparkUtil.hasTimestampWithoutZone(this.expectedSchema) ? 1 : 0) != 0, (Object)SparkUtil.TIMESTAMP_WITHOUT_TIMEZONE_ERROR);
            this.expectedSparkType = SparkSchemaUtil.convert(this.expectedSchema);
        }
        return this.expectedSparkType;
    }

    public Batch toBatch() {
        return new SparkChangelogBatch(this.spark, this.table, this.readConf, this.taskGroups(), this.expectedSchema, this.hashCode());
    }

    private List<ScanTaskGroup<ChangelogScanTask>> taskGroups() {
        if (this.taskGroups == null) {
            try (CloseableIterable groups = this.scan.planTasks();){
                this.taskGroups = Lists.newArrayList((Iterable)groups);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close changelog scan: " + this.scan, e);
            }
        }
        return this.taskGroups;
    }

    public String description() {
        return String.format("%s [fromSnapshotId=%d, toSnapshotId=%d, filters=%s]", this.table, this.startSnapshotId, this.endSnapshotId, this.filtersAsString());
    }

    public String toString() {
        return String.format("IcebergChangelogScan(table=%s, type=%s, fromSnapshotId=%d, toSnapshotId=%d, filters=%s)", this.table, this.expectedSchema.asStruct(), this.startSnapshotId, this.endSnapshotId, this.filtersAsString());
    }

    private String filtersAsString() {
        return this.filters.stream().map(Spark3Util::describe).collect(Collectors.joining(", "));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparkChangelogScan that = (SparkChangelogScan)o;
        return this.table.name().equals(that.table.name()) && this.readSchema().equals((Object)that.readSchema()) && this.filters.toString().equals(that.filters.toString()) && Objects.equals(this.startSnapshotId, that.startSnapshotId) && Objects.equals(this.endSnapshotId, that.endSnapshotId);
    }

    public int hashCode() {
        return Objects.hash(this.table.name(), this.readSchema(), this.filters.toString(), this.startSnapshotId, this.endSnapshotId);
    }
}

