/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.OptimizerRegisterInfo;
import org.apache.amoro.api.OptimizingService;
import org.apache.amoro.api.OptimizingTask;
import org.apache.amoro.api.OptimizingTaskId;
import org.apache.amoro.api.OptimizingTaskResult;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.api.config.TableConfiguration;
import org.apache.amoro.api.resource.Resource;
import org.apache.amoro.api.resource.ResourceGroup;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.exception.ForbiddenException;
import org.apache.amoro.server.exception.ObjectNotExistsException;
import org.apache.amoro.server.exception.PluginRetryAuthException;
import org.apache.amoro.server.exception.TaskNotFoundException;
import org.apache.amoro.server.optimizing.OptimizingQueue;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.optimizing.TaskRuntime;
import org.apache.amoro.server.persistence.StatedPersistentBase;
import org.apache.amoro.server.persistence.mapper.OptimizerMapper;
import org.apache.amoro.server.persistence.mapper.ResourceMapper;
import org.apache.amoro.server.resource.OptimizerInstance;
import org.apache.amoro.server.resource.OptimizerManager;
import org.apache.amoro.server.resource.OptimizerThread;
import org.apache.amoro.server.resource.QuotaProvider;
import org.apache.amoro.server.table.DefaultTableService;
import org.apache.amoro.server.table.RuntimeHandlerChain;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableRuntimeMeta;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.amoro.shade.guava32.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOptimizingService
extends StatedPersistentBase
implements OptimizingService.Iface,
OptimizerManager,
QuotaProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOptimizingService.class);
    private final long optimizerTouchTimeout;
    private final long taskAckTimeout;
    private final int maxPlanningParallelism;
    private final long pollingTimeout;
    private final Map<String, OptimizingQueue> optimizingQueueByGroup = new ConcurrentHashMap<String, OptimizingQueue>();
    private final Map<String, OptimizingQueue> optimizingQueueByToken = new ConcurrentHashMap<String, OptimizingQueue>();
    private final Map<String, OptimizerInstance> authOptimizers = new ConcurrentHashMap<String, OptimizerInstance>();
    private final OptimizerKeeper optimizerKeeper = new OptimizerKeeper();
    private final TableService tableService;
    private final RuntimeHandlerChain tableHandlerChain;
    private final Executor planExecutor;

    public DefaultOptimizingService(Configurations serviceConfig, DefaultTableService tableService) {
        this.optimizerTouchTimeout = serviceConfig.getLong(AmoroManagementConf.OPTIMIZER_HB_TIMEOUT);
        this.taskAckTimeout = serviceConfig.getLong(AmoroManagementConf.OPTIMIZER_TASK_ACK_TIMEOUT);
        this.maxPlanningParallelism = serviceConfig.getInteger(AmoroManagementConf.OPTIMIZER_MAX_PLANNING_PARALLELISM);
        this.pollingTimeout = serviceConfig.getLong(AmoroManagementConf.OPTIMIZER_POLLING_TIMEOUT);
        this.tableService = tableService;
        this.tableHandlerChain = new TableRuntimeHandlerImpl();
        this.planExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("plan-executor-thread-%d").setDaemon(true).build());
    }

    public RuntimeHandlerChain getTableRuntimeHandler() {
        return this.tableHandlerChain;
    }

    private void loadOptimizingQueues(List<TableRuntimeMeta> tableRuntimeMetaList) {
        List optimizerGroups = this.getAs(ResourceMapper.class, ResourceMapper::selectResourceGroups);
        List optimizers = this.getAs(OptimizerMapper.class, OptimizerMapper::selectAll);
        Map<String, List<TableRuntimeMeta>> groupToTableRuntimes = tableRuntimeMetaList.stream().collect(Collectors.groupingBy(TableRuntimeMeta::getOptimizerGroup));
        optimizerGroups.forEach(group -> {
            String groupName = group.getName();
            List tableRuntimeMetas = (List)groupToTableRuntimes.remove(groupName);
            OptimizingQueue optimizingQueue = new OptimizingQueue(this.tableService, (ResourceGroup)group, this, this.planExecutor, Optional.ofNullable(tableRuntimeMetas).orElseGet(ArrayList::new), this.maxPlanningParallelism);
            this.optimizingQueueByGroup.put(groupName, optimizingQueue);
        });
        optimizers.forEach(optimizer -> this.registerOptimizer((OptimizerInstance)((Object)optimizer), false));
        groupToTableRuntimes.keySet().forEach(groupName -> LOG.warn("Unloaded task runtime in group {}", groupName));
    }

    private void registerOptimizer(OptimizerInstance optimizer, boolean needPersistency) {
        if (needPersistency) {
            this.doAs(OptimizerMapper.class, mapper -> mapper.insertOptimizer(optimizer));
        }
        OptimizingQueue optimizingQueue = this.optimizingQueueByGroup.get(optimizer.getGroupName());
        optimizingQueue.addOptimizer(optimizer);
        this.authOptimizers.put(optimizer.getToken(), optimizer);
        this.optimizingQueueByToken.put(optimizer.getToken(), optimizingQueue);
        this.optimizerKeeper.keepInTouch(optimizer);
    }

    private void unregisterOptimizer(String token) {
        this.doAs(OptimizerMapper.class, mapper -> mapper.deleteOptimizer(token));
        OptimizingQueue optimizingQueue = this.optimizingQueueByToken.remove(token);
        OptimizerInstance optimizer = this.authOptimizers.remove(token);
        optimizingQueue.removeOptimizer(optimizer);
    }

    public void ping() {
    }

    public List<TaskRuntime> listTasks(String optimizerGroup) {
        return this.getQueueByGroup(optimizerGroup).collectTasks();
    }

    public void touch(String authToken) {
        OptimizerInstance optimizer = this.getAuthenticatedOptimizer(authToken).touch();
        LOG.debug("Optimizer {} touch time: {}", (Object)optimizer.getToken(), (Object)optimizer.getTouchTime());
        this.doAs(OptimizerMapper.class, mapper -> mapper.updateTouchTime(optimizer.getToken()));
    }

    private OptimizerInstance getAuthenticatedOptimizer(String authToken) {
        Preconditions.checkArgument((authToken != null ? 1 : 0) != 0, (Object)"authToken can not be null");
        return Optional.ofNullable(this.authOptimizers.get(authToken)).orElseThrow(() -> new PluginRetryAuthException("Optimizer has not been authenticated"));
    }

    public OptimizingTask pollTask(String authToken, int threadId) {
        LOG.debug("Optimizer {} (threadId {}) try polling task", (Object)authToken, (Object)threadId);
        OptimizingQueue queue = this.getQueueByToken(authToken);
        return Optional.ofNullable(queue.pollTask(this.pollingTimeout)).map(task -> this.extractOptimizingTask((TaskRuntime)task, authToken, threadId, queue)).orElse(null);
    }

    private OptimizingTask extractOptimizingTask(TaskRuntime task, String authToken, int threadId, OptimizingQueue queue) {
        try {
            OptimizerThread optimizerThread = this.getAuthenticatedOptimizer(authToken).getThread(threadId);
            task.schedule(optimizerThread);
            LOG.info("OptimizerThread {} polled task {}", (Object)optimizerThread, (Object)task.getTaskId());
            return task.getOptimizingTask();
        }
        catch (Throwable throwable) {
            LOG.error("Schedule task {} failed, put it to retry queue", (Object)task.getTaskId(), (Object)throwable);
            queue.retryTask(task);
            return null;
        }
    }

    public void ackTask(String authToken, int threadId, OptimizingTaskId taskId) {
        LOG.info("Ack task {} by optimizer {} (threadId {})", new Object[]{taskId, authToken, threadId});
        OptimizingQueue queue = this.getQueueByToken(authToken);
        Optional.ofNullable(queue.getTask(taskId)).orElseThrow(() -> new TaskNotFoundException(taskId)).ack(this.getAuthenticatedOptimizer(authToken).getThread(threadId));
    }

    public void completeTask(String authToken, OptimizingTaskResult taskResult) {
        LOG.info("Optimizer {} (threadId {}) complete task {}", new Object[]{authToken, taskResult.getThreadId(), taskResult.getTaskId()});
        OptimizingQueue queue = this.getQueueByToken(authToken);
        OptimizerThread thread = this.getAuthenticatedOptimizer(authToken).getThread(taskResult.getThreadId());
        Optional.ofNullable(queue.getTask(taskResult.getTaskId())).orElseThrow(() -> new TaskNotFoundException(taskResult.getTaskId())).complete(thread, taskResult);
    }

    public String authenticate(OptimizerRegisterInfo registerInfo) {
        LOG.info("Register optimizer {}.", (Object)registerInfo);
        Optional.ofNullable(registerInfo.getProperties().get("heart-beat-interval")).ifPresent(interval -> {
            if (Long.parseLong(interval) >= this.optimizerTouchTimeout) {
                throw new ForbiddenException(String.format("The %s:%s configuration should be less than AMS's %s:%s", "heart-beat-interval", interval, AmoroManagementConf.OPTIMIZER_HB_TIMEOUT.key(), this.optimizerTouchTimeout));
            }
        });
        OptimizingQueue queue = this.getQueueByGroup(registerInfo.getGroupName());
        OptimizerInstance optimizer = new OptimizerInstance(registerInfo, queue.getContainerName());
        this.registerOptimizer(optimizer, true);
        return optimizer.getToken();
    }

    private OptimizingQueue getQueueByGroup(String optimizerGroup) {
        return this.getOptionalQueueByGroup(optimizerGroup).orElseThrow(() -> new ObjectNotExistsException("Optimizer group " + optimizerGroup));
    }

    private Optional<OptimizingQueue> getOptionalQueueByGroup(String optimizerGroup) {
        Preconditions.checkArgument((optimizerGroup != null ? 1 : 0) != 0, (Object)"optimizerGroup can not be null");
        return Optional.ofNullable(this.optimizingQueueByGroup.get(optimizerGroup));
    }

    private OptimizingQueue getQueueByToken(String token) {
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"optimizer token can not be null");
        return Optional.ofNullable(this.optimizingQueueByToken.get(token)).orElseThrow(() -> new PluginRetryAuthException("Optimizer has not been authenticated"));
    }

    @Override
    public List<OptimizerInstance> listOptimizers() {
        return ImmutableList.copyOf(this.authOptimizers.values());
    }

    @Override
    public List<OptimizerInstance> listOptimizers(String group) {
        return this.authOptimizers.values().stream().filter(optimizer -> optimizer.getGroupName().equals(group)).collect(Collectors.toList());
    }

    @Override
    public void deleteOptimizer(String group, String resourceId) {
        List deleteOptimizers = this.getAs(OptimizerMapper.class, mapper -> mapper.selectByResourceId(resourceId));
        deleteOptimizers.forEach(optimizer -> {
            String token = optimizer.getToken();
            this.unregisterOptimizer(token);
        });
    }

    public void createResourceGroup(ResourceGroup resourceGroup) {
        this.doAsTransaction(() -> {
            this.doAs(ResourceMapper.class, mapper -> mapper.insertResourceGroup(resourceGroup));
            OptimizingQueue optimizingQueue = new OptimizingQueue(this.tableService, resourceGroup, this, this.planExecutor, new ArrayList<TableRuntimeMeta>(), this.maxPlanningParallelism);
            this.optimizingQueueByGroup.put(resourceGroup.getName(), optimizingQueue);
        });
    }

    public void deleteResourceGroup(String groupName) {
        if (!this.canDeleteResourceGroup(groupName)) {
            throw new RuntimeException(String.format("The resource group %s cannot be deleted because it is currently in use.", groupName));
        }
        this.doAs(ResourceMapper.class, mapper -> mapper.deleteResourceGroup(groupName));
        OptimizingQueue optimizingQueue = this.optimizingQueueByGroup.remove(groupName);
        optimizingQueue.dispose();
    }

    public void updateResourceGroup(ResourceGroup resourceGroup) {
        Preconditions.checkNotNull((Object)resourceGroup, (Object)"The resource group cannot be null.");
        Optional.ofNullable(this.optimizingQueueByGroup.get(resourceGroup.getName())).ifPresent(queue -> queue.updateOptimizerGroup(resourceGroup));
        this.doAs(ResourceMapper.class, mapper -> mapper.updateResourceGroup(resourceGroup));
    }

    public void createResource(Resource resource) {
        this.doAs(ResourceMapper.class, mapper -> mapper.insertResource(resource));
    }

    public void deleteResource(String resourceId) {
        this.doAs(ResourceMapper.class, mapper -> mapper.deleteResource(resourceId));
    }

    public List<ResourceGroup> listResourceGroups() {
        return this.getAs(ResourceMapper.class, ResourceMapper::selectResourceGroups);
    }

    public List<ResourceGroup> listResourceGroups(String containerName) {
        return this.getAs(ResourceMapper.class, ResourceMapper::selectResourceGroups).stream().filter(group -> group.getContainer().equals(containerName)).collect(Collectors.toList());
    }

    public ResourceGroup getResourceGroup(String groupName) {
        return this.getAs(ResourceMapper.class, mapper -> mapper.selectResourceGroup(groupName));
    }

    public List<Resource> listResourcesByGroup(String groupName) {
        return this.getAs(ResourceMapper.class, mapper -> mapper.selectResourcesByGroup(groupName));
    }

    public Resource getResource(String resourceId) {
        return this.getAs(ResourceMapper.class, mapper -> mapper.selectResource(resourceId));
    }

    public void dispose() {
        this.optimizerKeeper.dispose();
        this.tableHandlerChain.dispose();
        this.optimizingQueueByGroup.clear();
        this.optimizingQueueByToken.clear();
        this.authOptimizers.clear();
    }

    public boolean canDeleteResourceGroup(String name) {
        for (CatalogMeta catalogMeta : this.tableService.listCatalogMetas()) {
            if (catalogMeta.getCatalogProperties() == null || !catalogMeta.getCatalogProperties().getOrDefault("table.self-optimizing.group", "default").equals(name)) continue;
            return false;
        }
        for (OptimizerInstance optimizer : this.listOptimizers()) {
            if (!optimizer.getGroupName().equals(name)) continue;
            return false;
        }
        for (ServerTableIdentifier identifier : this.tableService.listManagedTables()) {
            if (!this.optimizingQueueByGroup.containsKey(name) || !this.optimizingQueueByGroup.get(name).containsTable(identifier)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTotalQuota(String resourceGroup) {
        return this.authOptimizers.values().stream().filter(optimizer -> optimizer.getGroupName().equals(resourceGroup)).mapToInt(Resource::getThreadCount).sum();
    }

    private class OptimizerKeeper
    implements Runnable {
        private volatile boolean stopped = false;
        private final Thread thread = new Thread((Runnable)this, "optimizer-keeper-thread");
        private final DelayQueue<OptimizerKeepingTask> suspendingQueue = new DelayQueue();

        public OptimizerKeeper() {
            this.thread.setDaemon(true);
        }

        public void keepInTouch(OptimizerInstance optimizerInstance) {
            Preconditions.checkNotNull((Object)((Object)optimizerInstance), (Object)"token can not be null");
            this.suspendingQueue.add(new OptimizerKeepingTask(optimizerInstance));
        }

        public void start() {
            this.thread.start();
        }

        public void dispose() {
            this.stopped = true;
            this.thread.interrupt();
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    OptimizerKeepingTask keepingTask = (OptimizerKeepingTask)this.suspendingQueue.take();
                    String token = keepingTask.getToken();
                    boolean isExpired = !keepingTask.tryKeeping();
                    Optional.ofNullable(keepingTask.getQueue()).ifPresent(queue -> queue.collectTasks(this.buildSuspendingPredication(DefaultOptimizingService.this.authOptimizers.keySet())).forEach(task -> this.retryTask((TaskRuntime)task, (OptimizingQueue)queue)));
                    if (isExpired) {
                        LOG.info("Optimizer {} has been expired, unregister it", (Object)keepingTask.getOptimizer());
                        DefaultOptimizingService.this.unregisterOptimizer(token);
                        continue;
                    }
                    LOG.debug("Optimizer {} is being touched, keep it", (Object)keepingTask.getOptimizer());
                    this.keepInTouch(keepingTask.getOptimizer());
                }
                catch (InterruptedException keepingTask) {
                }
                catch (Throwable t) {
                    LOG.error("OptimizerKeeper has encountered a problem.", t);
                }
            }
        }

        private void retryTask(TaskRuntime task, OptimizingQueue queue) {
            LOG.info("Task {} is suspending, since it's optimizer is expired, put it to retry queue, optimizer {}", (Object)task.getTaskId(), (Object)task.getResourceDesc());
            queue.retryTask(task);
        }

        private Predicate<TaskRuntime> buildSuspendingPredication(Set<String> activeTokens) {
            return task -> StringUtils.isNotBlank((CharSequence)task.getToken()) && !activeTokens.contains(task.getToken()) && task.getStatus() != TaskRuntime.Status.SUCCESS || task.getStatus() == TaskRuntime.Status.SCHEDULED && task.getStartTime() + DefaultOptimizingService.this.taskAckTimeout < System.currentTimeMillis();
        }
    }

    private class OptimizerKeepingTask
    implements Delayed {
        private final OptimizerInstance optimizerInstance;
        private final long lastTouchTime;

        public OptimizerKeepingTask(OptimizerInstance optimizer) {
            this.optimizerInstance = optimizer;
            this.lastTouchTime = optimizer.getTouchTime();
        }

        public boolean tryKeeping() {
            return Objects.equals((Object)this.optimizerInstance, DefaultOptimizingService.this.authOptimizers.get(this.optimizerInstance.getToken())) && this.lastTouchTime != this.optimizerInstance.getTouchTime();
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            return unit.convert(this.lastTouchTime + DefaultOptimizingService.this.optimizerTouchTimeout - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed o) {
            OptimizerKeepingTask another = (OptimizerKeepingTask)o;
            return Long.compare(this.lastTouchTime, another.lastTouchTime);
        }

        public String getToken() {
            return this.optimizerInstance.getToken();
        }

        public OptimizingQueue getQueue() {
            return (OptimizingQueue)DefaultOptimizingService.this.optimizingQueueByGroup.get(this.optimizerInstance.getGroupName());
        }

        public OptimizerInstance getOptimizer() {
            return this.optimizerInstance;
        }
    }

    private class TableRuntimeHandlerImpl
    extends RuntimeHandlerChain {
        private TableRuntimeHandlerImpl() {
        }

        @Override
        public void handleStatusChanged(TableRuntime tableRuntime, OptimizingStatus originalStatus) {
            if (!tableRuntime.getOptimizingStatus().isProcessing()) {
                DefaultOptimizingService.this.getOptionalQueueByGroup(tableRuntime.getOptimizerGroup()).ifPresent(q -> q.refreshTable(tableRuntime));
            }
        }

        @Override
        public void handleConfigChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
            String originalGroup = originalConfig.getOptimizingConfig().getOptimizerGroup();
            if (!tableRuntime.getOptimizerGroup().equals(originalGroup)) {
                DefaultOptimizingService.this.getOptionalQueueByGroup(originalGroup).ifPresent(q -> q.releaseTable(tableRuntime));
            }
            DefaultOptimizingService.this.getOptionalQueueByGroup(tableRuntime.getOptimizerGroup()).ifPresent(q -> q.refreshTable(tableRuntime));
        }

        @Override
        public void handleTableAdded(AmoroTable<?> table, TableRuntime tableRuntime) {
            DefaultOptimizingService.this.getOptionalQueueByGroup(tableRuntime.getOptimizerGroup()).ifPresent(q -> q.refreshTable(tableRuntime));
        }

        @Override
        public void handleTableRemoved(TableRuntime tableRuntime) {
            DefaultOptimizingService.this.getOptionalQueueByGroup(tableRuntime.getOptimizerGroup()).ifPresent(queue -> queue.releaseTable(tableRuntime));
        }

        @Override
        protected void initHandler(List<TableRuntimeMeta> tableRuntimeMetaList) {
            LOG.info("OptimizerManagementService begin initializing");
            DefaultOptimizingService.this.loadOptimizingQueues(tableRuntimeMetaList);
            DefaultOptimizingService.this.optimizerKeeper.start();
            LOG.info("SuspendingDetector for Optimizer has been started.");
            LOG.info("OptimizerManagementService initializing has completed");
        }

        @Override
        protected void doDispose() {
        }
    }
}

