/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.TableIdentifier;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.server.catalog.ServerCatalog;
import org.apache.amoro.server.dashboard.FormatTableDescriptor;
import org.apache.amoro.server.dashboard.MixedAndIcebergTableDescriptor;
import org.apache.amoro.server.dashboard.PaimonTableDescriptor;
import org.apache.amoro.server.dashboard.model.AmoroSnapshotsOfTable;
import org.apache.amoro.server.dashboard.model.DDLInfo;
import org.apache.amoro.server.dashboard.model.OperationType;
import org.apache.amoro.server.dashboard.model.OptimizingProcessInfo;
import org.apache.amoro.server.dashboard.model.OptimizingTaskInfo;
import org.apache.amoro.server.dashboard.model.PartitionBaseInfo;
import org.apache.amoro.server.dashboard.model.PartitionFileBaseInfo;
import org.apache.amoro.server.dashboard.model.ServerTableMeta;
import org.apache.amoro.server.dashboard.model.TagOrBranchInfo;
import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.server.table.TableService;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.ThreadPools;

public class ServerTableDescriptor
extends PersistentBase {
    private final Map<TableFormat, FormatTableDescriptor> formatDescriptorMap = new HashMap<TableFormat, FormatTableDescriptor>();
    private final TableService tableService;

    public ServerTableDescriptor(TableService tableService, Configurations serviceConfig) {
        FormatTableDescriptor[] formatTableDescriptors;
        this.tableService = tableService;
        ExecutorService executorService = ThreadPools.getWorkerPool();
        for (FormatTableDescriptor formatTableDescriptor : formatTableDescriptors = new FormatTableDescriptor[]{new MixedAndIcebergTableDescriptor(executorService), new PaimonTableDescriptor(executorService)}) {
            for (TableFormat format : formatTableDescriptor.supportFormat()) {
                this.formatDescriptorMap.put(format, formatTableDescriptor);
            }
        }
    }

    public ServerTableMeta getTableDetail(TableIdentifier tableIdentifier) {
        AmoroTable<?> amoroTable = this.loadTable(tableIdentifier);
        FormatTableDescriptor formatTableDescriptor = this.formatDescriptorMap.get(amoroTable.format());
        return formatTableDescriptor.getTableDetail(amoroTable);
    }

    public List<AmoroSnapshotsOfTable> getSnapshots(TableIdentifier tableIdentifier, String ref, OperationType operationType) {
        AmoroTable<?> amoroTable = this.loadTable(tableIdentifier);
        FormatTableDescriptor formatTableDescriptor = this.formatDescriptorMap.get(amoroTable.format());
        return formatTableDescriptor.getSnapshots(amoroTable, ref, operationType);
    }

    public List<PartitionFileBaseInfo> getSnapshotDetail(TableIdentifier tableIdentifier, long snapshotId) {
        AmoroTable<?> amoroTable = this.loadTable(tableIdentifier);
        FormatTableDescriptor formatTableDescriptor = this.formatDescriptorMap.get(amoroTable.format());
        return formatTableDescriptor.getSnapshotDetail(amoroTable, snapshotId);
    }

    public List<DDLInfo> getTableOperations(TableIdentifier tableIdentifier) {
        AmoroTable<?> amoroTable = this.loadTable(tableIdentifier);
        FormatTableDescriptor formatTableDescriptor = this.formatDescriptorMap.get(amoroTable.format());
        return formatTableDescriptor.getTableOperations(amoroTable);
    }

    public List<PartitionBaseInfo> getTablePartition(TableIdentifier tableIdentifier) {
        AmoroTable<?> amoroTable = this.loadTable(tableIdentifier);
        FormatTableDescriptor formatTableDescriptor = this.formatDescriptorMap.get(amoroTable.format());
        return formatTableDescriptor.getTablePartitions(amoroTable);
    }

    public List<PartitionFileBaseInfo> getTableFile(TableIdentifier tableIdentifier, String partition, Integer specId) {
        AmoroTable<?> amoroTable = this.loadTable(tableIdentifier);
        FormatTableDescriptor formatTableDescriptor = this.formatDescriptorMap.get(amoroTable.format());
        return formatTableDescriptor.getTableFiles(amoroTable, partition, specId);
    }

    public List<TagOrBranchInfo> getTableTags(TableIdentifier tableIdentifier) {
        AmoroTable<?> amoroTable = this.loadTable(tableIdentifier);
        FormatTableDescriptor formatTableDescriptor = this.formatDescriptorMap.get(amoroTable.format());
        return formatTableDescriptor.getTableTags(amoroTable);
    }

    public List<TagOrBranchInfo> getTableBranches(TableIdentifier tableIdentifier) {
        AmoroTable<?> amoroTable = this.loadTable(tableIdentifier);
        FormatTableDescriptor formatTableDescriptor = this.formatDescriptorMap.get(amoroTable.format());
        return formatTableDescriptor.getTableBranches(amoroTable);
    }

    public Pair<List<OptimizingProcessInfo>, Integer> getOptimizingProcessesInfo(TableIdentifier tableIdentifier, int limit, int offset) {
        AmoroTable<?> amoroTable = this.loadTable(tableIdentifier);
        FormatTableDescriptor formatTableDescriptor = this.formatDescriptorMap.get(amoroTable.format());
        return formatTableDescriptor.getOptimizingProcessesInfo(amoroTable, limit, offset);
    }

    public List<OptimizingTaskInfo> getOptimizingProcessTaskInfos(TableIdentifier tableIdentifier, long processId) {
        AmoroTable<?> amoroTable = this.loadTable(tableIdentifier);
        FormatTableDescriptor formatTableDescriptor = this.formatDescriptorMap.get(amoroTable.format());
        return formatTableDescriptor.getOptimizingTaskInfos(amoroTable, processId);
    }

    private AmoroTable<?> loadTable(TableIdentifier identifier) {
        ServerCatalog catalog = this.tableService.getServerCatalog(identifier.getCatalog());
        return catalog.loadTable(identifier.getDatabase(), identifier.getTableName());
    }
}

