/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.component.reverser;

import java.util.ArrayList;
import java.util.List;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;

public class IcebergTypeToSparkType
extends TypeUtil.SchemaVisitor<DataType> {
    public DataType schema(Schema schema, DataType structType) {
        return structType;
    }

    public DataType struct(Types.StructType struct, List<DataType> fieldResults) {
        List fields = struct.fields();
        ArrayList sparkFields = Lists.newArrayListWithExpectedSize((int)fieldResults.size());
        for (int i = 0; i < fields.size(); ++i) {
            Types.NestedField field = (Types.NestedField)fields.get(i);
            DataType type = fieldResults.get(i);
            StructField sparkField = StructField.apply((String)field.name(), (DataType)type, (boolean)field.isOptional(), (Metadata)Metadata.empty());
            if (field.doc() != null) {
                sparkField = sparkField.withComment(field.doc());
            }
            sparkFields.add(sparkField);
        }
        return StructType$.MODULE$.apply((List)sparkFields);
    }

    public DataType field(Types.NestedField field, DataType fieldResult) {
        return fieldResult;
    }

    public DataType list(Types.ListType list, DataType elementResult) {
        return ArrayType$.MODULE$.apply(elementResult, list.isElementOptional());
    }

    public DataType map(Types.MapType map, DataType keyResult, DataType valueResult) {
        return MapType$.MODULE$.apply(keyResult, valueResult, map.isValueOptional());
    }

    public DataType primitive(Type.PrimitiveType primitive) {
        switch (primitive.typeId()) {
            case BOOLEAN: {
                return BooleanType$.MODULE$;
            }
            case INTEGER: {
                return IntegerType$.MODULE$;
            }
            case LONG: {
                return LongType$.MODULE$;
            }
            case FLOAT: {
                return FloatType$.MODULE$;
            }
            case DOUBLE: {
                return DoubleType$.MODULE$;
            }
            case DATE: {
                return DateType$.MODULE$;
            }
            case TIME: {
                throw new UnsupportedOperationException("Spark does not support time fields");
            }
            case TIMESTAMP: {
                return TimestampType$.MODULE$;
            }
            case STRING: {
                return StringType$.MODULE$;
            }
            case UUID: {
                return StringType$.MODULE$;
            }
            case FIXED: {
                return BinaryType$.MODULE$;
            }
            case BINARY: {
                return BinaryType$.MODULE$;
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                return DecimalType$.MODULE$.apply(decimal.precision(), decimal.scale());
            }
        }
        throw new UnsupportedOperationException("Cannot convert unknown type to Spark: " + primitive);
    }
}

