/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.controller;

import io.javalin.http.Context;
import java.io.InputStream;
import java.util.Properties;
import org.apache.amoro.server.dashboard.model.VersionInfo;
import org.apache.amoro.server.dashboard.response.OkResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionController {
    private static final Logger LOG = LoggerFactory.getLogger(VersionController.class);

    public void getVersionInfo(Context ctx) {
        Properties prop = new Properties();
        InputStream is = VersionController.class.getClassLoader().getResourceAsStream("amoro/git.properties");
        String version = "UNKNOWN";
        String commitTime = "UNKNOWN";
        String abbrev = "UNKNOWN";
        if (is != null) {
            try {
                prop.load(is);
                version = prop.getProperty("git.build.version");
                abbrev = prop.getProperty("git.commit.id.abbrev");
                commitTime = prop.getProperty("git.commit.time");
            }
            catch (Exception e) {
                LOG.warn("Failed to find git.properties.");
            }
        }
        VersionInfo versionInfo = new VersionInfo();
        versionInfo.setVersion(String.format("%s(%s)", version, abbrev));
        versionInfo.setCommitTime(commitTime);
        ctx.json(OkResponse.of(versionInfo));
    }
}

