/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.manager;

import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.api.resource.Resource;
import org.apache.amoro.server.manager.AbstractResourceContainer;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesOptimizerContainer
extends AbstractResourceContainer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesOptimizerContainer.class);
    public static final String MEMORY_PROPERTY = "memory";
    public static final String CPU_FACTOR_PROPERTY = "cpu.factor";
    public static final String NAMESPACE = "namespace";
    public static final String IMAGE = "image";
    public static final String PULL_POLICY = "pullPolicy";
    public static final String PULL_SECRETS = "imagePullSecrets";
    public static final String KUBE_CONFIG_PATH = "kube-config-path";
    private static final String NAME_PREFIX = "amoro-optimizer-";
    private static final String KUBERNETES_NAME_PROPERTIES = "name";
    private KubernetesClient client;

    @Override
    public void init(String name, Map<String, String> containerProperties) {
        super.init(name, containerProperties);
        String kubeConfigPath = KubernetesOptimizerContainer.checkAndGetProperty(containerProperties, KUBE_CONFIG_PATH);
        Config config = Config.fromKubeconfig((String)this.getKubeConfigContent(kubeConfigPath));
        this.client = new KubernetesClientBuilder().withConfig(config).build();
    }

    @Override
    protected Map<String, String> doScaleOut(Resource resource) {
        HashMap groupProperties = Maps.newHashMap();
        groupProperties.putAll(this.getContainerProperties());
        groupProperties.putAll(resource.getProperties());
        long memoryPerThread = Long.parseLong(KubernetesOptimizerContainer.checkAndGetProperty(groupProperties, MEMORY_PROPERTY));
        long memory = memoryPerThread * (long)resource.getThreadCount();
        String startUpArgs = String.format("/entrypoint.sh optimizer %s %s", memory, super.buildOptimizerStartupArgsString(resource));
        LOG.info("Starting k8s optimizer using k8s client with start command : {}", (Object)startUpArgs);
        String namespace = groupProperties.getOrDefault(NAMESPACE, "default");
        String image = KubernetesOptimizerContainer.checkAndGetProperty(groupProperties, IMAGE);
        String pullPolicy = KubernetesOptimizerContainer.checkAndGetProperty(groupProperties, PULL_POLICY);
        String pullSecrets = groupProperties.getOrDefault(PULL_SECRETS, "");
        String cpuLimitFactorString = groupProperties.getOrDefault(CPU_FACTOR_PROPERTY, "1.0");
        double cpuLimitFactor = Double.parseDouble(cpuLimitFactorString);
        int cpuLimit = (int)Math.ceil(cpuLimitFactor * (double)resource.getThreadCount());
        List imagePullSecretsList = Arrays.stream(pullSecrets.split(";")).map(secret -> ((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(secret)).build()).collect(Collectors.toList());
        String resourceId = resource.getResourceId();
        String groupName = resource.getGroupName();
        String kubernetesName = NAME_PREFIX + resourceId;
        DeploymentBuilder deploymentBuilder = (DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(NAME_PREFIX + resourceId)).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withNewTemplate().withNewMetadata().addToLabels("app", NAME_PREFIX + resourceId)).addToLabels("AmoroOptimizerGroup", groupName)).addToLabels("AmoroResourceId", resourceId)).endMetadata()).withNewSpec().addNewContainer().withName("optimizer")).withImage(image)).withImagePullPolicy(pullPolicy)).withCommand(new String[]{"sh", "-c", startUpArgs})).withResources(((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().withLimits((Map)ImmutableMap.of((Object)MEMORY_PROPERTY, (Object)new Quantity(memory + "Mi"), (Object)"cpu", (Object)new Quantity(cpuLimit + "")))).withRequests((Map)ImmutableMap.of((Object)MEMORY_PROPERTY, (Object)new Quantity(memory + "Mi"), (Object)"cpu", (Object)new Quantity(cpuLimit + "")))).build())).endContainer()).endSpec()).endTemplate()).withNewSelector().addToMatchLabels("app", NAME_PREFIX + resourceId)).endSelector()).endSpec();
        if (!imagePullSecretsList.isEmpty()) {
            ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)deploymentBuilder.editSpec().editTemplate().editSpec().withImagePullSecrets(imagePullSecretsList)).endSpec()).endTemplate()).endSpec();
        }
        Deployment deployment = deploymentBuilder.build();
        ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).resource((Object)deployment)).create();
        HashMap startupProperties = Maps.newHashMap();
        startupProperties.put(NAMESPACE, namespace);
        startupProperties.put(KUBERNETES_NAME_PROPERTIES, kubernetesName);
        return startupProperties;
    }

    public void releaseOptimizer(Resource resource) {
        String resourceId = resource.getResourceId();
        LOG.info("release Kubernetes Optimizer Container {}", (Object)resourceId);
        String namespace = (String)resource.getProperties().get(NAMESPACE);
        String name = (String)resource.getProperties().get(KUBERNETES_NAME_PROPERTIES);
        ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(name)).delete();
    }

    private static String checkAndGetProperty(Map<String, String> properties, String key) {
        Preconditions.checkState((properties != null && properties.containsKey(key) ? 1 : 0) != 0, (String)"Cannot find %s in properties", (Object)key);
        return properties.get(key);
    }

    private String getKubeConfigContent(String path) {
        try {
            return IOUtils.toString((InputStream)Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

