/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence.mapper;

import java.util.List;
import java.util.Map;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.server.optimizing.MetricsSummary;
import org.apache.amoro.server.optimizing.OptimizingProcess;
import org.apache.amoro.server.optimizing.OptimizingProcessMeta;
import org.apache.amoro.server.optimizing.OptimizingTaskMeta;
import org.apache.amoro.server.optimizing.OptimizingType;
import org.apache.amoro.server.optimizing.TaskRuntime;
import org.apache.amoro.server.persistence.converter.JsonObjectConverter;
import org.apache.amoro.server.persistence.converter.Long2TsConverter;
import org.apache.amoro.server.persistence.converter.Map2StringConverter;
import org.apache.amoro.server.persistence.converter.MapLong2StringConverter;
import org.apache.amoro.server.persistence.converter.Object2ByteArrayConvert;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.type.JdbcType;

public interface OptimizingMapper {
    @Delete(value={"DELETE FROM table_optimizing_process WHERE table_id = #{tableId} and process_id < #{time}"})
    public void deleteOptimizingProcessBefore(@Param(value="tableId") long var1, @Param(value="time") long var3);

    @Insert(value={"INSERT INTO table_optimizing_process(table_id, catalog_name, db_name, table_name ,process_id, target_snapshot_id, target_change_snapshot_id, status, optimizing_type, plan_time, summary, from_sequence, to_sequence) VALUES (#{table.id}, #{table.catalog}, #{table.database}, #{table.tableName}, #{processId}, #{targetSnapshotId}, #{targetChangeSnapshotId}, #{status}, #{optimizingType}, #{planTime, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}, #{summary, typeHandler=org.apache.amoro.server.persistence.converter.JsonObjectConverter}, #{fromSequence, typeHandler=org.apache.amoro.server.persistence.converter.MapLong2StringConverter}, #{toSequence, typeHandler=org.apache.amoro.server.persistence.converter.MapLong2StringConverter})"})
    public void insertOptimizingProcess(@Param(value="table") ServerTableIdentifier var1, @Param(value="processId") long var2, @Param(value="targetSnapshotId") long var4, @Param(value="targetChangeSnapshotId") long var6, @Param(value="status") OptimizingProcess.Status var8, @Param(value="optimizingType") OptimizingType var9, @Param(value="planTime") long var10, @Param(value="summary") MetricsSummary var12, @Param(value="fromSequence") Map<String, Long> var13, @Param(value="toSequence") Map<String, Long> var14);

    @Update(value={"UPDATE table_optimizing_process SET status = #{optimizingStatus}, end_time = #{endTime, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}, summary = #{summary, typeHandler=org.apache.amoro.server.persistence.converter.JsonObjectConverter}, fail_reason = #{failedReason, jdbcType=VARCHAR} WHERE table_id = #{tableId} AND process_id = #{processId}"})
    public void updateOptimizingProcess(@Param(value="tableId") long var1, @Param(value="processId") long var3, @Param(value="optimizingStatus") OptimizingProcess.Status var5, @Param(value="endTime") long var6, @Param(value="summary") MetricsSummary var8, @Param(value="failedReason") String var9);

    @Select(value={"SELECT a.process_id, a.table_id, a.catalog_name, a.db_name, a.table_name, a.target_snapshot_id, a.target_change_snapshot_id, a.status, a.optimizing_type, a.plan_time, a.end_time, a.fail_reason, a.summary, a.from_sequence, a.to_sequence FROM table_optimizing_process a INNER JOIN table_identifier b ON a.table_id = b.table_id WHERE a.catalog_name = #{catalogName} AND a.db_name = #{dbName} AND a.table_name = #{tableName} AND b.catalog_name = #{catalogName} AND b.db_name = #{dbName} AND b.table_name = #{tableName} ORDER BY process_id desc"})
    @Results(value={@Result(property="processId", column="process_id"), @Result(property="tableId", column="table_id"), @Result(property="catalogName", column="catalog_name"), @Result(property="dbName", column="db_name"), @Result(property="tableName", column="table_name"), @Result(property="targetSnapshotId", column="target_snapshot_id"), @Result(property="targetChangeSnapshotId", column="target_change_snapshot_id"), @Result(property="status", column="status"), @Result(property="optimizingType", column="optimizing_type"), @Result(property="planTime", column="plan_time", typeHandler=Long2TsConverter.class), @Result(property="endTime", column="end_time", typeHandler=Long2TsConverter.class), @Result(property="failReason", column="fail_reason"), @Result(property="summary", column="summary", typeHandler=JsonObjectConverter.class), @Result(property="fromSequence", column="from_sequence", typeHandler=MapLong2StringConverter.class), @Result(property="toSequence", column="to_sequence", typeHandler=MapLong2StringConverter.class)})
    public List<OptimizingProcessMeta> selectOptimizingProcesses(@Param(value="catalogName") String var1, @Param(value="dbName") String var2, @Param(value="tableName") String var3);

    @Insert(value={"<script>", "INSERT INTO task_runtime (process_id, task_id, retry_num, table_id, partition_data, start_time, end_time, status, fail_reason, optimizer_token, thread_id, rewrite_output, metrics_summary, properties) VALUES ", "<foreach collection='taskRuntimes' item='taskRuntime' index='index' separator=','>", "(#{taskRuntime.taskId.processId}, #{taskRuntime.taskId.taskId}, #{taskRuntime.runTimes}, #{taskRuntime.tableId}, #{taskRuntime.partition}, #{taskRuntime.startTime, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}, #{taskRuntime.endTime, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}, #{taskRuntime.status}, #{taskRuntime.failReason, jdbcType=VARCHAR}, #{taskRuntime.token, jdbcType=VARCHAR}, #{taskRuntime.threadId, jdbcType=INTEGER}, #{taskRuntime.output, jdbcType=BLOB,  typeHandler=org.apache.amoro.server.persistence.converter.Object2ByteArrayConvert}, #{taskRuntime.summary, typeHandler=org.apache.amoro.server.persistence.converter.JsonObjectConverter},#{taskRuntime.properties, typeHandler=org.apache.amoro.server.persistence.converter.Map2StringConverter})", "</foreach>", "</script>"})
    public void insertTaskRuntimes(@Param(value="taskRuntimes") List<TaskRuntime> var1);

    @Select(value={"SELECT process_id, task_id, retry_num, table_id, partition_data,  create_time, start_time, end_time, status, fail_reason, optimizer_token, thread_id, rewrite_output, metrics_summary, properties FROM task_runtime WHERE table_id = #{table_id} AND process_id = #{process_id}"})
    @Results(value={@Result(property="taskId.processId", column="process_id"), @Result(property="taskId.taskId", column="task_id"), @Result(property="runTimes", column="retry_num"), @Result(property="tableId", column="table_id"), @Result(property="partition", column="partition_data"), @Result(property="startTime", column="start_time", typeHandler=Long2TsConverter.class), @Result(property="endTime", column="end_time", typeHandler=Long2TsConverter.class), @Result(property="status", column="status"), @Result(property="failReason", column="fail_reason"), @Result(property="token", column="optimizer_token"), @Result(property="threadId", column="thread_id"), @Result(property="output", column="rewrite_output", typeHandler=Object2ByteArrayConvert.class), @Result(property="summary", column="metrics_summary", typeHandler=JsonObjectConverter.class), @Result(property="properties", column="properties", typeHandler=Map2StringConverter.class)})
    public List<TaskRuntime> selectTaskRuntimes(@Param(value="table_id") long var1, @Param(value="process_id") long var3);

    @Select(value={"<script>SELECT process_id, task_id, retry_num, table_id, partition_data, create_time, start_time, end_time, cost_time, status, fail_reason, optimizer_token, thread_id, metrics_summary, properties FROM task_runtime WHERE process_id IN<foreach item='item' index='index' collection='processIds' open='(' separator=',' close=')'>#{item}</foreach></script>"})
    @Results(value={@Result(property="processId", column="process_id"), @Result(property="taskId", column="task_id"), @Result(property="retryNum", column="retry_num"), @Result(property="tableId", column="table_id"), @Result(property="partitionData", column="partition_data"), @Result(property="createTime", column="create_time", typeHandler=Long2TsConverter.class), @Result(property="startTime", column="start_time", typeHandler=Long2TsConverter.class), @Result(property="endTime", column="end_time", typeHandler=Long2TsConverter.class), @Result(property="costTime", column="cost_time"), @Result(property="status", column="status"), @Result(property="failReason", column="fail_reason"), @Result(property="optimizerToken", column="optimizer_token"), @Result(property="threadId", column="thread_id"), @Result(property="metricsSummary", column="metrics_summary", typeHandler=JsonObjectConverter.class), @Result(property="properties", column="properties", typeHandler=Map2StringConverter.class)})
    public List<OptimizingTaskMeta> selectOptimizeTaskMetas(@Param(value="processIds") List<Long> var1);

    @Update(value={"UPDATE task_runtime SET retry_num = #{taskRuntime.runTimes}, start_time = #{taskRuntime.startTime, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}, end_time = #{taskRuntime.endTime, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}, cost_time = #{taskRuntime.costTime}, status = #{taskRuntime.status}, fail_reason = #{taskRuntime.failReason, jdbcType=VARCHAR}, optimizer_token = #{taskRuntime.token, jdbcType=VARCHAR}, thread_id = #{taskRuntime.threadId, jdbcType=INTEGER}, rewrite_output = #{taskRuntime.output, jdbcType=BLOB, typeHandler=org.apache.amoro.server.persistence.converter.Object2ByteArrayConvert}, metrics_summary = #{taskRuntime.summary, typeHandler=org.apache.amoro.server.persistence.converter.JsonObjectConverter}, properties = #{taskRuntime.properties, typeHandler=org.apache.amoro.server.persistence.converter.Map2StringConverter} WHERE process_id = #{taskRuntime.taskId.processId} AND task_id = #{taskRuntime.taskId.taskId}"})
    public void updateTaskRuntime(@Param(value="taskRuntime") TaskRuntime var1);

    @Delete(value={"DELETE FROM task_runtime WHERE table_id = #{tableId} AND process_id < #{time}"})
    public void deleteTaskRuntimesBefore(@Param(value="tableId") long var1, @Param(value="time") long var3);

    @Update(value={"UPDATE table_optimizing_process SET rewrite_input = #{input, jdbcType=BLOB, typeHandler=org.apache.amoro.server.persistence.converter.Object2ByteArrayConvert} WHERE process_id = #{processId}"})
    public void updateProcessInputFiles(@Param(value="processId") long var1, @Param(value="input") Map<Integer, RewriteFilesInput> var3);

    @Select(value={"SELECT rewrite_input FROM table_optimizing_process WHERE process_id = #{processId}"})
    @Results(value={@Result(column="rewrite_input", jdbcType=JdbcType.BLOB)})
    public List<byte[]> selectProcessInputFiles(@Param(value="processId") long var1);

    @Select(value={"SELECT process_id, task_id, retry_num, table_id, start_time, end_time, fail_reason FROM optimizing_task_quota WHERE table_id = #{tableId} AND process_id >= #{startTime}"})
    @Results(value={@Result(property="processId", column="process_id"), @Result(property="taskId", column="task_id"), @Result(property="retryNum", column="retry_num"), @Result(property="tableId", column="table_id"), @Result(property="startTime", column="start_time", typeHandler=Long2TsConverter.class), @Result(property="endTime", column="end_time", typeHandler=Long2TsConverter.class), @Result(property="failReason", column="fail_reason")})
    public List<TaskRuntime.TaskQuota> selectTaskQuotasByTime(@Param(value="tableId") long var1, @Param(value="startTime") long var3);

    @Insert(value={"INSERT INTO optimizing_task_quota (process_id, task_id, retry_num, table_id, start_time, end_time, fail_reason) VALUES (#{taskQuota.processId}, #{taskQuota.taskId}, #{taskQuota.retryNum}, #{taskQuota.tableId}, #{taskQuota.startTime, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter},  #{taskQuota.endTime, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}, #{taskQuota.failReason, jdbcType=VARCHAR})"})
    public void insertTaskQuota(@Param(value="taskQuota") TaskRuntime.TaskQuota var1);

    @Delete(value={"DELETE FROM optimizing_task_quota WHERE table_id = #{table_id} AND process_id < #{time}"})
    public void deleteOptimizingQuotaBefore(@Param(value="table_id") long var1, @Param(value="time") long var3);
}

