/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence.mapper;

import java.util.List;
import org.apache.amoro.api.resource.Resource;
import org.apache.amoro.api.resource.ResourceGroup;
import org.apache.amoro.server.persistence.converter.Long2TsConverter;
import org.apache.amoro.server.persistence.converter.Map2StringConverter;
import org.apache.amoro.server.resource.OptimizerInstance;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface ResourceMapper {
    @Select(value={"SELECT group_name, properties, container_name FROM resource_group"})
    @Results(value={@Result(property="name", column="group_name"), @Result(property="properties", column="properties", typeHandler=Map2StringConverter.class), @Result(property="container", column="container_name")})
    public List<ResourceGroup> selectResourceGroups();

    @Select(value={"SELECT group_name, properties, container_name FROM resource_group WHERE group_name = #{resourceGroup}"})
    @Results(value={@Result(property="name", column="group_name"), @Result(property="properties", column="properties", typeHandler=Map2StringConverter.class), @Result(property="container", column="container_name")})
    public ResourceGroup selectResourceGroup(@Param(value="resourceGroup") String var1);

    @Select(value={"SELECT resource_id, group_name, container_name, start_time, thread_count, total_memory, properties FROM resource WHERE group_name = #{resourceGroup}"})
    @Results(value={@Result(property="resourceId", column="resource_id"), @Result(property="group", column="group_name"), @Result(property="container", column="container_name"), @Result(property="startTime", column="start_time", typeHandler=Long2TsConverter.class), @Result(property="threadCount", column="thread_count"), @Result(property="totalMemory", column="total_memory"), @Result(property="properties", column="properties", typeHandler=Map2StringConverter.class)})
    public List<Resource> selectResourcesByGroup(@Param(value="resourceGroup") String var1);

    @Update(value={"UPDATE resource_group SET container_name = #{resourceGroup.container}, properties = #{resourceGroup.properties, typeHandler=org.apache.amoro.server.persistence.converter.JsonObjectConverter} WHERE group_name = #{resourceGroup.name}"})
    public void updateResourceGroup(@Param(value="resourceGroup") ResourceGroup var1);

    @Insert(value={"INSERT INTO resource_group (group_name, container_name, properties) VALUES (#{resourceGroup.name}, #{resourceGroup.container}, #{resourceGroup.properties, typeHandler=org.apache.amoro.server.persistence.converter.JsonObjectConverter})"})
    public void insertResourceGroup(@Param(value="resourceGroup") ResourceGroup var1);

    @Delete(value={"DELETE FROM resource_group WHERE group_name = #{name}"})
    public void deleteResourceGroup(@Param(value="name") String var1);

    @Insert(value={"INSERT INTO resource (resource_id, group_name, container_name, thread_count, total_memory, properties) VALUES (#{resource.resourceId}, #{resource.groupName}, #{resource.containerName}, #{resource.threadCount}, #{resource.memoryMb}, #{resource.properties, typeHandler=org.apache.amoro.server.persistence.converter.JsonObjectConverter})"})
    public void insertResource(@Param(value="resource") Resource var1);

    @Delete(value={"DELETE FROM resource WHERE resource_id = #{resourceId}"})
    public void deleteResource(@Param(value="resourceId") String var1);

    @Select(value={"SELECT * FROM resource WHERE resource_id = #{resourceId}"})
    @Results(value={@Result(property="resourceId", column="resource_id"), @Result(property="containerName", column="container_name"), @Result(property="groupName", column="group_name"), @Result(property="startTime", column="start_time", typeHandler=Long2TsConverter.class), @Result(property="threadCount", column="thread_count"), @Result(property="memoryMb", column="total_memory"), @Result(property="properties", column="properties", typeHandler=Map2StringConverter.class)})
    public OptimizerInstance selectResource(@Param(value="resourceId") String var1);
}

