/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.api.StateField;
import org.apache.amoro.api.config.OptimizingConfig;
import org.apache.amoro.api.config.TableConfiguration;
import org.apache.amoro.server.exception.BlockerConflictException;
import org.apache.amoro.server.exception.ObjectNotExistsException;
import org.apache.amoro.server.metrics.MetricRegistry;
import org.apache.amoro.server.optimizing.OptimizingProcess;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.optimizing.OptimizingType;
import org.apache.amoro.server.optimizing.TaskRuntime;
import org.apache.amoro.server.optimizing.plan.OptimizingEvaluator;
import org.apache.amoro.server.persistence.StatedPersistentBase;
import org.apache.amoro.server.persistence.mapper.OptimizingMapper;
import org.apache.amoro.server.persistence.mapper.TableBlockerMapper;
import org.apache.amoro.server.persistence.mapper.TableMetaMapper;
import org.apache.amoro.server.table.TableOptimizingMetrics;
import org.apache.amoro.server.table.TableRuntimeHandler;
import org.apache.amoro.server.table.TableRuntimeMeta;
import org.apache.amoro.server.table.blocker.TableBlocker;
import org.apache.amoro.server.utils.IcebergTableUtil;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRuntime
extends StatedPersistentBase {
    private static final Logger LOG = LoggerFactory.getLogger(TableRuntime.class);
    private final TableRuntimeHandler tableHandler;
    private final ServerTableIdentifier tableIdentifier;
    private final List<TaskRuntime.TaskQuota> taskQuotas = Collections.synchronizedList(new ArrayList());
    @StateField
    private volatile long currentSnapshotId = -1L;
    @StateField
    private volatile long lastOptimizedSnapshotId = -1L;
    @StateField
    private volatile long lastOptimizedChangeSnapshotId = -1L;
    @StateField
    private volatile long currentChangeSnapshotId = -1L;
    @StateField
    private volatile OptimizingStatus optimizingStatus = OptimizingStatus.IDLE;
    @StateField
    private volatile long currentStatusStartTime = System.currentTimeMillis();
    @StateField
    private volatile long lastMajorOptimizingTime;
    @StateField
    private volatile long lastFullOptimizingTime;
    @StateField
    private volatile long lastMinorOptimizingTime;
    @StateField
    private volatile String optimizerGroup;
    @StateField
    private volatile OptimizingProcess optimizingProcess;
    @StateField
    private volatile TableConfiguration tableConfiguration;
    @StateField
    private volatile long processId;
    @StateField
    private volatile OptimizingEvaluator.PendingInput pendingInput;
    private volatile long lastPlanTime;
    private final TableOptimizingMetrics optimizingMetrics;
    private final ReentrantLock blockerLock = new ReentrantLock();

    protected TableRuntime(ServerTableIdentifier tableIdentifier, TableRuntimeHandler tableHandler, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)tableIdentifier, (Object)"ServerTableIdentifier must not be null.");
        Preconditions.checkNotNull((Object)tableHandler, (Object)"TableRuntimeHandler must not be null.");
        this.tableHandler = tableHandler;
        this.tableIdentifier = tableIdentifier;
        this.tableConfiguration = TableConfiguration.parseConfig(properties);
        this.optimizerGroup = this.tableConfiguration.getOptimizingConfig().getOptimizerGroup();
        this.persistTableRuntime();
        this.optimizingMetrics = new TableOptimizingMetrics(tableIdentifier);
    }

    protected TableRuntime(TableRuntimeMeta tableRuntimeMeta, TableRuntimeHandler tableHandler) {
        Preconditions.checkNotNull((Object)tableRuntimeMeta, (Object)"TableRuntimeMeta must not be null.");
        Preconditions.checkNotNull((Object)tableHandler, (Object)"TableRuntimeHandler must not be null.");
        this.tableHandler = tableHandler;
        this.tableIdentifier = ServerTableIdentifier.of((Long)tableRuntimeMeta.getTableId(), (String)tableRuntimeMeta.getCatalogName(), (String)tableRuntimeMeta.getDbName(), (String)tableRuntimeMeta.getTableName(), (TableFormat)tableRuntimeMeta.getFormat());
        this.currentSnapshotId = tableRuntimeMeta.getCurrentSnapshotId();
        this.lastOptimizedSnapshotId = tableRuntimeMeta.getLastOptimizedSnapshotId();
        this.lastOptimizedChangeSnapshotId = tableRuntimeMeta.getLastOptimizedChangeSnapshotId();
        this.currentChangeSnapshotId = tableRuntimeMeta.getCurrentChangeSnapshotId();
        this.currentStatusStartTime = tableRuntimeMeta.getCurrentStatusStartTime();
        this.lastMinorOptimizingTime = tableRuntimeMeta.getLastMinorOptimizingTime();
        this.lastMajorOptimizingTime = tableRuntimeMeta.getLastMajorOptimizingTime();
        this.lastFullOptimizingTime = tableRuntimeMeta.getLastFullOptimizingTime();
        this.optimizerGroup = tableRuntimeMeta.getOptimizerGroup();
        this.tableConfiguration = tableRuntimeMeta.getTableConfig();
        this.processId = tableRuntimeMeta.getOptimizingProcessId();
        this.optimizingStatus = tableRuntimeMeta.getTableStatus() == OptimizingStatus.PLANNING ? OptimizingStatus.PENDING : tableRuntimeMeta.getTableStatus();
        this.pendingInput = tableRuntimeMeta.getPendingInput();
        this.optimizingMetrics = new TableOptimizingMetrics(this.tableIdentifier);
        this.optimizingMetrics.statusChanged(this.optimizingStatus, this.currentStatusStartTime);
    }

    public void recover(OptimizingProcess optimizingProcess) {
        if (!this.optimizingStatus.isProcessing() || !Objects.equals(optimizingProcess.getProcessId(), this.processId)) {
            throw new IllegalStateException("Table runtime and processing are not matched!");
        }
        this.optimizingProcess = optimizingProcess;
    }

    public void registerMetric(MetricRegistry metricRegistry) {
        this.optimizingMetrics.register(metricRegistry);
    }

    public void dispose() {
        this.invokeInStateLock(() -> this.doAsTransaction(() -> Optional.ofNullable(this.optimizingProcess).ifPresent(OptimizingProcess::close), () -> this.doAs(TableMetaMapper.class, mapper -> mapper.deleteOptimizingRuntime(this.tableIdentifier.getId()))));
        this.optimizingMetrics.unregister();
    }

    public void beginPlanning() {
        this.invokeConsistency(() -> {
            OptimizingStatus originalStatus = this.optimizingStatus;
            this.updateOptimizingStatus(OptimizingStatus.PLANNING);
            this.persistUpdatingRuntime();
            this.tableHandler.handleTableChanged(this, originalStatus);
        });
    }

    public void planFailed() {
        this.invokeConsistency(() -> {
            OptimizingStatus originalStatus = this.optimizingStatus;
            this.updateOptimizingStatus(OptimizingStatus.PENDING);
            this.persistUpdatingRuntime();
            this.tableHandler.handleTableChanged(this, originalStatus);
        });
    }

    public void beginProcess(OptimizingProcess optimizingProcess) {
        this.invokeConsistency(() -> {
            OptimizingStatus originalStatus = this.optimizingStatus;
            this.optimizingProcess = optimizingProcess;
            this.processId = optimizingProcess.getProcessId();
            this.updateOptimizingStatus(optimizingProcess.getOptimizingType().getStatus());
            this.pendingInput = null;
            this.persistUpdatingRuntime();
            this.tableHandler.handleTableChanged(this, originalStatus);
        });
    }

    public void beginCommitting() {
        this.invokeConsistency(() -> {
            OptimizingStatus originalStatus = this.optimizingStatus;
            this.updateOptimizingStatus(OptimizingStatus.COMMITTING);
            this.persistUpdatingRuntime();
            this.tableHandler.handleTableChanged(this, originalStatus);
        });
    }

    public void setPendingInput(OptimizingEvaluator.PendingInput pendingInput) {
        this.invokeConsistency(() -> {
            this.pendingInput = pendingInput;
            if (this.optimizingStatus == OptimizingStatus.IDLE) {
                this.updateOptimizingStatus(OptimizingStatus.PENDING);
                this.persistUpdatingRuntime();
                LOG.info("{} status changed from idle to pending with pendingInput {}", (Object)this.tableIdentifier, (Object)pendingInput);
                this.tableHandler.handleTableChanged(this, OptimizingStatus.IDLE);
            }
        });
    }

    public TableRuntime refresh(AmoroTable<?> table) {
        return this.invokeConsistency(() -> {
            TableConfiguration configuration = this.tableConfiguration;
            boolean configChanged = this.updateConfigInternal(table.properties());
            if (this.refreshSnapshots(table) || configChanged) {
                this.persistUpdatingRuntime();
            }
            if (configChanged) {
                this.tableHandler.handleTableChanged(this, configuration);
            }
            return this;
        });
    }

    public void completeEmptyProcess() {
        this.invokeConsistency(() -> {
            this.pendingInput = null;
            if (this.optimizingStatus == OptimizingStatus.PLANNING || this.optimizingStatus == OptimizingStatus.PENDING) {
                this.updateOptimizingStatus(OptimizingStatus.IDLE);
                this.lastOptimizedSnapshotId = this.currentSnapshotId;
                this.persistUpdatingRuntime();
                this.tableHandler.handleTableChanged(this, this.optimizingStatus);
            }
        });
    }

    public void resetTaskQuotas(long startTimeMills) {
        this.invokeInStateLock(() -> {
            this.taskQuotas.clear();
            this.taskQuotas.addAll(this.getAs(OptimizingMapper.class, mapper -> mapper.selectTaskQuotasByTime(this.tableIdentifier.getId(), startTimeMills)));
        });
    }

    public void completeProcess(boolean success) {
        this.invokeConsistency(() -> {
            OptimizingStatus originalStatus = this.optimizingStatus;
            OptimizingType processType = this.optimizingProcess.getOptimizingType();
            if (success) {
                this.lastOptimizedSnapshotId = this.optimizingProcess.getTargetSnapshotId();
                this.lastOptimizedChangeSnapshotId = this.optimizingProcess.getTargetChangeSnapshotId();
                if (processType == OptimizingType.MINOR) {
                    this.lastMinorOptimizingTime = this.optimizingProcess.getPlanTime();
                } else if (processType == OptimizingType.MAJOR) {
                    this.lastMajorOptimizingTime = this.optimizingProcess.getPlanTime();
                } else if (processType == OptimizingType.FULL) {
                    this.lastFullOptimizingTime = this.optimizingProcess.getPlanTime();
                }
            }
            this.updateOptimizingStatus(OptimizingStatus.IDLE);
            this.optimizingProcess = null;
            this.persistUpdatingRuntime();
            this.optimizingMetrics.processComplete(processType, success);
            this.tableHandler.handleTableChanged(this, originalStatus);
        });
    }

    private void updateOptimizingStatus(OptimizingStatus status) {
        this.optimizingStatus = status;
        this.currentStatusStartTime = System.currentTimeMillis();
        this.optimizingMetrics.statusChanged(status, this.currentStatusStartTime);
    }

    private boolean refreshSnapshots(AmoroTable<?> amoroTable) {
        MixedTable table = (MixedTable)amoroTable.originalTable();
        if (table.isKeyedTable()) {
            long lastSnapshotId = this.currentSnapshotId;
            long changeSnapshotId = this.currentChangeSnapshotId;
            this.currentSnapshotId = IcebergTableUtil.getSnapshotId((Table)table.asKeyedTable().baseTable(), false);
            this.currentChangeSnapshotId = IcebergTableUtil.getSnapshotId((Table)table.asKeyedTable().changeTable(), false);
            if (this.currentSnapshotId != lastSnapshotId || this.currentChangeSnapshotId != changeSnapshotId) {
                LOG.info("Refreshing table {} with base snapshot id {} and change snapshot id {}", new Object[]{this.tableIdentifier, this.currentSnapshotId, this.currentChangeSnapshotId});
                return true;
            }
        } else {
            long lastSnapshotId = this.currentSnapshotId;
            Snapshot currentSnapshot = table.asUnkeyedTable().currentSnapshot();
            long l = this.currentSnapshotId = currentSnapshot == null ? -1L : currentSnapshot.snapshotId();
            if (this.currentSnapshotId != lastSnapshotId) {
                LOG.info("Refreshing table {} with base snapshot id {}", (Object)this.tableIdentifier, (Object)this.currentSnapshotId);
                return true;
            }
        }
        return false;
    }

    public OptimizingEvaluator.PendingInput getPendingInput() {
        return this.pendingInput;
    }

    private boolean updateConfigInternal(Map<String, String> properties) {
        TableConfiguration newTableConfig = TableConfiguration.parseConfig(properties);
        if (this.tableConfiguration.equals((Object)newTableConfig)) {
            return false;
        }
        if (!Objects.equals(this.optimizerGroup, newTableConfig.getOptimizingConfig().getOptimizerGroup())) {
            if (this.optimizingProcess != null) {
                this.optimizingProcess.close();
            }
            this.optimizerGroup = newTableConfig.getOptimizingConfig().getOptimizerGroup();
        }
        this.tableConfiguration = newTableConfig;
        return true;
    }

    public void addTaskQuota(TaskRuntime.TaskQuota taskQuota) {
        this.doAs(OptimizingMapper.class, mapper -> mapper.insertTaskQuota(taskQuota));
        this.taskQuotas.add(taskQuota);
        long validTime = System.currentTimeMillis() - 3600000L;
        this.taskQuotas.removeIf(task -> task.checkExpired(validTime));
    }

    private void persistTableRuntime() {
        this.doAs(TableMetaMapper.class, mapper -> mapper.insertTableRuntime(this));
    }

    private void persistUpdatingRuntime() {
        this.doAs(TableMetaMapper.class, mapper -> mapper.updateTableRuntime(this));
    }

    public OptimizingProcess getOptimizingProcess() {
        return this.optimizingProcess;
    }

    public long getCurrentSnapshotId() {
        return this.currentSnapshotId;
    }

    public void updateCurrentChangeSnapshotId(long snapshotId) {
        this.currentChangeSnapshotId = snapshotId;
    }

    public ServerTableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public TableFormat getFormat() {
        return this.tableIdentifier.getFormat();
    }

    public OptimizingStatus getOptimizingStatus() {
        return this.optimizingStatus;
    }

    public long getLastOptimizedSnapshotId() {
        return this.lastOptimizedSnapshotId;
    }

    public long getLastOptimizedChangeSnapshotId() {
        return this.lastOptimizedChangeSnapshotId;
    }

    public long getCurrentChangeSnapshotId() {
        return this.currentChangeSnapshotId;
    }

    public long getCurrentStatusStartTime() {
        return this.currentStatusStartTime;
    }

    public long getLastMajorOptimizingTime() {
        return this.lastMajorOptimizingTime;
    }

    public long getLastFullOptimizingTime() {
        return this.lastFullOptimizingTime;
    }

    public long getLastMinorOptimizingTime() {
        return this.lastMinorOptimizingTime;
    }

    public TableConfiguration getTableConfiguration() {
        return this.tableConfiguration;
    }

    public OptimizingConfig getOptimizingConfig() {
        return this.tableConfiguration.getOptimizingConfig();
    }

    public boolean isOptimizingEnabled() {
        return this.tableConfiguration.getOptimizingConfig().isEnabled();
    }

    public Double getTargetQuota() {
        return this.tableConfiguration.getOptimizingConfig().getTargetQuota();
    }

    public String getOptimizerGroup() {
        return this.optimizerGroup;
    }

    public void setCurrentChangeSnapshotId(long currentChangeSnapshotId) {
        this.currentChangeSnapshotId = currentChangeSnapshotId;
    }

    public int getMaxExecuteRetryCount() {
        return this.tableConfiguration.getOptimizingConfig().getMaxExecuteRetryCount();
    }

    public long getNewestProcessId() {
        return this.processId;
    }

    public long getLastPlanTime() {
        return this.lastPlanTime;
    }

    public void setLastPlanTime(long lastPlanTime) {
        this.lastPlanTime = lastPlanTime;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableIdentifier", (Object)this.tableIdentifier).add("currentSnapshotId", this.currentSnapshotId).add("lastOptimizedSnapshotId", this.lastOptimizedSnapshotId).add("lastOptimizedChangeSnapshotId", this.lastOptimizedChangeSnapshotId).add("optimizingStatus", (Object)this.optimizingStatus).add("currentStatusStartTime", this.currentStatusStartTime).add("lastMajorOptimizingTime", this.lastMajorOptimizingTime).add("lastFullOptimizingTime", this.lastFullOptimizingTime).add("lastMinorOptimizingTime", this.lastMinorOptimizingTime).add("tableConfiguration", (Object)this.tableConfiguration).toString();
    }

    public long getQuotaTime() {
        long calculatingEndTime = System.currentTimeMillis();
        long calculatingStartTime = calculatingEndTime - 3600000L;
        this.taskQuotas.removeIf(task -> task.checkExpired(calculatingStartTime));
        long finishedTaskQuotaTime = this.taskQuotas.stream().mapToLong(taskQuota -> taskQuota.getQuotaTime(calculatingStartTime)).sum();
        return this.optimizingProcess == null ? finishedTaskQuotaTime : finishedTaskQuotaTime + this.optimizingProcess.getRunningQuotaTime(calculatingStartTime, calculatingEndTime);
    }

    public double calculateQuotaOccupy() {
        return new BigDecimal((double)this.getQuotaTime() / 3600000.0 / this.tableConfiguration.getOptimizingConfig().getTargetQuota()).setScale(4, RoundingMode.HALF_UP).doubleValue();
    }

    public List<TableBlocker> getBlockers() {
        this.blockerLock.lock();
        try {
            List list = this.getAs(TableBlockerMapper.class, mapper -> mapper.selectBlockers(this.tableIdentifier, System.currentTimeMillis()));
            return list;
        }
        finally {
            this.blockerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableBlocker block(List<BlockableOperation> operations, @Nonnull Map<String, String> properties, long blockerTimeout) {
        Preconditions.checkNotNull(operations, (Object)"operations should not be null");
        Preconditions.checkArgument((!operations.isEmpty() ? 1 : 0) != 0, (Object)"operations should not be empty");
        Preconditions.checkArgument((blockerTimeout > 0L ? 1 : 0) != 0, (Object)"blocker timeout must > 0");
        this.blockerLock.lock();
        try {
            long now = System.currentTimeMillis();
            List tableBlockers = this.getAs(TableBlockerMapper.class, mapper -> mapper.selectBlockers(this.tableIdentifier, now));
            if (this.conflict(operations, (List<TableBlocker>)tableBlockers)) {
                throw new BlockerConflictException(operations + " is conflict with " + tableBlockers);
            }
            TableBlocker tableBlocker = this.buildTableBlocker(this.tableIdentifier, operations, properties, now, blockerTimeout);
            this.doAs(TableBlockerMapper.class, mapper -> mapper.insertBlocker(tableBlocker));
            TableBlocker tableBlocker2 = tableBlocker;
            return tableBlocker2;
        }
        finally {
            this.blockerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renew(String blockerId, long blockerTimeout) {
        this.blockerLock.lock();
        try {
            long now = System.currentTimeMillis();
            TableBlocker tableBlocker = this.getAs(TableBlockerMapper.class, mapper -> mapper.selectBlocker(Long.parseLong(blockerId), now));
            if (tableBlocker == null) {
                throw new ObjectNotExistsException("Blocker " + blockerId + " of " + this.tableIdentifier);
            }
            long expirationTime = now + blockerTimeout;
            this.doAs(TableBlockerMapper.class, mapper -> mapper.updateBlockerExpirationTime(Long.parseLong(blockerId), expirationTime));
            long l = expirationTime;
            return l;
        }
        finally {
            this.blockerLock.unlock();
        }
    }

    public void release(String blockerId) {
        this.blockerLock.lock();
        try {
            this.doAs(TableBlockerMapper.class, mapper -> mapper.deleteBlocker(Long.parseLong(blockerId)));
        }
        finally {
            this.blockerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlocked(BlockableOperation operation) {
        this.blockerLock.lock();
        try {
            List tableBlockers = this.getAs(TableBlockerMapper.class, mapper -> mapper.selectBlockers(this.tableIdentifier, System.currentTimeMillis()));
            boolean bl = this.conflict(operation, (List<TableBlocker>)tableBlockers);
            return bl;
        }
        finally {
            this.blockerLock.unlock();
        }
    }

    private boolean conflict(List<BlockableOperation> blockableOperations, List<TableBlocker> blockers) {
        return blockableOperations.stream().anyMatch(operation -> this.conflict((BlockableOperation)operation, blockers));
    }

    private boolean conflict(BlockableOperation blockableOperation, List<TableBlocker> blockers) {
        return blockers.stream().anyMatch(blocker -> blocker.getOperations().contains(blockableOperation.name()));
    }

    private TableBlocker buildTableBlocker(ServerTableIdentifier tableIdentifier, List<BlockableOperation> operations, Map<String, String> properties, long now, long blockerTimeout) {
        TableBlocker tableBlocker = new TableBlocker();
        tableBlocker.setTableIdentifier(tableIdentifier);
        tableBlocker.setCreateTime(now);
        tableBlocker.setExpirationTime(now + blockerTimeout);
        tableBlocker.setOperations(operations.stream().map(Enum::name).collect(Collectors.toList()));
        HashMap<String, String> propertiesOfTableBlocker = new HashMap<String, String>(properties);
        propertiesOfTableBlocker.put("blocker.timeout", blockerTimeout + "");
        tableBlocker.setProperties(propertiesOfTableBlocker);
        return tableBlocker;
    }
}

