/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.metrics.promethues;

import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.amoro.api.metrics.Counter;
import org.apache.amoro.api.metrics.Gauge;
import org.apache.amoro.api.metrics.Metric;
import org.apache.amoro.api.metrics.MetricDefine;
import org.apache.amoro.api.metrics.MetricKey;
import org.apache.amoro.api.metrics.MetricSet;
import org.apache.amoro.api.metrics.MetricType;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollector
extends Collector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsCollector.class);
    private static final String PREFIX = "amoro_";
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z_:][a-zA-Z0-9_:]*");
    private static final Pattern LABEL_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    MetricSet metrics;

    public MetricsCollector(MetricSet metrics) {
        this.metrics = metrics;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        Map registeredMetrics = this.metrics.getMetrics();
        Map metricDefineMap = registeredMetrics.keySet().stream().collect(Collectors.groupingBy(MetricKey::getDefine, Collectors.mapping(Function.identity(), Collectors.toList())));
        return metricDefineMap.entrySet().stream().filter(entry -> this.isValidMetric((MetricDefine)entry.getKey())).map(entry -> this.createFamilySample((MetricDefine)entry.getKey(), (List)entry.getValue(), registeredMetrics)).collect(Collectors.toList());
    }

    private boolean isValidMetric(MetricDefine define) {
        boolean valid;
        boolean nameIsValid = NAME_PATTERN.matcher(define.getName()).matches();
        boolean labelIsValid = true;
        for (String tag : define.getTags()) {
            if (LABEL_PATTERN.matcher(tag).matches()) continue;
            labelIsValid = false;
            break;
        }
        boolean bl = valid = nameIsValid && labelIsValid;
        if (!valid) {
            LOGGER.warn("Metric {} is not a valid prometheus metric.", (Object)define);
        }
        return valid;
    }

    private Collector.MetricFamilySamples createFamilySample(MetricDefine define, List<MetricKey> keys, Map<MetricKey, Metric> registeredMetrics) {
        ArrayList samples = Lists.newArrayList();
        for (MetricKey key : keys) {
            Metric metric = registeredMetrics.get(key);
            Collector.MetricFamilySamples.Sample sample = new Collector.MetricFamilySamples.Sample(PREFIX + define.getName(), define.getTags(), key.valueOfTags(), this.covertValue(metric));
            samples.add(sample);
        }
        return new Collector.MetricFamilySamples(PREFIX + define.getName(), this.covertType(define.getType()), define.getDescription(), samples);
    }

    private Collector.Type covertType(MetricType metricType) {
        switch (metricType) {
            case Counter: {
                return Collector.Type.COUNTER;
            }
            case Gauge: {
                return Collector.Type.GAUGE;
            }
        }
        throw new IllegalStateException("unknown type:" + metricType);
    }

    private double covertValue(Metric metric) {
        if (metric instanceof Counter) {
            return ((Counter)metric).getCount();
        }
        if (metric instanceof Gauge) {
            return ((Gauge)metric).getValue().doubleValue();
        }
        throw new IllegalStateException("unknown metric implement class:" + metric.getClass().getName());
    }
}

