/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.SerializationUtils;

public class IndexFileMeta {
    private final String indexType;
    private final String fileName;
    private final long fileSize;
    private final long rowCount;
    @Nullable
    private final LinkedHashMap<String, Pair<Integer, Integer>> deletionVectorsRanges;

    public IndexFileMeta(String indexType, String fileName, long fileSize, long rowCount) {
        this(indexType, fileName, fileSize, rowCount, null);
    }

    public IndexFileMeta(String indexType, String fileName, long fileSize, long rowCount, @Nullable LinkedHashMap<String, Pair<Integer, Integer>> deletionVectorsRanges) {
        this.indexType = indexType;
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.rowCount = rowCount;
        this.deletionVectorsRanges = deletionVectorsRanges;
    }

    public String indexType() {
        return this.indexType;
    }

    public String fileName() {
        return this.fileName;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public long rowCount() {
        return this.rowCount;
    }

    @Nullable
    public LinkedHashMap<String, Pair<Integer, Integer>> deletionVectorsRanges() {
        return this.deletionVectorsRanges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexFileMeta that = (IndexFileMeta)o;
        return Objects.equals(this.indexType, that.indexType) && Objects.equals(this.fileName, that.fileName) && this.fileSize == that.fileSize && this.rowCount == that.rowCount && Objects.equals(this.deletionVectorsRanges, that.deletionVectorsRanges);
    }

    public int hashCode() {
        return Objects.hash(this.indexType, this.fileName, this.fileSize, this.rowCount, this.deletionVectorsRanges);
    }

    public String toString() {
        return "IndexManifestEntry{indexType=" + this.indexType + ", fileName='" + this.fileName + '\'' + ", fileSize=" + this.fileSize + ", rowCount=" + this.rowCount + ", deletionVectorsRanges=" + this.deletionVectorsRanges + '}';
    }

    public static RowType schema() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "_INDEX_TYPE", SerializationUtils.newStringType(false)));
        fields.add(new DataField(1, "_FILE_NAME", SerializationUtils.newStringType(false)));
        fields.add(new DataField(2, "_FILE_SIZE", new BigIntType(false)));
        fields.add(new DataField(3, "_ROW_COUNT", new BigIntType(false)));
        fields.add(new DataField(4, "_DELETION_VECTORS_RANGES", new ArrayType(true, RowType.of(SerializationUtils.newStringType(false), new IntType(false), new IntType(false)))));
        return new RowType(fields);
    }
}

