/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sort;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import org.apache.paimon.utils.ConvertBinaryUtil;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TimestampType;
import org.davidmoten.hilbert.HilbertCurve;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SparkHilbertUDF
implements Serializable {
    private static final long PRIMITIVE_EMPTY = Long.MAX_VALUE;
    private static final int BITS_NUM = 63;
    private final UserDefinedFunction hilbertCurveUDF = functions.udf((UDF1 & Serializable)points -> this.hilbertCurvePosBytes((Seq<Long>)points), (DataType)DataTypes.BinaryType).withName("HILBERT_LONG");

    SparkHilbertUDF() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    byte[] hilbertCurvePosBytes(Seq<Long> points) {
        List longs = JavaConverters.seqAsJavaList(points);
        long[] data = longs.stream().mapToLong(Long::longValue).toArray();
        HilbertCurve hilbertCurve = HilbertCurve.bits((int)63).dimensions(points.size());
        BigInteger index = hilbertCurve.index(data);
        return ConvertBinaryUtil.paddingToNByte(index.toByteArray(), 63);
    }

    private UserDefinedFunction tinyToOrderedLongUDF() {
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            if (value == null) {
                return Long.MAX_VALUE;
            }
            return ConvertBinaryUtil.convertBytesToLong(new byte[]{value});
        }, (DataType)DataTypes.LongType).withName("TINY_ORDERED_BYTES");
        return udf;
    }

    private UserDefinedFunction shortToOrderedLongUDF() {
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            if (value == null) {
                return Long.MAX_VALUE;
            }
            return (long)value.shortValue();
        }, (DataType)DataTypes.LongType).withName("SHORT_ORDERED_BYTES");
        return udf;
    }

    private UserDefinedFunction intToOrderedLongUDF() {
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            if (value == null) {
                return Long.MAX_VALUE;
            }
            return (long)value.intValue();
        }, (DataType)DataTypes.LongType).withName("INT_ORDERED_BYTES");
        return udf;
    }

    private UserDefinedFunction longToOrderedLongUDF() {
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            if (value == null) {
                return Long.MAX_VALUE;
            }
            return value;
        }, (DataType)DataTypes.LongType).withName("LONG_ORDERED_BYTES");
        return udf;
    }

    private UserDefinedFunction floatToOrderedLongUDF() {
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            if (value == null) {
                return Long.MAX_VALUE;
            }
            return Double.doubleToLongBits(value.floatValue());
        }, (DataType)DataTypes.LongType).withName("FLOAT_ORDERED_BYTES");
        return udf;
    }

    private UserDefinedFunction doubleToOrderedLongUDF() {
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            if (value == null) {
                return Long.MAX_VALUE;
            }
            return Double.doubleToLongBits(value);
        }, (DataType)DataTypes.LongType).withName("DOUBLE_ORDERED_BYTES");
        return udf;
    }

    private UserDefinedFunction booleanToOrderedLongUDF() {
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> value != false ? Long.MAX_VALUE : 0L, (DataType)DataTypes.LongType).withName("BOOLEAN-LEXICAL-BYTES");
        return udf;
    }

    private UserDefinedFunction stringToOrderedLongUDF() {
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> ConvertBinaryUtil.convertStringToLong(value), (DataType)DataTypes.LongType).withName("STRING-LEXICAL-BYTES");
        return udf;
    }

    private UserDefinedFunction bytesTruncateUDF() {
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> ConvertBinaryUtil.convertBytesToLong(value), (DataType)DataTypes.LongType).withName("BYTE-TRUNCATE");
        return udf;
    }

    private UserDefinedFunction decimalTypeToOrderedLongUDF() {
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> value.longValue(), (DataType)DataTypes.LongType).withName("BYTE-TRUNCATE");
        return udf;
    }

    public Column sortedLexicographically(Column column, DataType type) {
        if (type instanceof ByteType) {
            return this.tinyToOrderedLongUDF().apply(new Column[]{column});
        }
        if (type instanceof ShortType) {
            return this.shortToOrderedLongUDF().apply(new Column[]{column});
        }
        if (type instanceof IntegerType) {
            return this.intToOrderedLongUDF().apply(new Column[]{column});
        }
        if (type instanceof LongType) {
            return this.longToOrderedLongUDF().apply(new Column[]{column});
        }
        if (type instanceof FloatType) {
            return this.floatToOrderedLongUDF().apply(new Column[]{column});
        }
        if (type instanceof DoubleType) {
            return this.doubleToOrderedLongUDF().apply(new Column[]{column});
        }
        if (type instanceof StringType) {
            return this.stringToOrderedLongUDF().apply(new Column[]{column});
        }
        if (type instanceof BinaryType) {
            return this.bytesTruncateUDF().apply(new Column[]{column});
        }
        if (type instanceof BooleanType) {
            return this.booleanToOrderedLongUDF().apply(new Column[]{column});
        }
        if (type instanceof TimestampType) {
            return this.longToOrderedLongUDF().apply(new Column[]{column.cast(DataTypes.LongType)});
        }
        if (type instanceof DecimalType) {
            return this.decimalTypeToOrderedLongUDF().apply(new Column[]{column.cast(DataTypes.LongType)});
        }
        if (type instanceof DateType) {
            return this.longToOrderedLongUDF().apply(new Column[]{column.cast(DataTypes.LongType)});
        }
        throw new IllegalArgumentException(String.format("Cannot use column %s of type %s in Hilbert, the type is unsupported", column, type));
    }

    public Column transform(Column arrayBinary) {
        return this.hilbertCurveUDF.apply(new Column[]{arrayBinary});
    }
}

