/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sort;

import java.util.List;
import org.apache.paimon.spark.sort.HilbertSorter;
import org.apache.paimon.spark.sort.OrderSorter;
import org.apache.paimon.spark.sort.ZorderSorter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public abstract class TableSorter {
    protected final FileStoreTable table;
    protected final List<String> orderColNames;

    public TableSorter(FileStoreTable table, List<String> orderColNames) {
        this.table = table;
        this.orderColNames = orderColNames;
        this.checkColNames();
    }

    protected void checkNotEmpty() {
        if (this.orderColNames.isEmpty()) {
            throw new IllegalArgumentException("order column could not be empty");
        }
    }

    private void checkColNames() {
        if (!this.orderColNames.isEmpty()) {
            List<String> columnNames = this.table.rowType().getFieldNames();
            for (String zColumn : this.orderColNames) {
                if (columnNames.contains(zColumn)) continue;
                throw new RuntimeException("Can't find column " + zColumn + " in table columns. Possible columns are [" + (String)columnNames.stream().reduce((a, b) -> a + "," + b).get() + "]");
            }
        }
    }

    public abstract Dataset<Row> sort(Dataset<Row> var1);

    public static TableSorter getSorter(FileStoreTable table, OrderType orderType, List<String> orderColumns) {
        switch (orderType) {
            case ORDER: {
                return new OrderSorter(table, orderColumns);
            }
            case ZORDER: {
                return new ZorderSorter(table, orderColumns);
            }
            case HILBERT: {
                return new HilbertSorter(table, orderColumns);
            }
            case NONE: {
                return new TableSorter(table, (List)orderColumns){

                    @Override
                    public Dataset<Row> sort(Dataset<Row> input) {
                        return input;
                    }
                };
            }
        }
        throw new IllegalArgumentException("cannot match order type: " + (Object)((Object)orderType));
    }

    public static enum OrderType {
        ORDER("order"),
        ZORDER("zorder"),
        HILBERT("hilbert"),
        NONE("none");

        private final String orderType;

        private OrderType(String orderType) {
            this.orderType = orderType;
        }

        public String toString() {
            return "order type: " + this.orderType;
        }

        public static OrderType of(String orderType) {
            if (OrderType.ORDER.orderType.equalsIgnoreCase(orderType)) {
                return ORDER;
            }
            if (OrderType.ZORDER.orderType.equalsIgnoreCase(orderType)) {
                return ZORDER;
            }
            if (OrderType.HILBERT.orderType.equalsIgnoreCase(orderType)) {
                return HILBERT;
            }
            if (OrderType.NONE.orderType.equalsIgnoreCase(orderType)) {
                return NONE;
            }
            throw new IllegalArgumentException("cannot match type: " + orderType + " for ordering");
        }
    }
}

