/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.io.PageFileInput;
import org.apache.paimon.io.cache.CacheKey;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.BloomFilter;
import org.apache.paimon.utils.Preconditions;

public class FileBasedBloomFilter {
    private final PageFileInput input;
    private final CacheManager cacheManager;
    private final BloomFilter filter;
    private final long readOffset;
    private final int readLength;
    private int accessCount;

    public FileBasedBloomFilter(PageFileInput input, CacheManager cacheManager, long expectedEntries, long readOffset, int readLength) {
        this.input = input;
        this.cacheManager = cacheManager;
        Preconditions.checkArgument(expectedEntries >= 0L);
        this.filter = new BloomFilter(expectedEntries, readLength);
        this.readOffset = readOffset;
        this.readLength = readLength;
        this.accessCount = 0;
    }

    public boolean testHash(int hash) {
        ++this.accessCount;
        if (this.accessCount == 10 || this.filter.getMemorySegment() == null) {
            MemorySegment segment = this.cacheManager.getPage(CacheKey.forPosition(this.input.file(), this.readOffset, this.readLength), key -> this.input.readPosition(this.readOffset, this.readLength), key -> this.filter.unsetMemorySegment());
            this.filter.setMemorySegment(segment, 0);
            this.accessCount = 0;
        }
        return this.filter.testHash(hash);
    }

    @VisibleForTesting
    BloomFilter bloomFilter() {
        return this.filter;
    }
}

