/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ThreadUtils {
    public static String currentStackString() {
        StackTraceElement[] trace = Thread.getAllStackTraces().get(Thread.currentThread());
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement traceElement : trace) {
            builder.append("\nat ").append(traceElement);
        }
        return builder.toString();
    }

    public static void errorLogThreadDump(Logger logger) {
        ThreadInfo[] perThreadInfo = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        logger.error("Thread dump: \n{}", (Object)Arrays.stream(perThreadInfo).map(Object::toString).collect(Collectors.joining()));
    }

    public static boolean stackContains(String name) {
        StackTraceElement[] ss;
        for (StackTraceElement s : ss = new RuntimeException().getStackTrace()) {
            if (!s.toString().contains(name)) continue;
            return true;
        }
        return false;
    }
}

