/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionReader;
import org.apache.flink.util.ExceptionUtils;

public class NettyConnectionReaderImpl
implements NettyConnectionReader {
    private final Supplier<InputChannel> inputChannelProvider;
    private int lastRequiredSegmentId = 0;

    public NettyConnectionReaderImpl(Supplier<InputChannel> inputChannelProvider) {
        this.inputChannelProvider = inputChannelProvider;
    }

    @Override
    public Optional<Buffer> readBuffer(int segmentId) {
        if ((long)segmentId > 0L && segmentId != this.lastRequiredSegmentId) {
            this.lastRequiredSegmentId = segmentId;
            try {
                this.inputChannelProvider.get().notifyRequiredSegmentId(segmentId);
            }
            catch (IOException e) {
                ExceptionUtils.rethrow((Throwable)e, (String)"Failed to notify required segment id");
            }
        }
        Optional<Object> bufferAndAvailability = Optional.empty();
        try {
            bufferAndAvailability = this.inputChannelProvider.get().getNextBuffer();
        }
        catch (IOException | InterruptedException e) {
            ExceptionUtils.rethrow((Throwable)e, (String)"Failed to read buffer.");
        }
        return bufferAndAvailability.map(InputChannel.BufferAndAvailability::buffer);
    }
}

