/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.optimizing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.data.PrimaryKeyedFile;
import org.apache.amoro.hive.io.reader.AdaptHiveGenericKeyedDataReader;
import org.apache.amoro.optimizing.OptimizingDataReader;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.scan.BasicMixedFileScanTask;
import org.apache.amoro.scan.KeyedTableScanTask;
import org.apache.amoro.scan.NodeFileScanTask;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.IdentityPartitionConverters;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.types.Types;

public class MixFormatOptimizingDataReader
implements OptimizingDataReader {
    private final MixedTable table;
    private final StructLikeCollections structLikeCollections;
    private final RewriteFilesInput input;

    public MixFormatOptimizingDataReader(MixedTable table, StructLikeCollections structLikeCollections, RewriteFilesInput input) {
        this.table = table;
        this.structLikeCollections = structLikeCollections;
        this.input = input;
    }

    public CloseableIterable<Record> readData() {
        AdaptHiveGenericKeyedDataReader reader = this.mixedTableDataReader(this.table.schema());
        CloseableIterator closeableIterator = reader.readData((KeyedTableScanTask)this.nodeFileScanTask(this.input.rewrittenDataFilesForMixed()));
        return this.wrapIterator2Iterable((CloseableIterator<Record>)closeableIterator);
    }

    public CloseableIterable<Record> readDeletedData() {
        Schema schema = new Schema(new Types.NestedField[]{MetadataColumns.FILE_PATH, MetadataColumns.ROW_POSITION, org.apache.amoro.table.MetadataColumns.TREE_NODE_FIELD});
        AdaptHiveGenericKeyedDataReader reader = this.mixedTableDataReader(schema);
        return this.wrapIterator2Iterable((CloseableIterator<Record>)reader.readDeletedData((KeyedTableScanTask)this.nodeFileScanTask(this.input.rePosDeletedDataFilesForMixed())));
    }

    public void close() {
    }

    private AdaptHiveGenericKeyedDataReader mixedTableDataReader(Schema requiredSchema) {
        PrimaryKeySpec primaryKeySpec = PrimaryKeySpec.noPrimaryKey();
        if (this.table.isKeyedTable()) {
            KeyedTable keyedTable = this.table.asKeyedTable();
            primaryKeySpec = keyedTable.primaryKeySpec();
        }
        return new AdaptHiveGenericKeyedDataReader(this.table.io(), this.table.schema(), requiredSchema, primaryKeySpec, (String)this.table.properties().get("schema.name-mapping.default"), false, IdentityPartitionConverters::convertConstant, null, false, this.structLikeCollections);
    }

    private NodeFileScanTask nodeFileScanTask(List<PrimaryKeyedFile> dataFiles) {
        List posDeleteList = this.input.positionDeleteForMixed();
        List equlityDeleteList = this.input.equalityDeleteForMixed();
        ArrayList<PrimaryKeyedFile> allTaskFiles = new ArrayList<PrimaryKeyedFile>();
        allTaskFiles.addAll(equlityDeleteList);
        allTaskFiles.addAll(dataFiles);
        List fileScanTasks = allTaskFiles.stream().map(file -> new BasicMixedFileScanTask(file, posDeleteList, this.table.spec())).collect(Collectors.toList());
        return new NodeFileScanTask(fileScanTasks);
    }

    private CloseableIterable<Record> wrapIterator2Iterable(final CloseableIterator<Record> iterator) {
        return new CloseableIterable<Record>(){

            public CloseableIterator<Record> iterator() {
                return iterator;
            }

            public void close() throws IOException {
                iterator.close();
            }
        };
    }
}

