/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.table.SupportHive;
import org.apache.amoro.hive.utils.CompatibleHivePropertyUtil;
import org.apache.amoro.hive.utils.HivePartitionUtil;
import org.apache.amoro.hive.utils.HiveSchemaUtil;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.op.OverwriteBaseFiles;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.data.TableMigrationUtil;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeMap;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaSynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaSynchronizer.class);

    public static void syncHiveSchemaToMixedTable(MixedTable table, HMSClientPool hiveClient) {
        try {
            if (!HiveTableUtil.checkExist(hiveClient, table.id())) {
                LOG.warn("Hive table {} does not exist, try to skip sync schema to amoro", (Object)table.id());
                return;
            }
            Table hiveTable = (Table)hiveClient.run(client -> client.getTable(table.id().getDatabase(), table.id().getTableName()));
            Schema hiveSchema = HiveSchemaUtil.convertHiveSchemaToIcebergSchema(hiveTable, table.isKeyedTable() ? table.asKeyedTable().primaryKeySpec().fieldNames() : new ArrayList());
            UpdateSchema updateSchema = table.updateSchema();
            boolean update = HiveMetaSynchronizer.updateStructSchema(table.id(), updateSchema, null, table.schema().asStruct(), hiveSchema.asStruct());
            if (update) {
                updateSchema.commit();
            }
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to get hive table:" + table.id(), e);
        }
    }

    private static boolean updateStructSchema(TableIdentifier tableIdentifier, UpdateSchema updateSchema, String parentName, Types.StructType icebergStruct, Types.StructType hiveStruct) {
        boolean update = false;
        for (Types.NestedField hiveField : hiveStruct.fields()) {
            List fields = icebergStruct.fields().stream().filter(f -> f.name().toLowerCase().equals(hiveField.name())).collect(Collectors.toList());
            if (fields.isEmpty()) {
                updateSchema.addColumn(parentName, hiveField.name(), hiveField.type(), hiveField.doc());
                update = true;
                LOG.info("Table {} sync new hive column {} to thet mixed-hive table", (Object)tableIdentifier, (Object)hiveField);
                continue;
            }
            if (fields.size() == 1) {
                String columnName;
                Types.NestedField icebergField = (Types.NestedField)fields.get(0);
                if (icebergField.type().equals(hiveField.type()) && Objects.equals(icebergField.doc(), hiveField.doc())) continue;
                if (hiveField.type().isPrimitiveType() && icebergField.type().isPrimitiveType()) {
                    if (TypeUtil.isPromotionAllowed((Type)icebergField.type().asPrimitiveType(), (Type.PrimitiveType)hiveField.type().asPrimitiveType())) {
                        columnName = parentName == null ? hiveField.name() : parentName + "." + hiveField.name();
                        updateSchema.updateColumn(columnName, hiveField.type().asPrimitiveType(), hiveField.doc());
                        update = true;
                        LOG.info("Table {} sync hive column {} to the mixed-hive table", (Object)tableIdentifier, (Object)hiveField);
                        continue;
                    }
                    LOG.warn("Table {} sync hive column {} to the mixed-hive table failed, because of type mismatch", (Object)tableIdentifier, (Object)hiveField);
                    continue;
                }
                if (hiveField.type().isStructType() && icebergField.type().isStructType()) {
                    columnName = parentName == null ? hiveField.name() : parentName + "." + hiveField.name();
                    update = update || HiveMetaSynchronizer.updateStructSchema(tableIdentifier, updateSchema, columnName, icebergField.type().asStructType(), hiveField.type().asStructType());
                    continue;
                }
                LOG.warn("Table {} sync hive column {} to the mixed-hive table failed, because of type mismatch", (Object)tableIdentifier, (Object)hiveField);
                continue;
            }
            throw new RuntimeException("Exist columns with the same name: " + fields.get(0));
        }
        return update;
    }

    public static void syncHiveDataToMixedTable(SupportHive table, HMSClientPool hiveClient) {
        HiveMetaSynchronizer.syncHiveDataToMixedTable(table, hiveClient, false);
    }

    public static void syncHiveDataToMixedTable(SupportHive table, HMSClientPool hiveClient, boolean force) {
        block35: {
            if (!HiveTableUtil.checkExist(hiveClient, table.id())) {
                LOG.warn("Hive table {} does not exist, try to skip sync data to amoro", (Object)table.id());
                return;
            }
            Object baseStore = table.isKeyedTable() ? table.asKeyedTable().baseTable() : table.asUnkeyedTable();
            try {
                if (table.spec().isUnpartitioned()) {
                    Table hiveTable = (Table)hiveClient.run(client -> client.getTable(table.id().getDatabase(), table.id().getTableName()));
                    if (!force && !HiveMetaSynchronizer.tableHasModified(baseStore, hiveTable)) break block35;
                    List<DataFile> hiveDataFiles = HiveMetaSynchronizer.listHivePartitionFiles(table, Maps.newHashMap(), hiveTable.getSd().getLocation());
                    ArrayList deleteFiles = Lists.newArrayList();
                    try (CloseableIterable fileScanTasks = baseStore.newScan().planFiles();){
                        fileScanTasks.forEach(fileScanTask -> deleteFiles.add(fileScanTask.file()));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to close table scan of " + table.name(), e);
                    }
                    HiveMetaSynchronizer.overwriteTable(table, deleteFiles, hiveDataFiles);
                    break block35;
                }
                List hivePartitions = (List)hiveClient.run(client -> client.listPartitions(table.id().getDatabase(), table.id().getTableName(), (short)Short.MAX_VALUE));
                StructLikeMap filesGroupedByPartition = StructLikeMap.create((Types.StructType)table.spec().partitionType());
                TableScan tableScan = baseStore.newScan();
                try (CloseableIterable fileScanTasks = tableScan.planFiles();){
                    for (FileScanTask fileScanTask2 : fileScanTasks) {
                        ((Collection)filesGroupedByPartition.computeIfAbsent((Object)((DataFile)fileScanTask2.file()).partition(), k -> Lists.newArrayList())).add(fileScanTask2.file());
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to close table scan of " + table.name(), e);
                }
                ArrayList filesToDelete = Lists.newArrayList();
                ArrayList filesToAdd = Lists.newArrayList();
                ArrayList icebergPartitions = Lists.newArrayList((Iterable)filesGroupedByPartition.keySet());
                for (Partition hivePartition : hivePartitions) {
                    StructLike partitionData = HivePartitionUtil.buildPartitionData(hivePartition.getValues(), table.spec());
                    icebergPartitions.remove(partitionData);
                    if (!force && !HiveMetaSynchronizer.partitionHasModified(baseStore, hivePartition, partitionData)) continue;
                    List<DataFile> hiveDataFiles = HiveMetaSynchronizer.listHivePartitionFiles(table, HiveMetaSynchronizer.buildPartitionValueMap(hivePartition.getValues(), table.spec()), hivePartition.getSd().getLocation());
                    if (filesGroupedByPartition.get((Object)partitionData) != null) {
                        filesToDelete.addAll((Collection)filesGroupedByPartition.get((Object)partitionData));
                        filesToAdd.addAll(hiveDataFiles);
                        continue;
                    }
                    if (CompatibleHivePropertyUtil.propertyAsBoolean(hivePartition.getParameters(), "arctic.enabled", false)) continue;
                    filesToAdd.addAll(hiveDataFiles);
                }
                icebergPartitions.forEach(partition -> {
                    ArrayList dataFiles = Lists.newArrayList((Iterable)((Iterable)filesGroupedByPartition.get(partition)));
                    if (dataFiles.size() > 0 && !table.io().exists(((DataFile)dataFiles.get(0)).path().toString())) {
                        filesToDelete.addAll((Collection)filesGroupedByPartition.get(partition));
                    }
                });
                HiveMetaSynchronizer.overwriteTable(table, filesToDelete, filesToAdd);
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException("Failed to get hive table:" + table.id(), e);
            }
        }
    }

    public static void syncMixedTableDataToHive(SupportHive table) {
        Object baseStore = table.isKeyedTable() ? table.asKeyedTable().baseTable() : table.asUnkeyedTable();
        StructLikeMap partitionProperty = baseStore.partitionProperty();
        try {
            if (baseStore.spec().isUnpartitioned()) {
                HiveMetaSynchronizer.syncNoPartitionTable(table, (StructLikeMap<Map<String, String>>)partitionProperty);
            } else {
                HiveMetaSynchronizer.syncPartitionTable(table, (StructLikeMap<Map<String, String>>)partitionProperty);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to sync mixed-hive table data to hive:" + table.id(), e);
        }
    }

    private static void syncNoPartitionTable(SupportHive table, StructLikeMap<Map<String, String>> partitionProperty) {
        String hiveLocation;
        Map property = (Map)partitionProperty.get((Object)TablePropertyUtil.EMPTY_STRUCT);
        if (property == null || property.get("hive-location") == null) {
            LOG.debug("{} has no hive location in partition property", (Object)table.id());
            return;
        }
        String currentLocation = (String)property.get("hive-location");
        try {
            hiveLocation = (String)table.getHMSClient().run(client -> {
                Table hiveTable = client.getTable(table.id().getDatabase(), table.id().getTableName());
                return hiveTable.getSd().getLocation();
            });
        }
        catch (Exception e) {
            LOG.error("{} get hive location failed", (Object)table.id(), (Object)e);
            return;
        }
        if (!Objects.equals(currentLocation, hiveLocation)) {
            try {
                table.getHMSClient().run(client -> {
                    Table hiveTable = client.getTable(table.id().getDatabase(), table.id().getTableName());
                    hiveTable.getSd().setLocation(currentLocation);
                    client.alterTable(table.id().getDatabase(), table.id().getTableName(), hiveTable);
                    return null;
                });
            }
            catch (Exception e) {
                LOG.error("{} alter hive location failed", (Object)table.id(), (Object)e);
            }
        }
    }

    private static void syncPartitionTable(SupportHive table, StructLikeMap<Map<String, String>> partitionProperty) throws Exception {
        HashMap<String, StructLike> icebergPartitionMap = new HashMap<String, StructLike>();
        for (StructLike structLike : partitionProperty.keySet()) {
            icebergPartitionMap.put(table.spec().partitionToPath(structLike), structLike);
        }
        ArrayList icebergPartitions = new ArrayList(icebergPartitionMap.keySet());
        List hivePartitions = (List)table.getHMSClient().run(client -> client.listPartitions(table.id().getDatabase(), table.id().getTableName(), (short)Short.MAX_VALUE));
        List hivePartitionNames = (List)table.getHMSClient().run(client -> client.listPartitionNames(table.id().getDatabase(), table.id().getTableName(), (short)Short.MAX_VALUE));
        List partitionKeys = (List)table.getHMSClient().run(client -> {
            Table hiveTable = client.getTable(table.id().getDatabase(), table.id().getTableName());
            return hiveTable.getPartitionKeys();
        });
        HashMap<String, Partition> hivePartitionMap = new HashMap<String, Partition>();
        for (Partition hivePartition : hivePartitions) {
            hivePartitionMap.put(Warehouse.makePartName((List)partitionKeys, (List)hivePartition.getValues()), hivePartition);
        }
        Set<String> inIcebergNotInHive = icebergPartitions.stream().filter(partition -> !hivePartitionNames.contains(partition)).collect(Collectors.toSet());
        Set<String> inHiveNotInIceberg = hivePartitionNames.stream().filter(partition -> !icebergPartitions.contains(partition)).collect(Collectors.toSet());
        Set<String> inBoth = icebergPartitions.stream().filter(hivePartitionNames::contains).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(inIcebergNotInHive)) {
            HiveMetaSynchronizer.handleInIcebergPartitions(table, inIcebergNotInHive, icebergPartitionMap, partitionProperty);
        }
        if (CollectionUtils.isNotEmpty(inHiveNotInIceberg)) {
            HiveMetaSynchronizer.handleInHivePartitions(table, inHiveNotInIceberg, hivePartitionMap);
        }
        if (CollectionUtils.isNotEmpty(inBoth)) {
            HiveMetaSynchronizer.handleInBothPartitions(table, inBoth, hivePartitionMap, icebergPartitionMap, partitionProperty);
        }
    }

    private static void handleInIcebergPartitions(MixedTable mixedTable, Set<String> inIcebergNotInHive, Map<String, StructLike> icebergPartitionMap, StructLikeMap<Map<String, String>> partitionProperty) {
        inIcebergNotInHive.forEach(partition -> {
            Map property = (Map)partitionProperty.get(icebergPartitionMap.get(partition));
            if (property == null || property.get("hive-location") == null) {
                return;
            }
            String currentLocation = (String)property.get("hive-location");
            if (mixedTable.io().exists(currentLocation)) {
                int transientTime = Integer.parseInt(property.getOrDefault("transient-time", "0"));
                List<DataFile> dataFiles = HiveMetaSynchronizer.getIcebergPartitionFiles(mixedTable, (StructLike)icebergPartitionMap.get(partition));
                HivePartitionUtil.createPartitionIfAbsent(((SupportHive)mixedTable).getHMSClient(), mixedTable, HivePartitionUtil.partitionValuesAsList((StructLike)icebergPartitionMap.get(partition), mixedTable.spec().partitionType()), currentLocation, dataFiles, transientTime);
            }
        });
    }

    private static void handleInHivePartitions(MixedTable mixedTable, Set<String> inHiveNotInIceberg, Map<String, Partition> hivePartitionMap) {
        inHiveNotInIceberg.forEach(partition -> {
            Partition hivePartition = (Partition)hivePartitionMap.get(partition);
            boolean isMixedTable = CompatibleHivePropertyUtil.propertyAsBoolean(hivePartition.getParameters(), "arctic.enabled", false);
            if (isMixedTable) {
                HivePartitionUtil.dropPartition(((SupportHive)mixedTable).getHMSClient(), mixedTable, hivePartition);
            }
        });
    }

    private static void handleInBothPartitions(MixedTable mixedTable, Set<String> inBoth, Map<String, Partition> hivePartitionMap, Map<String, StructLike> icebergPartitionMap, StructLikeMap<Map<String, String>> partitionProperty) {
        HashSet<String> inHiveNotInIceberg = new HashSet<String>();
        inBoth.forEach(partition -> {
            Partition hivePartition;
            Map property = (Map)partitionProperty.get(icebergPartitionMap.get(partition));
            if (property == null || property.get("hive-location") == null) {
                inHiveNotInIceberg.add((String)partition);
                return;
            }
            String currentLocation = (String)property.get("hive-location");
            if (!Objects.equals(currentLocation, (hivePartition = (Partition)hivePartitionMap.get(partition)).getSd().getLocation())) {
                int transientTime = Integer.parseInt(property.getOrDefault("transient-time", "0"));
                List<DataFile> dataFiles = HiveMetaSynchronizer.getIcebergPartitionFiles(mixedTable, (StructLike)icebergPartitionMap.get(partition));
                HivePartitionUtil.updatePartitionLocation(((SupportHive)mixedTable).getHMSClient(), mixedTable, hivePartition, currentLocation, dataFiles, transientTime);
            }
        });
        HiveMetaSynchronizer.handleInHivePartitions(mixedTable, inHiveNotInIceberg, hivePartitionMap);
    }

    private static List<DataFile> getIcebergPartitionFiles(MixedTable mixedTable, StructLike partition) {
        UnkeyedTable baseStore = mixedTable.isKeyedTable() ? mixedTable.asKeyedTable().baseTable() : mixedTable.asUnkeyedTable();
        ArrayList<DataFile> partitionFiles = new ArrayList<DataFile>();
        mixedTable.io().doAs(() -> {
            try (CloseableIterable fileScanTasks = baseStore.newScan().planFiles();){
                for (FileScanTask fileScanTask : fileScanTasks) {
                    if (!((DataFile)fileScanTask.file()).partition().equals(partition)) continue;
                    partitionFiles.add((DataFile)fileScanTask.file());
                }
            }
            return null;
        });
        return partitionFiles;
    }

    @VisibleForTesting
    static boolean partitionHasModified(UnkeyedTable baseStore, Partition hivePartition, StructLike partitionData) {
        String mixedPartitionLocation;
        String hiveTransientTime = (String)hivePartition.getParameters().get("transient_lastDdlTime");
        String mixedTransientTime = baseStore.partitionProperty().containsKey((Object)partitionData) ? (String)((Map)baseStore.partitionProperty().get((Object)partitionData)).get("transient-time") : null;
        String hiveLocation = hivePartition.getSd().getLocation();
        String string = mixedPartitionLocation = baseStore.partitionProperty().containsKey((Object)partitionData) ? (String)((Map)baseStore.partitionProperty().get((Object)partitionData)).get("hive-location") : null;
        if (mixedPartitionLocation != null && !mixedPartitionLocation.equals(hiveLocation)) {
            return false;
        }
        return mixedTransientTime == null || !mixedTransientTime.equals(hiveTransientTime);
    }

    @VisibleForTesting
    static boolean tableHasModified(UnkeyedTable baseStore, Table table) {
        String mixedPartitionLocation;
        String hiveTransientTime = (String)table.getParameters().get("transient_lastDdlTime");
        StructLikeMap structLikeMap = baseStore.partitionProperty();
        String mixedTransientTime = null;
        if (structLikeMap.get((Object)TablePropertyUtil.EMPTY_STRUCT) != null) {
            mixedTransientTime = (String)((Map)structLikeMap.get((Object)TablePropertyUtil.EMPTY_STRUCT)).get("transient-time");
        }
        String hiveLocation = table.getSd().getLocation();
        String string = mixedPartitionLocation = baseStore.partitionProperty().containsKey((Object)TablePropertyUtil.EMPTY_STRUCT) ? (String)((Map)baseStore.partitionProperty().get((Object)TablePropertyUtil.EMPTY_STRUCT)).get("hive-location") : null;
        if (mixedPartitionLocation != null && !mixedPartitionLocation.equals(hiveLocation)) {
            return false;
        }
        return mixedTransientTime == null || !mixedTransientTime.equals(hiveTransientTime);
    }

    private static List<DataFile> listHivePartitionFiles(SupportHive mixedTable, Map<String, String> partitionValueMap, String partitionLocation) {
        return (List)mixedTable.io().doAs(() -> TableMigrationUtil.listPartition((Map)partitionValueMap, (String)partitionLocation, (String)mixedTable.properties().getOrDefault("write.format.default", "parquet"), (PartitionSpec)mixedTable.spec(), (Configuration)mixedTable.io().getConf(), (MetricsConfig)MetricsConfig.fromProperties((Map)mixedTable.properties()), (NameMapping)NameMappingParser.fromJson((String)((String)mixedTable.properties().get("schema.name-mapping.default")))));
    }

    private static Map<String, String> buildPartitionValueMap(List<String> partitionValues, PartitionSpec spec) {
        HashMap partitionValueMap = Maps.newHashMap();
        for (int i = 0; i < partitionValues.size(); ++i) {
            partitionValueMap.put(((PartitionField)spec.fields().get(i)).name(), partitionValues.get(i));
        }
        return partitionValueMap;
    }

    private static void overwriteTable(MixedTable table, List<DataFile> filesToDelete, List<DataFile> filesToAdd) {
        if (filesToDelete.size() > 0 || filesToAdd.size() > 0) {
            LOG.info("Table {} sync hive data change to the mixed-hive table, delete files: {}, add files {}", new Object[]{table.id(), filesToDelete.stream().map(ContentFile::path).collect(Collectors.toList()), filesToAdd.stream().map(ContentFile::path).collect(Collectors.toList())});
            if (table.isKeyedTable()) {
                long txId = table.asKeyedTable().beginTransaction(null);
                OverwriteBaseFiles overwriteBaseFiles = table.asKeyedTable().newOverwriteBaseFiles();
                overwriteBaseFiles.set("validate-location", "false");
                filesToDelete.forEach(arg_0 -> ((OverwriteBaseFiles)overwriteBaseFiles).deleteFile(arg_0));
                filesToAdd.forEach(arg_0 -> ((OverwriteBaseFiles)overwriteBaseFiles).addFile(arg_0));
                overwriteBaseFiles.updateOptimizedSequenceDynamically(txId);
                overwriteBaseFiles.commit();
            } else {
                OverwriteFiles overwriteFiles = table.asUnkeyedTable().newOverwrite();
                overwriteFiles.set("validate-location", "false");
                filesToDelete.forEach(arg_0 -> ((OverwriteFiles)overwriteFiles).deleteFile(arg_0));
                filesToAdd.forEach(arg_0 -> ((OverwriteFiles)overwriteFiles).addFile(arg_0));
                overwriteFiles.commit();
            }
        }
    }
}

