/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.mixed;

import java.util.ArrayList;
import java.util.Map;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.spark.util.SparkUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public abstract class MixedSourceBase
implements DataSourceRegister,
SupportsCatalogOptions {
    public StructType inferSchema(CaseInsensitiveStringMap options) {
        return null;
    }

    public Identifier extractIdentifier(CaseInsensitiveStringMap options) {
        return MixedSourceBase.catalogAndIdentifier(options).identifier();
    }

    public String extractCatalog(CaseInsensitiveStringMap options) {
        return MixedSourceBase.catalogAndIdentifier(options).catalog().name();
    }

    public Table getTable(StructType schema, Transform[] partitioning, Map<String, String> properties) {
        return null;
    }

    private static SparkUtil.TableCatalogAndIdentifier catalogAndIdentifier(CaseInsensitiveStringMap options) {
        Preconditions.checkArgument((boolean)options.containsKey((Object)"path"), (Object)"Cannot open table: path is not set");
        String path = options.get((Object)"path");
        Preconditions.checkArgument((!path.contains("/") ? 1 : 0) != 0, (String)"invalid table identifier %s, contain '/'", (Object)path);
        ArrayList nameParts = Lists.newArrayList((Object[])path.split("\\."));
        SparkSession spark = SparkSession.active();
        TableCatalog current = (TableCatalog)spark.sessionState().catalogManager().currentCatalog();
        return SparkUtil.catalogAndIdentifier(spark, nameParts, current);
    }
}

