/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.util.function.Supplier;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.Preconditions;

public class LazyGenericRow
implements InternalRow {
    private RowKind kind;
    private final Supplier<Object>[] suppliers;
    private final Object[] fields;
    private final boolean[] initialized;

    public LazyGenericRow(Supplier<Object>[] suppliers) {
        this(RowKind.INSERT, suppliers);
    }

    public LazyGenericRow(RowKind rowKind, Supplier<Object>[] suppliers) {
        this.kind = rowKind;
        this.suppliers = suppliers;
        this.fields = new Object[suppliers.length];
        this.initialized = new boolean[suppliers.length];
    }

    public Object getField(int pos) {
        if (!this.initialized[pos]) {
            this.fields[pos] = this.suppliers[pos].get();
            this.initialized[pos] = true;
        }
        return this.fields[pos];
    }

    @Override
    public int getFieldCount() {
        return this.fields.length;
    }

    @Override
    public RowKind getRowKind() {
        return this.kind;
    }

    @Override
    public void setRowKind(RowKind kind) {
        Preconditions.checkNotNull(kind);
        this.kind = kind;
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.getField(pos) == null;
    }

    @Override
    public boolean getBoolean(int pos) {
        return (Boolean)this.getField(pos);
    }

    @Override
    public byte getByte(int pos) {
        return (Byte)this.getField(pos);
    }

    @Override
    public short getShort(int pos) {
        return (Short)this.getField(pos);
    }

    @Override
    public int getInt(int pos) {
        return (Integer)this.getField(pos);
    }

    @Override
    public long getLong(int pos) {
        return (Long)this.getField(pos);
    }

    @Override
    public float getFloat(int pos) {
        return ((Float)this.getField(pos)).floatValue();
    }

    @Override
    public double getDouble(int pos) {
        return (Double)this.getField(pos);
    }

    @Override
    public BinaryString getString(int pos) {
        return (BinaryString)this.getField(pos);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return (Decimal)this.getField(pos);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return (Timestamp)this.getField(pos);
    }

    @Override
    public byte[] getBinary(int pos) {
        return (byte[])this.getField(pos);
    }

    @Override
    public InternalArray getArray(int pos) {
        return (InternalArray)this.getField(pos);
    }

    @Override
    public InternalMap getMap(int pos) {
        return (InternalMap)this.getField(pos);
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return (InternalRow)this.getField(pos);
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("This row do not support equals, please compare fields one by one!");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("This row do not support equals, please compare fields one by one!");
    }
}

