/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.paimon.memory.Buffer;
import org.apache.paimon.utils.Preconditions;

public class BufferFileChannelReader {
    private final ByteBuffer header = ByteBuffer.allocateDirect(4);
    private final FileChannel fileChannel;

    BufferFileChannelReader(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public boolean readBufferFromFileChannel(Buffer buffer) throws IOException {
        Preconditions.checkArgument(this.fileChannel.size() - this.fileChannel.position() > 0L);
        this.header.clear();
        this.fileChannel.read(this.header);
        this.header.flip();
        int size = this.header.getInt();
        if (size > buffer.getMaxCapacity()) {
            throw new IllegalStateException("Buffer is too small for data: " + buffer.getMaxCapacity() + " bytes available, but " + size + " needed. This is most likely due to an serialized event, which is larger than the buffer size.");
        }
        Preconditions.checkArgument(buffer.getSize() == 0, "Buffer not empty");
        this.fileChannel.read(buffer.getNioBuffer(0, size));
        buffer.setSize(size);
        return this.fileChannel.size() - this.fileChannel.position() == 0L;
    }
}

