/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.predicate;

import java.util.List;
import java.util.Optional;
import org.apache.paimon.predicate.CompareUtils;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.predicate.FunctionVisitor;
import org.apache.paimon.predicate.In;
import org.apache.paimon.predicate.LeafFunction;
import org.apache.paimon.types.DataType;

public class NotIn
extends LeafFunction {
    private static final long serialVersionUID = 1L;
    public static final NotIn INSTANCE = new NotIn();

    private NotIn() {
    }

    @Override
    public boolean test(DataType type, Object field, List<Object> literals) {
        if (field == null) {
            return false;
        }
        for (Object literal : literals) {
            if (literal != null && CompareUtils.compareLiteral(type, literal, field) != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean test(DataType type, long rowCount, Object min, Object max, Long nullCount, List<Object> literals) {
        if (nullCount != null && rowCount == nullCount) {
            return false;
        }
        for (Object literal : literals) {
            if (literal != null && (CompareUtils.compareLiteral(type, literal, min) != 0 || CompareUtils.compareLiteral(type, literal, max) != 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<LeafFunction> negate() {
        return Optional.of(In.INSTANCE);
    }

    @Override
    public <T> T visit(FunctionVisitor<T> visitor, FieldRef fieldRef, List<Object> literals) {
        return visitor.visitNotIn(fieldRef, literals);
    }
}

