/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowUtils;

public class RowDataToObjectArrayConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RowType rowType;
    private final InternalRow.FieldGetter[] fieldGetters;

    public RowDataToObjectArrayConverter(RowType rowType) {
        this.rowType = rowType;
        this.fieldGetters = (InternalRow.FieldGetter[])IntStream.range(0, rowType.getFieldCount()).mapToObj(i -> InternalRowUtils.createNullCheckingFieldGetter(rowType.getTypeAt(i), i)).toArray(InternalRow.FieldGetter[]::new);
    }

    public RowType rowType() {
        return this.rowType;
    }

    public int getArity() {
        return this.fieldGetters.length;
    }

    public GenericRow toGenericRow(InternalRow rowData) {
        return GenericRow.of(this.convert(rowData));
    }

    public Object[] convert(InternalRow rowData) {
        Object[] result = new Object[this.fieldGetters.length];
        for (int i = 0; i < this.fieldGetters.length; ++i) {
            result[i] = this.fieldGetters[i].getFieldOrNull(rowData);
        }
        return result;
    }

    public Predicate createEqualPredicate(BinaryRow binaryRow) {
        PredicateBuilder builder = new PredicateBuilder(this.rowType);
        ArrayList<Predicate> fieldPredicates = new ArrayList<Predicate>();
        Object[] partitionObjects = this.convert(binaryRow);
        for (int i = 0; i < this.getArity(); ++i) {
            Object o = partitionObjects[i];
            fieldPredicates.add(builder.equal(i, o));
        }
        return PredicateBuilder.and(fieldPredicates);
    }
}

