/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io;

import java.util.Map;
import org.apache.amoro.io.AuthenticatedHadoopFileIO;
import org.apache.amoro.io.BasicTableTrashManager;
import org.apache.amoro.io.TableTrashManager;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.base.Strings;
import org.apache.amoro.table.TableIdentifier;

public class TableTrashManagers {
    public static String DEFAULT_TRASH_DIR = ".trash";

    public static TableTrashManager build(TableIdentifier tableIdentifier, String tableLocation, Map<String, String> tableProperties, AuthenticatedHadoopFileIO fileIO) {
        String customTrashRootLocation = tableProperties.get("table-trash.custom-root-location");
        String trashLocation = TableTrashManagers.getTrashLocation(tableIdentifier, tableLocation, customTrashRootLocation);
        return new BasicTableTrashManager(tableIdentifier, fileIO, tableLocation, trashLocation);
    }

    @VisibleForTesting
    public static String getTrashLocation(TableIdentifier tableIdentifier, String tableLocation, String customTrashRootLocation) {
        String trashParentLocation = Strings.isNullOrEmpty((String)customTrashRootLocation) ? tableLocation : TableTrashManagers.getTrashParentLocation(tableIdentifier, customTrashRootLocation);
        return trashParentLocation + "/" + DEFAULT_TRASH_DIR;
    }

    public static String getTrashParentLocation(TableIdentifier tableIdentifier, String customTrashRootLocation) {
        Preconditions.checkNotNull((Object)customTrashRootLocation);
        if (!customTrashRootLocation.endsWith("/")) {
            customTrashRootLocation = customTrashRootLocation + "/";
        }
        return customTrashRootLocation + tableIdentifier.getCatalog() + "/" + tableIdentifier.getDatabase() + "/" + tableIdentifier.getTableName();
    }
}

