/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.reader;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.amoro.io.CloseableIterableWrapper;
import org.apache.amoro.io.CloseablePredicate;
import org.apache.amoro.io.reader.Deletes;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.amoro.shade.guava32.com.google.common.collect.Iterables;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Multimap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Multimaps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.utils.StructLikeSet;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Filter;
import org.apache.iceberg.util.StructProjection;
import org.apache.orc.TypeDescription;
import org.apache.parquet.Preconditions;
import org.apache.parquet.schema.MessageType;

public abstract class DeleteFilter<T> {
    private static final long DEFAULT_SET_FILTER_THRESHOLD = 100000L;
    private static final Schema POS_DELETE_SCHEMA = new Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS});
    private final DataFile dataFile;
    private final List<DeleteFile> posDeletes;
    private final List<DeleteFile> eqDeletes;
    private final Schema requiredSchema;
    private final Accessor<StructLike> posAccessor;
    private List<CloseablePredicate<T>> eqDeletePredicate;
    private Set<Long> positionSet;
    private StructLikeCollections structLikeCollections = StructLikeCollections.DEFAULT;

    protected DeleteFilter(FileScanTask task, Schema tableSchema, Schema requestedSchema, StructLikeCollections structLikeCollections) {
        this(task, tableSchema, requestedSchema);
        this.structLikeCollections = structLikeCollections;
    }

    protected DeleteFilter(FileScanTask task, Schema tableSchema, Schema requestedSchema) {
        this.dataFile = (DataFile)task.file();
        ImmutableList.Builder posDeleteBuilder = ImmutableList.builder();
        ImmutableList.Builder eqDeleteBuilder = ImmutableList.builder();
        block4: for (DeleteFile delete : task.deletes()) {
            switch (delete.content()) {
                case POSITION_DELETES: {
                    posDeleteBuilder.add((Object)delete);
                    continue block4;
                }
                case EQUALITY_DELETES: {
                    eqDeleteBuilder.add((Object)delete);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown delete file content: " + delete.content());
        }
        this.posDeletes = posDeleteBuilder.build();
        this.eqDeletes = eqDeleteBuilder.build();
        this.requiredSchema = DeleteFilter.fileProjection(tableSchema, requestedSchema, this.posDeletes, this.eqDeletes);
        this.posAccessor = this.requiredSchema.accessorForField(MetadataColumns.ROW_POSITION.fieldId());
    }

    public Schema requiredSchema() {
        return this.requiredSchema;
    }

    Accessor<StructLike> posAccessor() {
        return this.posAccessor;
    }

    protected abstract StructLike asStructLike(T var1);

    protected abstract InputFile getInputFile(String var1);

    protected long pos(T record) {
        return (Long)this.posAccessor.get((Object)this.asStructLike(record));
    }

    public CloseableIterable<T> filter(CloseableIterable<T> records) {
        return new CloseableIterableWrapper<T>(this.applyEqDeletes(this.applyPosDeletes(records)), this.eqDeletePredicate == null ? null : this.eqDeletePredicate.toArray(new Closeable[0]));
    }

    private List<CloseablePredicate<T>> applyEqDeletes() {
        if (this.eqDeletePredicate != null) {
            return this.eqDeletePredicate;
        }
        ArrayList isInDeleteSets = Lists.newArrayList();
        if (this.eqDeletes.isEmpty()) {
            this.eqDeletePredicate = isInDeleteSets;
            return isInDeleteSets;
        }
        Multimap filesByDeleteIds = Multimaps.newMultimap((Map)Maps.newHashMap(), Lists::newArrayList);
        for (DeleteFile deleteFile : this.eqDeletes) {
            filesByDeleteIds.put((Object)Sets.newHashSet((Iterable)deleteFile.equalityFieldIds()), (Object)deleteFile);
        }
        for (Map.Entry entry : filesByDeleteIds.asMap().entrySet()) {
            Set ids = (Set)entry.getKey();
            Iterable deletes = (Iterable)entry.getValue();
            Schema deleteSchema = TypeUtil.select((Schema)this.requiredSchema, (Set)ids);
            StructProjection projectRow = StructProjection.create((Schema)this.requiredSchema, (Schema)deleteSchema);
            Iterable deleteRecords = Iterables.transform((Iterable)deletes, delete -> this.openDeletes((DeleteFile)delete, deleteSchema));
            StructLikeSet deleteSet = Deletes.toEqualitySet((CloseableIterable<StructLike>)CloseableIterable.transform((CloseableIterable)CloseableIterable.concat((Iterable)deleteRecords), Record::copy), deleteSchema.asStruct(), this.structLikeCollections);
            Predicate<Object> isInDeleteSet = record -> deleteSet.contains((StructLike)projectRow.wrap(this.asStructLike(record)));
            CloseablePredicate<Object> closeablePredicate = new CloseablePredicate<Object>(isInDeleteSet, deleteSet);
            isInDeleteSets.add(closeablePredicate);
        }
        this.eqDeletePredicate = isInDeleteSets;
        return isInDeleteSets;
    }

    private CloseableIterable<T> applyEqDeletes(CloseableIterable<T> records) {
        final Predicate<Object> remainingRows = this.applyEqDeletes().stream().map(Predicate::negate).reduce(Predicate::and).orElse(t -> true);
        Filter remainingRowsFilter = new Filter<T>(){

            protected boolean shouldKeep(T item) {
                return remainingRows.test(item);
            }
        };
        return remainingRowsFilter.filter(records);
    }

    public CloseableIterable<T> findEqualityDeleteRows(CloseableIterable<T> records) {
        final Predicate<Object> deletedRows = this.applyEqDeletes().stream().map(s -> s).reduce(Predicate::or).orElse(t -> false);
        Filter deletedRowsFilter = new Filter<T>(){

            protected boolean shouldKeep(T item) {
                return deletedRows.test(item);
            }
        };
        return deletedRowsFilter.filter(records);
    }

    private CloseableIterable<T> applyPosDeletes(CloseableIterable<T> records) {
        if (this.posDeletes.isEmpty()) {
            return records;
        }
        List deletes = Lists.transform(this.posDeletes, this::openPosDeletes);
        if (this.positionSet == null) {
            this.positionSet = Deletes.toPositionSet(this.dataFile.path(), (CloseableIterable<? extends StructLike>)CloseableIterable.concat((Iterable)deletes));
        }
        return Deletes.filter(records, this::pos, this.positionSet);
    }

    private CloseableIterable<Record> openPosDeletes(DeleteFile file) {
        return this.openDeletes(file, POS_DELETE_SCHEMA);
    }

    private CloseableIterable<Record> openDeletes(DeleteFile deleteFile, Schema deleteSchema) {
        InputFile input = this.getInputFile(deleteFile.path().toString());
        switch (deleteFile.format()) {
            case AVRO: {
                return Avro.read((InputFile)input).project(deleteSchema).reuseContainers().createReaderFunc(DataReader::create).build();
            }
            case PARQUET: {
                Parquet.ReadBuilder builder = Parquet.read((InputFile)input).project(deleteSchema).reuseContainers().createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)deleteSchema, (MessageType)fileSchema));
                if (deleteFile.content() == FileContent.POSITION_DELETES) {
                    builder.filter((Expression)Expressions.equal((String)MetadataColumns.DELETE_FILE_PATH.name(), (Object)this.dataFile.path()));
                }
                return builder.build();
            }
            case ORC: {
                ORC.ReadBuilder orcBuilder = ORC.read((InputFile)input).project(deleteSchema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)deleteSchema, (TypeDescription)fileSchema));
                if (deleteFile.content() == FileContent.POSITION_DELETES) {
                    orcBuilder.filter((Expression)Expressions.equal((String)MetadataColumns.DELETE_FILE_PATH.name(), (Object)this.dataFile.path()));
                }
                return orcBuilder.build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read deletes, %s is not a supported format: %s", deleteFile.format().name(), deleteFile.path()));
    }

    private static Schema fileProjection(Schema tableSchema, Schema requestedSchema, List<DeleteFile> posDeletes, List<DeleteFile> eqDeletes) {
        if (posDeletes.isEmpty() && eqDeletes.isEmpty()) {
            return requestedSchema;
        }
        LinkedHashSet requiredIds = Sets.newLinkedHashSet();
        if (!posDeletes.isEmpty()) {
            requiredIds.add(MetadataColumns.ROW_POSITION.fieldId());
        }
        for (DeleteFile eqDelete : eqDeletes) {
            requiredIds.addAll(eqDelete.equalityFieldIds());
        }
        requiredIds.add(MetadataColumns.IS_DELETED.fieldId());
        LinkedHashSet missingIds = Sets.newLinkedHashSet((Iterable)Sets.difference((Set)requiredIds, (Set)TypeUtil.getProjectedIds((Schema)requestedSchema)));
        if (missingIds.isEmpty()) {
            return requestedSchema;
        }
        ArrayList columns = Lists.newArrayList((Iterable)requestedSchema.columns());
        Iterator iterator = missingIds.iterator();
        while (iterator.hasNext()) {
            int fieldId = (Integer)iterator.next();
            if (fieldId == MetadataColumns.ROW_POSITION.fieldId() || fieldId == MetadataColumns.IS_DELETED.fieldId()) continue;
            Types.NestedField field = tableSchema.asStruct().field(fieldId);
            Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot find required field for ID %s", (Object)fieldId);
            columns.add(field);
        }
        if (missingIds.contains(MetadataColumns.ROW_POSITION.fieldId())) {
            columns.add(MetadataColumns.ROW_POSITION);
        }
        if (missingIds.contains(MetadataColumns.IS_DELETED.fieldId())) {
            columns.add(MetadataColumns.IS_DELETED);
        }
        return new Schema((List)columns);
    }
}

