/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.reader;

import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.reader.AbstractKeyedDataReader;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.orc.OrcRowReader;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.types.Type;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;

public class GenericKeyedDataReader
extends AbstractKeyedDataReader<Record> {
    public GenericKeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, PrimaryKeySpec primaryKeySpec, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant) {
        super(fileIO, tableSchema, projectedSchema, primaryKeySpec, nameMapping, caseSensitive, convertConstant, false);
    }

    public GenericKeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, PrimaryKeySpec primaryKeySpec, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant, Set<DataTreeNode> sourceNodes, boolean reuseContainer, StructLikeCollections structLikeCollections) {
        super(fileIO, tableSchema, projectedSchema, primaryKeySpec, nameMapping, caseSensitive, convertConstant, sourceNodes, reuseContainer, structLikeCollections);
    }

    public GenericKeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, PrimaryKeySpec primaryKeySpec, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant, Set<DataTreeNode> sourceNodes, boolean reuseContainer) {
        super(fileIO, tableSchema, projectedSchema, primaryKeySpec, nameMapping, caseSensitive, convertConstant, sourceNodes, reuseContainer);
    }

    @Override
    protected Function<MessageType, ParquetValueReader<?>> getParquetReaderFunction(Schema projectSchema, Map<Integer, ?> idToConstant) {
        return fileSchema -> GenericParquetReaders.buildReader((Schema)projectSchema, (MessageType)fileSchema, (Map)idToConstant);
    }

    @Override
    protected Function<TypeDescription, OrcRowReader<?>> getOrcReaderFunction(Schema projectSchema, Map<Integer, ?> idToConstant) {
        return fileSchema -> new GenericOrcReader(projectSchema, fileSchema, idToConstant);
    }

    @Override
    protected Function<Schema, Function<Record, StructLike>> toStructLikeFunction() {
        return schema -> {
            InternalRecordWrapper wrapper = new InternalRecordWrapper(schema.asStruct());
            return arg_0 -> ((InternalRecordWrapper)wrapper).copyFor(arg_0);
        };
    }
}

