/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.writer.CommonOutputFileFactory;
import org.apache.amoro.io.writer.SetTreeNode;
import org.apache.amoro.io.writer.SortedPosDeleteWriter;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileWriter;

public class MixedTreeNodePosDeleteWriter<T>
implements FileWriter<PositionDelete<T>, DeleteWriteResult>,
SetTreeNode {
    private final Map<DataTreeNode, SortedPosDeleteWriter<T>> posDeletes = Maps.newHashMap();
    private SortedPosDeleteWriter<T> currentDeleteWriter;
    private DataTreeNode currentTreeNode;
    private final FileAppenderFactory<T> appenderFactory;
    private final FileFormat format;
    private final StructLike partition;
    private final AuthenticatedFileIO fileIO;
    private final EncryptionManager encryptionManager;
    private final Long transactionId;
    private final String location;
    private final PartitionSpec spec;

    public MixedTreeNodePosDeleteWriter(FileAppenderFactory<T> appenderFactory, FileFormat format, StructLike partition, AuthenticatedFileIO fileIO, EncryptionManager encryptionManager, Long transactionId, String location, PartitionSpec spec) {
        this.appenderFactory = appenderFactory;
        this.format = format;
        this.partition = partition;
        this.fileIO = fileIO;
        this.encryptionManager = encryptionManager;
        this.transactionId = transactionId;
        this.location = location;
        this.spec = spec;
    }

    public long length() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement length");
    }

    public void write(PositionDelete<T> payload) {
        this.delete(payload.path(), payload.pos());
    }

    public void delete(CharSequence path, long pos) {
        if (this.currentDeleteWriter == null) {
            throw new IllegalStateException("Please set tree node first");
        }
        this.currentDeleteWriter.delete(path, pos);
    }

    private SortedPosDeleteWriter<T> generatePosDelete(DataTreeNode treeNode) {
        return new SortedPosDeleteWriter<T>(this.appenderFactory, new CommonOutputFileFactory(this.location, this.spec, this.format, this.fileIO, this.encryptionManager, 0, 0L, this.transactionId), this.fileIO, this.format, treeNode.mask(), treeNode.index(), this.partition);
    }

    public List<DeleteFile> complete() throws IOException {
        ArrayList<DeleteFile> list = new ArrayList<DeleteFile>();
        for (SortedPosDeleteWriter<T> sortedPosDeleteWriter : this.posDeletes.values()) {
            list.addAll(sortedPosDeleteWriter.complete());
        }
        return list;
    }

    public void close() throws IOException {
        for (SortedPosDeleteWriter<T> sortedPosDeleteWriter : this.posDeletes.values()) {
            sortedPosDeleteWriter.close();
        }
    }

    public DeleteWriteResult result() {
        try {
            return new DeleteWriteResult(this.complete());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setTreeNode(DataTreeNode treeNode) {
        if (this.currentTreeNode != null && this.currentTreeNode.equals(treeNode)) {
            return;
        }
        this.currentDeleteWriter = this.posDeletes.computeIfAbsent(treeNode, this::generatePosDelete);
        this.currentTreeNode = treeNode;
    }

    @Override
    public DataTreeNode geTreeNode() {
        return this.currentTreeNode;
    }
}

