/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.amoro.op.PartitionTransactionOperation;
import org.apache.amoro.scan.CombinedScanTask;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.BaseTable;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.amoro.utils.StatisticsFileUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.events.CreateSnapshotEvent;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeMap;

public class OverwriteBaseFiles
extends PartitionTransactionOperation {
    public static final String PROPERTIES_TRANSACTION_ID = "txId";
    private final List<DataFile> deleteFiles;
    private final List<DataFile> addFiles;
    private final List<DeleteFile> deleteDeleteFiles;
    private final List<DeleteFile> addDeleteFiles;
    private Expression deleteExpression = Expressions.alwaysFalse();
    private boolean deleteExpressionApplied = false;
    private final StructLikeMap<Long> partitionOptimizedSequence;
    private Long optimizedSequence;
    private Boolean dynamic;
    private Expression conflictDetectionFilter = null;

    public OverwriteBaseFiles(KeyedTable table) {
        super(table);
        this.deleteFiles = Lists.newArrayList();
        this.addFiles = Lists.newArrayList();
        this.deleteDeleteFiles = Lists.newArrayList();
        this.addDeleteFiles = Lists.newArrayList();
        this.partitionOptimizedSequence = StructLikeMap.create((Types.StructType)table.spec().partitionType());
    }

    public OverwriteBaseFiles overwriteByRowFilter(Expression expr) {
        if (expr != null) {
            this.deleteExpression = Expressions.or((Expression)this.deleteExpression, (Expression)expr);
        }
        return this;
    }

    public OverwriteBaseFiles addFile(DataFile file) {
        this.addFiles.add(file);
        return this;
    }

    public OverwriteBaseFiles addFile(DeleteFile file) {
        this.addDeleteFiles.add(file);
        return this;
    }

    public OverwriteBaseFiles deleteFile(DataFile file) {
        this.deleteFiles.add(file);
        return this;
    }

    public OverwriteBaseFiles deleteFile(DeleteFile file) {
        this.deleteDeleteFiles.add(file);
        return this;
    }

    public OverwriteBaseFiles dynamic(boolean enable) {
        this.dynamic = enable;
        return this;
    }

    public OverwriteBaseFiles updateOptimizedSequence(StructLike partitionData, long sequence) {
        Preconditions.checkArgument((this.dynamic == null || this.dynamic == false ? 1 : 0) != 0, (Object)"updateOptimizedSequenceDynamically() and updateOptimizedSequence() can't be used simultaneously");
        this.partitionOptimizedSequence.put(partitionData, (Object)sequence);
        this.dynamic = false;
        return this;
    }

    public OverwriteBaseFiles updateOptimizedSequenceDynamically(long sequence) {
        Preconditions.checkArgument((this.dynamic == null || this.dynamic != false ? 1 : 0) != 0, (Object)"updateOptimizedSequenceDynamically() and updateOptimizedSequence() can't be used simultaneously");
        this.optimizedSequence = sequence;
        this.dynamic = true;
        return this;
    }

    public OverwriteBaseFiles validateNoConflictingAppends(Expression newConflictDetectionFilter) {
        Preconditions.checkArgument((newConflictDetectionFilter != null ? 1 : 0) != 0, (Object)"Conflict detection filter cannot be null");
        this.conflictDetectionFilter = newConflictDetectionFilter;
        return this;
    }

    @Override
    protected boolean isEmptyCommit() {
        this.applyDeleteExpression();
        return this.deleteFiles.isEmpty() && this.addFiles.isEmpty() && this.deleteDeleteFiles.isEmpty() && this.addDeleteFiles.isEmpty() && this.partitionOptimizedSequence.isEmpty();
    }

    @Override
    protected List<StatisticsFile> apply(Transaction transaction) {
        Preconditions.checkState((this.dynamic != null ? 1 : 0) != 0, (Object)"updateOptimizedSequence() or updateOptimizedSequenceDynamically() must be invoked");
        this.applyDeleteExpression();
        StructLikeMap<Long> sequenceForChangedPartitions = null;
        if (this.dynamic.booleanValue()) {
            sequenceForChangedPartitions = StructLikeMap.create((Types.StructType)transaction.table().spec().partitionType());
        }
        BaseTable baseTable = this.keyedTable.baseTable();
        ArrayList newSnapshots = Lists.newArrayList();
        if (!this.addFiles.isEmpty() || !this.deleteFiles.isEmpty()) {
            OverwriteFiles overwriteFiles = transaction.newOverwrite();
            overwriteFiles.set("optimized-sequence.exist", "true");
            overwriteFiles.set("base-optimized-time.exist", "true");
            if (this.conflictDetectionFilter != null && baseTable.currentSnapshot() != null) {
                overwriteFiles.conflictDetectionFilter(this.conflictDetectionFilter).validateNoConflictingData();
                overwriteFiles.validateFromSnapshot(baseTable.currentSnapshot().snapshotId());
            }
            if (this.dynamic.booleanValue()) {
                for (DataFile dataFile : this.addFiles) {
                    sequenceForChangedPartitions.put(dataFile.partition(), (Object)this.optimizedSequence);
                }
                for (DataFile dataFile : this.deleteFiles) {
                    sequenceForChangedPartitions.put(dataFile.partition(), (Object)this.optimizedSequence);
                }
            }
            this.addFiles.forEach(arg_0 -> ((OverwriteFiles)overwriteFiles).addFile(arg_0));
            this.deleteFiles.forEach(arg_0 -> ((OverwriteFiles)overwriteFiles).deleteFile(arg_0));
            if (this.optimizedSequence != null && this.optimizedSequence > 0L) {
                overwriteFiles.set(PROPERTIES_TRANSACTION_ID, this.optimizedSequence + "");
            }
            if (MapUtils.isNotEmpty((Map)this.properties)) {
                this.properties.forEach((arg_0, arg_1) -> ((OverwriteFiles)overwriteFiles).set(arg_0, arg_1));
            }
            overwriteFiles.commit();
            newSnapshots.add((CreateSnapshotEvent)overwriteFiles.updateEvent());
        }
        if (CollectionUtils.isNotEmpty(this.addDeleteFiles) || CollectionUtils.isNotEmpty(this.deleteDeleteFiles)) {
            if (CollectionUtils.isEmpty(this.deleteDeleteFiles)) {
                RowDelta rowDelta = transaction.newRowDelta();
                rowDelta.set("optimized-sequence.exist", "true");
                rowDelta.set("base-optimized-time.exist", "true");
                if (baseTable.currentSnapshot() != null) {
                    rowDelta.validateFromSnapshot(baseTable.currentSnapshot().snapshotId());
                }
                if (this.dynamic.booleanValue()) {
                    for (DeleteFile deleteFile : this.addDeleteFiles) {
                        sequenceForChangedPartitions.put(deleteFile.partition(), (Object)this.optimizedSequence);
                    }
                }
                this.addDeleteFiles.forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
                if (MapUtils.isNotEmpty((Map)this.properties)) {
                    this.properties.forEach((arg_0, arg_1) -> ((RowDelta)rowDelta).set(arg_0, arg_1));
                }
                rowDelta.commit();
                newSnapshots.add((CreateSnapshotEvent)rowDelta.updateEvent());
            } else {
                RewriteFiles rewriteFiles = transaction.newRewrite();
                rewriteFiles.set("optimized-sequence.exist", "true");
                rewriteFiles.set("base-optimized-time.exist", "true");
                if (baseTable.currentSnapshot() != null) {
                    rewriteFiles.validateFromSnapshot(baseTable.currentSnapshot().snapshotId());
                }
                if (this.dynamic.booleanValue()) {
                    for (DeleteFile deleteFile : this.addDeleteFiles) {
                        sequenceForChangedPartitions.put(deleteFile.partition(), (Object)this.optimizedSequence);
                    }
                    for (DeleteFile deleteFile : this.deleteDeleteFiles) {
                        sequenceForChangedPartitions.put(deleteFile.partition(), (Object)this.optimizedSequence);
                    }
                }
                rewriteFiles.rewriteFiles(Collections.emptySet(), new HashSet<DeleteFile>(this.deleteDeleteFiles), Collections.emptySet(), new HashSet<DeleteFile>(this.addDeleteFiles));
                if (MapUtils.isNotEmpty((Map)this.properties)) {
                    this.properties.forEach((arg_0, arg_1) -> ((RewriteFiles)rewriteFiles).set(arg_0, arg_1));
                }
                rewriteFiles.commit();
                newSnapshots.add((CreateSnapshotEvent)rewriteFiles.updateEvent());
            }
        }
        if (newSnapshots.isEmpty()) {
            return Collections.emptyList();
        }
        long commitTime = System.currentTimeMillis();
        PartitionSpec partitionSpec = transaction.table().spec();
        StructLikeMap<Long> oldOptimizedSequence = MixedTableUtil.readOptimizedSequence(this.keyedTable);
        StructLikeMap<Long> oldOptimizedTime = MixedTableUtil.readBaseOptimizedTime(this.keyedTable);
        StructLikeMap optimizedSequence = StructLikeMap.create((Types.StructType)partitionSpec.partitionType());
        StructLikeMap optimizedTime = StructLikeMap.create((Types.StructType)partitionSpec.partitionType());
        if (oldOptimizedSequence != null) {
            optimizedSequence.putAll(oldOptimizedSequence);
        }
        if (oldOptimizedTime != null) {
            optimizedTime.putAll(oldOptimizedTime);
        }
        StructLikeMap<Long> toChangePartitionSequence = this.dynamic != false ? sequenceForChangedPartitions : this.partitionOptimizedSequence;
        toChangePartitionSequence.forEach((partition, sequence) -> {
            optimizedSequence.put(partition, sequence);
            optimizedTime.put(partition, (Object)commitTime);
        });
        StatisticsFile statisticsFile = null;
        ArrayList result = Lists.newArrayList();
        for (CreateSnapshotEvent newSnapshot : newSnapshots) {
            if (statisticsFile != null) {
                result.add(StatisticsFileUtil.copyToSnapshot(statisticsFile, newSnapshot.snapshotId()));
                continue;
            }
            Table table = transaction.table();
            StatisticsFileUtil.PartitionDataSerializer<Long> dataSerializer = StatisticsFileUtil.createPartitionDataSerializer(table.spec(), Long.class);
            statisticsFile = StatisticsFileUtil.writerBuilder(table).withSnapshotId(newSnapshot.snapshotId()).build().add("optimized-sequence", optimizedSequence, dataSerializer).add("base-optimized-time", optimizedTime, dataSerializer).complete();
            result.add(statisticsFile);
        }
        return result;
    }

    private void applyDeleteExpression() {
        if (this.deleteExpressionApplied) {
            return;
        }
        if (this.deleteExpression == null) {
            return;
        }
        try (CloseableIterable<CombinedScanTask> combinedScanTasks = this.keyedTable.newScan().filter(this.deleteExpression).planTasks();){
            combinedScanTasks.forEach(combinedTask -> combinedTask.tasks().forEach(t -> {
                t.dataTasks().forEach(ft -> this.deleteFiles.add(ft.file()));
                t.mixedEquityDeletes().forEach(ft -> this.deleteFiles.add(ft.file()));
            }));
            this.deleteExpressionApplied = true;
        }
        catch (IOException e) {
            throw new IllegalStateException("failed when apply delete expression when overwrite files", e);
        }
    }
}

