/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.table;

import java.util.List;
import java.util.Map;
import org.apache.amoro.TableFormat;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.op.MixedAppendFiles;
import org.apache.amoro.op.MixedDeleteFiles;
import org.apache.amoro.op.MixedOverwriteFiles;
import org.apache.amoro.op.MixedReplacePartitions;
import org.apache.amoro.op.MixedRewriteFiles;
import org.apache.amoro.op.MixedRowDelta;
import org.apache.amoro.op.MixedTransaction;
import org.apache.amoro.op.PartitionPropertiesUpdate;
import org.apache.amoro.op.UpdatePartitionProperties;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.IncrementalAppendScan;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.UpdateStatistics;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeMap;

public class BasicUnkeyedTable
implements UnkeyedTable,
HasTableOperations {
    private final Map<String, String> catalogProperties;
    private final TableIdentifier tableIdentifier;
    protected final Table icebergTable;
    protected final AuthenticatedFileIO authenticatedFileIO;

    public BasicUnkeyedTable(TableIdentifier tableIdentifier, Table icebergTable, AuthenticatedFileIO authenticatedFileIO, Map<String, String> catalogProperties) {
        this.tableIdentifier = tableIdentifier;
        this.icebergTable = icebergTable;
        this.authenticatedFileIO = authenticatedFileIO;
        this.catalogProperties = catalogProperties;
    }

    @Override
    public void refresh() {
        this.icebergTable.refresh();
    }

    public TableScan newScan() {
        return this.icebergTable.newScan();
    }

    public IncrementalAppendScan newIncrementalAppendScan() {
        return this.icebergTable.newIncrementalAppendScan();
    }

    @Override
    public TableIdentifier id() {
        return this.tableIdentifier;
    }

    @Override
    public TableFormat format() {
        return TableFormat.MIXED_ICEBERG;
    }

    @Override
    public Schema schema() {
        return this.icebergTable.schema();
    }

    @Override
    public String name() {
        return this.icebergTable.name();
    }

    public String toString() {
        return this.name();
    }

    public Map<Integer, Schema> schemas() {
        return this.icebergTable.schemas();
    }

    @Override
    public PartitionSpec spec() {
        return this.icebergTable.spec();
    }

    public Map<Integer, PartitionSpec> specs() {
        return this.icebergTable.specs();
    }

    public SortOrder sortOrder() {
        return this.icebergTable.sortOrder();
    }

    public Map<Integer, SortOrder> sortOrders() {
        return this.icebergTable.sortOrders();
    }

    public UpdateStatistics updateStatistics() {
        return this.icebergTable.updateStatistics();
    }

    @Override
    public Map<String, String> properties() {
        if (this.catalogProperties == null) {
            return this.icebergTable.properties();
        }
        return MixedCatalogUtil.mergeCatalogPropertiesToTable(this.icebergTable.properties(), this.catalogProperties);
    }

    @Override
    public String location() {
        return this.icebergTable.location();
    }

    public Snapshot currentSnapshot() {
        return this.icebergTable.currentSnapshot();
    }

    public Snapshot snapshot(long snapshotId) {
        return this.icebergTable.snapshot(snapshotId);
    }

    public Iterable<Snapshot> snapshots() {
        return this.icebergTable.snapshots();
    }

    public List<HistoryEntry> history() {
        return this.icebergTable.history();
    }

    @Override
    public UpdateSchema updateSchema() {
        return this.icebergTable.updateSchema();
    }

    public UpdatePartitionSpec updateSpec() {
        return this.icebergTable.updateSpec();
    }

    @Override
    public UpdateProperties updateProperties() {
        return this.icebergTable.updateProperties();
    }

    public ReplaceSortOrder replaceSortOrder() {
        return this.icebergTable.replaceSortOrder();
    }

    public UpdateLocation updateLocation() {
        return this.icebergTable.updateLocation();
    }

    public AppendFiles newAppend() {
        return (AppendFiles)MixedAppendFiles.buildFor(this, false).onTableStore(this.icebergTable).build();
    }

    public AppendFiles newFastAppend() {
        return (AppendFiles)MixedAppendFiles.buildFor(this, true).onTableStore(this.icebergTable).build();
    }

    public RewriteFiles newRewrite() {
        return (RewriteFiles)MixedRewriteFiles.buildFor(this).onTableStore(this.icebergTable).build();
    }

    public RewriteManifests rewriteManifests() {
        return this.icebergTable.rewriteManifests();
    }

    public OverwriteFiles newOverwrite() {
        return (OverwriteFiles)MixedOverwriteFiles.buildFor(this).onTableStore(this.icebergTable).build();
    }

    public RowDelta newRowDelta() {
        return (RowDelta)MixedRowDelta.buildFor(this).onTableStore(this.icebergTable).build();
    }

    public ReplacePartitions newReplacePartitions() {
        return (ReplacePartitions)MixedReplacePartitions.buildFor(this).onTableStore(this.icebergTable).build();
    }

    public DeleteFiles newDelete() {
        return (DeleteFiles)MixedDeleteFiles.buildFor(this).onTableStore(this.icebergTable).build();
    }

    public ExpireSnapshots expireSnapshots() {
        return this.icebergTable.expireSnapshots();
    }

    public ManageSnapshots manageSnapshots() {
        return this.icebergTable.manageSnapshots();
    }

    public Transaction newTransaction() {
        Transaction transaction = this.icebergTable.newTransaction();
        return new MixedTransaction(this, transaction);
    }

    @Override
    public AuthenticatedFileIO io() {
        return this.authenticatedFileIO;
    }

    public EncryptionManager encryption() {
        return this.icebergTable.encryption();
    }

    public LocationProvider locationProvider() {
        return this.icebergTable.locationProvider();
    }

    public List<StatisticsFile> statisticsFiles() {
        return this.icebergTable.statisticsFiles();
    }

    public Map<String, SnapshotRef> refs() {
        return this.icebergTable.refs();
    }

    public TableOperations operations() {
        if (this.icebergTable instanceof HasTableOperations) {
            return ((HasTableOperations)this.icebergTable).operations();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public StructLikeMap<Map<String, String>> partitionProperty() {
        String s = (String)this.icebergTable.properties().get("table.partition-properties");
        if (s != null) {
            return TablePropertyUtil.decodePartitionProperties(this.spec(), s);
        }
        return StructLikeMap.create((Types.StructType)this.spec().partitionType());
    }

    @Override
    public UpdatePartitionProperties updatePartitionProperties(Transaction transaction) {
        return new PartitionPropertiesUpdate(this, transaction);
    }
}

