/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.TableMeta;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.op.MixedHadoopTableOperations;
import org.apache.amoro.op.MixedTableOperations;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.TableMetaStore;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.aws.glue.GlueCatalog;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.hadoop.HadoopTableOperations;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedCatalogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MixedCatalogUtil.class);

    public static Set<TableFormat> tableFormats(CatalogMeta meta) {
        return MixedCatalogUtil.tableFormats(meta.getCatalogType(), meta.getCatalogProperties());
    }

    public static Set<TableFormat> tableFormats(String metastoreType, Map<String, String> catalogProperties) {
        if (catalogProperties != null && catalogProperties.containsKey("table-formats")) {
            String tableFormatsProperty = catalogProperties.get("table-formats");
            return Arrays.stream(tableFormatsProperty.split(",")).map(tableFormatString -> TableFormat.valueOf(tableFormatString.trim().toUpperCase(Locale.ROOT))).collect(Collectors.toSet());
        }
        switch (metastoreType) {
            case "ams": {
                return Sets.newHashSet((Object[])new TableFormat[]{TableFormat.MIXED_ICEBERG});
            }
            case "custom": 
            case "hadoop": 
            case "glue": {
                return Sets.newHashSet((Object[])new TableFormat[]{TableFormat.ICEBERG});
            }
            case "hive": {
                return Sets.newHashSet((Object[])new TableFormat[]{TableFormat.MIXED_HIVE});
            }
        }
        throw new IllegalArgumentException("Unsupported catalog type:" + metastoreType);
    }

    public static void mergeCatalogProperties(CatalogMeta meta, Map<String, String> properties) {
        if (meta.getCatalogProperties() == null) {
            meta.setCatalogProperties(Maps.newHashMap());
        }
        if (properties != null) {
            properties.forEach(meta::putToCatalogProperties);
        }
    }

    public static Map<String, String> withIcebergCatalogInitializeProperties(String catalogName, String metastoreType, Map<String, String> properties) {
        HashMap icebergCatalogProperties = Maps.newHashMap(properties);
        icebergCatalogProperties.put("type", metastoreType);
        if ("glue".equals(metastoreType)) {
            icebergCatalogProperties.put("catalog-impl", GlueCatalog.class.getName());
        }
        if ("ams".equalsIgnoreCase(metastoreType)) {
            icebergCatalogProperties.put("warehouse", catalogName);
            if (!icebergCatalogProperties.containsKey("catalog-impl")) {
                icebergCatalogProperties.put("catalog-impl", RESTCatalog.class.getName());
            }
        }
        if ("custom".equalsIgnoreCase(metastoreType)) {
            Preconditions.checkArgument((boolean)icebergCatalogProperties.containsKey("catalog-impl"), (Object)"Custom catalog properties must contains catalog-impl");
        }
        if (icebergCatalogProperties.containsKey("catalog-impl")) {
            icebergCatalogProperties.remove("type");
        }
        return icebergCatalogProperties;
    }

    public static TableMetaStore buildMetaStore(CatalogMeta catalogMeta) {
        String authType;
        boolean loadAuthFromAMS;
        Map<String, String> storageConfigs;
        TableMetaStore.Builder builder = TableMetaStore.builder();
        if (catalogMeta.getStorageConfigs() != null && "Hadoop".equalsIgnoreCase(MixedCatalogUtil.getCompatibleStorageType(storageConfigs = catalogMeta.getStorageConfigs()))) {
            String coreSite = storageConfigs.get("hadoop.core.site");
            String hdfsSite = storageConfigs.get("hadoop.hdfs.site");
            String hiveSite = storageConfigs.get("hive.site");
            builder.withBase64CoreSite(coreSite).withBase64MetaStoreSite(hiveSite).withBase64HdfsSite(hdfsSite);
        }
        if ((loadAuthFromAMS = PropertyUtil.propertyAsBoolean(catalogMeta.getCatalogProperties(), (String)"auth.load-from-ams", (boolean)true)) && catalogMeta.getAuthConfigs() != null) {
            Map<String, String> authConfigs = catalogMeta.getAuthConfigs();
            String authType2 = authConfigs.get("auth.type");
            LOG.info("TableMetaStore use auth config in catalog meta, authType is {}", (Object)authType2);
            if ("simple".equalsIgnoreCase(authType2)) {
                String hadoopUsername = authConfigs.get("auth.simple.hadoop_username");
                builder.withSimpleAuth(hadoopUsername);
            } else if ("kerberos".equalsIgnoreCase(authType2)) {
                String krb5 = authConfigs.get("auth.kerberos.krb5");
                String keytab = authConfigs.get("auth.kerberos.keytab");
                String principal = authConfigs.get("auth.kerberos.principal");
                builder.withBase64KrbAuth(keytab, krb5, principal);
            } else if ("ak/sk".equalsIgnoreCase(authType2)) {
                String accessKey = authConfigs.get("auth.ak_sk.access_key");
                String secretKey = authConfigs.get("auth.ak_sk.secret_key");
                builder.withAkSkAuth(accessKey, secretKey);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(authType = catalogMeta.getCatalogProperties().get("auth.type")))) {
            LOG.info("TableMetaStore use auth config in properties, authType is {}", (Object)authType);
            if ("simple".equalsIgnoreCase(authType)) {
                String hadoopUsername = catalogMeta.getCatalogProperties().get("auth.simple.hadoop_username");
                builder.withSimpleAuth(hadoopUsername);
            } else if ("kerberos".equalsIgnoreCase(authType)) {
                String krb5 = catalogMeta.getCatalogProperties().get("auth.kerberos.krb5");
                String keytab = catalogMeta.getCatalogProperties().get("auth.kerberos.keytab");
                String principal = catalogMeta.getCatalogProperties().get("auth.kerberos.principal");
                builder.withBase64KrbAuth(keytab, krb5, principal);
            } else if ("ak/sk".equalsIgnoreCase(authType)) {
                String accessKey = catalogMeta.getCatalogProperties().get("auth.ak_sk.access_key");
                String secretKey = catalogMeta.getCatalogProperties().get("auth.ak_sk.secret_key");
                builder.withAkSkAuth(accessKey, secretKey);
            }
        }
        return builder.build();
    }

    public static Table useMixedTableOperations(Table table, String tableLocation, AuthenticatedFileIO authenticatedFileIO, Configuration configuration) {
        if (table instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)table;
            if (baseTable.operations() instanceof MixedHadoopTableOperations) {
                return table;
            }
            if (baseTable.operations() instanceof MixedTableOperations) {
                return table;
            }
            if (baseTable.operations() instanceof HadoopTableOperations) {
                return new BaseTable((TableOperations)new MixedHadoopTableOperations(new Path(tableLocation), authenticatedFileIO, configuration), table.name());
            }
            return new BaseTable((TableOperations)new MixedTableOperations(((BaseTable)table).operations(), authenticatedFileIO), table.name());
        }
        return table;
    }

    public static Map<String, String> mergeCatalogPropertiesToTable(Map<String, String> tableProperties, Map<String, String> catalogProperties) {
        String optimizationEnabled;
        Map<String, String> mergedProperties = catalogProperties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("table.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("table.".length()), Map.Entry::getValue));
        if (!PropertyUtil.propertyAsBoolean(tableProperties, (String)"log-store.enabled", (boolean)false)) {
            mergedProperties = mergedProperties.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("log-store.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (!Boolean.parseBoolean(optimizationEnabled = tableProperties.getOrDefault("self-optimizing.enabled", mergedProperties.getOrDefault("self-optimizing.enabled", String.valueOf(true))))) {
            mergedProperties = mergedProperties.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("self-optimizing.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            mergedProperties.put("self-optimizing.enabled", optimizationEnabled);
        }
        mergedProperties.putAll(tableProperties);
        return mergedProperties;
    }

    public static TableIdentifier tableId(TableMeta tableMeta) {
        return TableIdentifier.of(tableMeta.getTableIdentifier().getCatalog(), tableMeta.getTableIdentifier().getDatabase(), tableMeta.getTableIdentifier().getTableName());
    }

    public static org.apache.amoro.api.TableIdentifier amsTaleId(TableIdentifier tableIdentifier) {
        return new org.apache.amoro.api.TableIdentifier(tableIdentifier.getCatalog(), tableIdentifier.getDatabase(), tableIdentifier.getTableName());
    }

    public static String getCompatibleStorageType(Map<String, String> conf) {
        if ("hdfs".equals(conf.get("storage.type"))) {
            return "Hadoop";
        }
        return conf.get("storage.type");
    }

    public static <T> void copyProperty(Map<String, String> fromProperties, Map<String, T> toProperties, String fromKey, String toKey) {
        if (StringUtils.isNotEmpty((CharSequence)fromProperties.get(fromKey))) {
            toProperties.put(toKey, fromProperties.get(fromKey));
        }
    }

    public static Catalog buildCacheCatalog(Catalog catalog, Map<String, String> properties) {
        boolean cacheEnabled = PropertyUtil.propertyAsBoolean(properties, (String)"cache-enabled", (boolean)true);
        boolean cacheCaseSensitive = PropertyUtil.propertyAsBoolean(properties, (String)"cache.case-sensitive", (boolean)true);
        long cacheExpirationIntervalMs = PropertyUtil.propertyAsLong(properties, (String)"cache.expiration-interval-ms", (long)CatalogProperties.CACHE_EXPIRATION_INTERVAL_MS_DEFAULT);
        if (cacheExpirationIntervalMs <= 0L) {
            LOG.warn("Configuration `{}` is {}, less than or equal to 0, then the cache will not take effect.", (Object)"cache.expiration-interval-ms", (Object)cacheExpirationIntervalMs);
            cacheEnabled = false;
        }
        return cacheEnabled ? CachingCatalog.wrap((Catalog)catalog, (boolean)cacheCaseSensitive, (long)cacheExpirationIntervalMs) : catalog;
    }
}

