/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.ChangelogIterator;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;

class RemoveCarryoverIterator
extends ChangelogIterator {
    private final int[] indicesToIdentifySameRow = this.generateIndicesToIdentifySameRow();
    private Row cachedDeletedRow = null;
    private long deletedRowCount = 0L;
    private Row cachedNextRecord = null;

    RemoveCarryoverIterator(Iterator<Row> rowIterator, StructType rowType) {
        super(rowIterator, rowType);
    }

    @Override
    public boolean hasNext() {
        if (this.hasCachedDeleteRow() || this.cachedNextRecord != null) {
            return true;
        }
        return this.rowIterator().hasNext();
    }

    @Override
    public Row next() {
        Row currentRow;
        if (this.returnCachedDeleteRow()) {
            --this.deletedRowCount;
            Row currentRow2 = this.cachedDeletedRow;
            if (this.deletedRowCount == 0L) {
                this.cachedDeletedRow = null;
            }
            return currentRow2;
        }
        if (this.cachedNextRecord != null) {
            currentRow = this.cachedNextRecord;
            this.cachedNextRecord = null;
        } else {
            currentRow = this.rowIterator().next();
        }
        if (this.changeType(currentRow).equals(DELETE) && this.rowIterator().hasNext()) {
            this.cachedDeletedRow = currentRow;
            this.deletedRowCount = 1L;
            Row nextRow = this.rowIterator().next();
            while (nextRow != null && this.cachedDeletedRow != null && this.isSameRecord(this.cachedDeletedRow, nextRow, this.indicesToIdentifySameRow)) {
                if (this.changeType(nextRow).equals(INSERT)) {
                    --this.deletedRowCount;
                    if (this.deletedRowCount == 0L) {
                        this.cachedDeletedRow = null;
                    }
                } else {
                    ++this.deletedRowCount;
                }
                if (this.rowIterator().hasNext()) {
                    nextRow = this.rowIterator().next();
                    continue;
                }
                nextRow = null;
            }
            this.cachedNextRecord = nextRow;
            return null;
        }
        return currentRow;
    }

    private boolean returnCachedDeleteRow() {
        return this.hitBoundary() && this.hasCachedDeleteRow();
    }

    private boolean hitBoundary() {
        return !this.rowIterator().hasNext() || this.cachedNextRecord != null;
    }

    private boolean hasCachedDeleteRow() {
        return this.cachedDeletedRow != null;
    }

    private int[] generateIndicesToIdentifySameRow() {
        HashSet metadataColumnIndices = Sets.newHashSet((Object[])new Integer[]{this.changeTypeIndex()});
        return RemoveCarryoverIterator.generateIndicesToIdentifySameRow(this.rowType().size(), metadataColumnIndices);
    }
}

